/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.util.Objects;
import java.util.Properties;
import org.geowebcache.util.SetSingletonRule;

public class PropertyRule
extends SetSingletonRule<String> {
    final Properties props;
    final String name;

    public static PropertyRule system(String name) {
        return new PropertyRule(System.getProperties(), name);
    }

    public PropertyRule(Properties props, String name) {
        this.props = props;
        this.name = name;
    }

    @Override
    public String getOldValue() {
        return (String)this.oldValue;
    }

    @Override
    public void setValue(String value) {
        if (Objects.nonNull(value)) {
            this.props.setProperty(this.name, value);
        } else {
            this.props.remove(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.props.getProperty(this.name);
    }
}

