/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import org.geowebcache.util.NullURLMangler;
import org.geowebcache.util.URLMangler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NullURLManglerTest {
    private URLMangler urlMangler;

    @Before
    public void setUp() throws Exception {
        this.urlMangler = new NullURLMangler();
    }

    @Test
    public void testBuildURL() {
        String url = this.urlMangler.buildURL("http://foo.example.com", "/foo", "/bar");
        Assert.assertEquals((Object)"http://foo.example.com/foo/bar", (Object)url);
    }

    @Test
    public void testBuildTrailingSlashes() throws Exception {
        String url = this.urlMangler.buildURL("http://foo.example.com/", "/foo/", "/bar");
        Assert.assertEquals((Object)"http://foo.example.com/foo/bar", (Object)url);
    }

    @Test
    public void testBuildNoLeadingSlashes() throws Exception {
        String url = this.urlMangler.buildURL("http://foo.example.com/", "foo/", "bar");
        Assert.assertEquals((Object)"http://foo.example.com/foo/bar", (Object)url);
    }

    @Test
    public void testBuildRootContext() throws Exception {
        String url = this.urlMangler.buildURL("http://foo.example.com/", "/", "/bar");
        Assert.assertEquals((Object)"http://foo.example.com/bar", (Object)url);
    }

    @Test
    public void testBuildNullContext() throws Exception {
        String url = this.urlMangler.buildURL("http://foo.example.com/", null, "/bar");
        Assert.assertEquals((Object)"http://foo.example.com/bar", (Object)url);
    }

    @Test
    public void testBuildEmptyContext() throws Exception {
        String url = this.urlMangler.buildURL("http://foo.example.com/", "", "/bar");
        Assert.assertEquals((Object)"http://foo.example.com/bar", (Object)url);
    }
}

