/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.MimeType;

public class MockWMSSourceHelper
extends WMSSourceHelper {
    private Map<List<Integer>, byte[]> images = new HashMap<List<Integer>, byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, Map<String, String> wmsParams, MimeType expectedMimeType, Resource target) throws GeoWebCacheException {
        int tileH;
        int tileW;
        String format;
        long[][] tiles;
        if (tileRespRecv instanceof ConveyorTile) {
            ConveyorTile conveyorTile = (ConveyorTile)tileRespRecv;
            long[] tileIndex = conveyorTile.getTileIndex();
            tiles = new long[1][1];
            tiles[0] = tileIndex;
            format = conveyorTile.getMimeType().getInternalName().toUpperCase();
            tileW = conveyorTile.getGridSubset().getTileWidth();
            tileH = conveyorTile.getGridSubset().getTileHeight();
        } else {
            WMSMetaTile metaTile = (WMSMetaTile)tileRespRecv;
            tiles = metaTile.getTilesGridPositions();
            format = metaTile.getResponseFormat().getInternalName().toUpperCase();
            GridSubset gridSubset = layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
            tileW = gridSubset.getTileWidth();
            tileH = gridSubset.getTileHeight();
        }
        int width = Integer.parseInt(wmsParams.get("WIDTH"));
        int height = Integer.parseInt(wmsParams.get("HEIGHT"));
        int tilesX = width / tileW;
        int tilesY = height / tileH;
        List<Integer> wh = Arrays.asList(width, height);
        byte[] result = this.images.get(wh);
        if (result == null) {
            Map<List<Integer>, byte[]> map = this.images;
            synchronized (map) {
                result = this.images.get(wh);
                if (result == null) {
                    BufferedImage img = new BufferedImage(width, height, 1);
                    Graphics2D graphics = img.createGraphics();
                    graphics.setColor(Color.LIGHT_GRAY);
                    graphics.fillRect(0, 0, width, height);
                    int tileN = 0;
                    for (int y = 0; y < tilesY; ++y) {
                        for (int x = 0; x < tilesX; ++x) {
                            long[] t = tiles[tileN];
                            ++tileN;
                            int gx = x * tileW;
                            int gy = y * tileH;
                            graphics.setColor(Color.RED);
                            graphics.setStroke(new BasicStroke(2.0f));
                            graphics.drawRect(gx + 1, gy + 1, tileW - 2, tileH - 2);
                        }
                    }
                    graphics.dispose();
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)img, format, output);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    result = output.toByteArray();
                    this.images.put(wh, result);
                }
            }
        }
        try {
            target.transferFrom(Channels.newChannel(new ByteArrayInputStream(result)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

