/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.memory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.StorageBrokerTest;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.file.FileBlobStore;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.MemoryBlobStore;
import org.geowebcache.storage.blobstore.memory.NullBlobStore;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryBlobStoreTest {
    public static final Logger log = Logging.getLogger((String)MemoryBlobStoreTest.class.getName());
    public static final String TEST_BLOB_DIR_NAME = "gwcTestBlobs";
    private CacheProvider cache;
    private MemoryBlobStore mbs;
    private NullBlobStore nbs;
    private BlobStore fbs;

    @After
    public void destroyBlobStores() {
        if (this.mbs != null) {
            this.mbs.destroy();
        }
        if (this.nbs != null) {
            this.nbs.destroy();
        }
        if (this.fbs != null) {
            this.fbs.destroy();
        }
    }

    @Before
    public void initCache() {
        this.cache = new GuavaCacheProvider(new CacheConfiguration());
    }

    @Test
    public void testNullStore() throws Exception {
        this.nbs = new NullBlobStore();
        this.cache.clear();
        this.mbs = new MemoryBlobStore();
        this.mbs.setStore((BlobStore)this.nbs);
        this.mbs.setCacheProvider(this.cache);
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{1L, 2L, 3L};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        TileObject to = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.mbs.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.mbs.get(to2);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to2.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is2 = to2.getBlob().getInputStream();){
            this.checkInputStreams(is, is2);
        }
        TileObject to3 = this.cache.getTileObj(to);
        Assert.assertNotNull((Object)to3);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to3.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is3 = to3.getBlob().getInputStream();){
            this.checkInputStreams(is, is3);
        }
        Assert.assertFalse((boolean)this.nbs.get(to));
    }

    @Test
    public void testTilePut() throws Exception {
        this.fbs = this.setup();
        this.cache.clear();
        this.mbs = new MemoryBlobStore();
        this.mbs.setStore(this.fbs);
        this.mbs.setCacheProvider(this.cache);
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{1L, 2L, 3L};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        TileObject to = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.mbs.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.mbs.get(to2);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to2.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is2 = to2.getBlob().getInputStream();){
            this.checkInputStreams(is, is2);
        }
        TileObject to3 = this.cache.getTileObj(to);
        Assert.assertNotNull((Object)to3);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to3.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is3 = to3.getBlob().getInputStream();){
            this.checkInputStreams(is, is3);
        }
    }

    @Test
    public void testTileDelete() throws Exception {
        this.fbs = this.setup();
        this.cache.clear();
        this.mbs = new MemoryBlobStore();
        this.mbs.setStore(this.fbs);
        this.mbs.setCacheProvider(this.cache);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{5L, 6L, 7L};
        TileObject to = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.mbs.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.mbs.get(to2);
        try (InputStream is = to2.getBlob().getInputStream();
             InputStream is2 = bytes.getInputStream();){
            this.checkInputStreams(is, is2);
        }
        TileObject to3 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.mbs.delete(to3);
        TileObject to4 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        Assert.assertFalse((boolean)this.mbs.get(to4));
        TileObject to5 = this.cache.getTileObj(to);
        Assert.assertNull((Object)to5);
    }

    @Test
    public void testLastModifiedFromFilesystem() throws Exception {
        this.fbs = this.setup();
        this.cache.clear();
        this.mbs = new MemoryBlobStore();
        this.mbs.setStore(this.fbs);
        this.mbs.setCacheProvider(this.cache);
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{1L, 2L, 3L};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        TileObject to = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.mbs.put(to);
        this.mbs.clear();
        TileObject to2 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.mbs.get(to2);
        this.mbs.clear();
        Thread.sleep(1000L);
        TileObject to3 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.mbs.get(to3);
        Assert.assertEquals((long)to2.getCreated(), (long)to3.getCreated());
    }

    private BlobStore setup() throws Exception {
        File fh = new File(StorageBrokerTest.findTempDir() + File.separator + TEST_BLOB_DIR_NAME);
        if (fh.exists()) {
            FileUtils.deleteDirectory((File)fh);
        }
        if (!fh.exists()) {
            Files.createDirectories(fh.toPath(), new FileAttribute[0]);
        }
        return new FileBlobStore(StorageBrokerTest.findTempDir() + File.separator + TEST_BLOB_DIR_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInputStreams(InputStream is, InputStream is2) throws IOException {
        try {
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)is, (InputStream)is2));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                Assert.fail();
            }
            try {
                is2.close();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                Assert.fail();
            }
        }
    }
}

