/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.DiscontinuousTileRange;
import org.geowebcache.storage.RasterMask;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;
import org.geowebcache.storage.TileRangeMask;
import org.geowebcache.util.ServletUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.util.StopWatch;

public class TileRangeIteratorTest {
    static final Logger LOG = Logging.getLogger((String)TileRangeIteratorTest.class.getName());
    private MimeType mimeType;
    private String parameters;
    private GridSet gridSet;
    private GridSubset gridSubSet;
    private long[][] gridCoverages;
    private RasterMask rasterMask;

    @Before
    public void setUp() throws Exception {
        this.mimeType = MimeType.createFromFormat((String)"image/png");
        this.parameters = null;
        this.gridSet = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, false))).getWorldEpsg3857();
        BoundingBox extent = new BoundingBox(0.0, 0.0, 100.0, 100.0);
        boolean alignTopLeft = false;
        int levels = 12;
        Double metersPerUnit = 1.0;
        double pixelSize = 1.0;
        int tileWidth = 100;
        int tileHeight = 100;
        boolean yCoordinateFirst = false;
        this.gridSet = GridSetFactory.createGridSet((String)"TestGridSet", (SRS)SRS.getSRS((int)100000), (BoundingBox)extent, (boolean)alignTopLeft, (int)levels, (Double)metersPerUnit, (double)pixelSize, (int)tileWidth, (int)tileHeight, (boolean)yCoordinateFirst);
        this.gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)this.gridSet);
        this.gridCoverages = this.gridSubSet.getCoverages();
    }

    @Test
    public void testTraverseIndividualZoomLevelsNoMetaTiling() throws Exception {
        int zoomStart = this.gridSubSet.getZoomStart();
        int zoomStop = this.gridSubSet.getZoomStop();
        int[] metaTilingFactors = new int[]{1, 1};
        for (int zLevel = zoomStart; zLevel <= zoomStop; ++zLevel) {
            long tilesProcessed = this.traverseTileRangeIter(1, this.gridCoverages, zLevel, zLevel, metaTilingFactors);
            long expected = this.countMetaTiles(this.gridCoverages, zLevel, zLevel, metaTilingFactors);
            Assert.assertEquals((String)("Expected tile count mismatch at zoom level " + zLevel), (long)expected, (long)tilesProcessed);
        }
    }

    @Test
    public void testTraverseIndividualZoomLevelsNoMetaTilingMultiThreading() throws Exception {
        int zoomStart = this.gridSubSet.getZoomStart();
        int zoomStop = this.gridSubSet.getZoomStop();
        int[] metaTilingFactors = new int[]{1, 1};
        int nThreads = 64;
        StopWatch sw = new StopWatch();
        sw.start();
        long tilesProcessed = this.traverseTileRangeIter(64, this.gridCoverages, zoomStart, zoomStop, metaTilingFactors);
        long expected = this.countMetaTiles(this.gridCoverages, zoomStart, zoomStop, metaTilingFactors);
        Assert.assertEquals((String)("Expected tile count mismatch at zoom level " + zoomStart), (long)expected, (long)tilesProcessed);
        sw.stop();
        LOG.info("64 threads finished in " + sw.getTotalTimeMillis() + " to count " + expected);
    }

    @Test
    public void testTraverseIndividualZoomLevelsMetaTiling() throws Exception {
        int zoomStart = this.gridSubSet.getZoomStart();
        int zoomStop = this.gridSubSet.getZoomStop();
        int[] metaTilingFactors = new int[]{3, 3};
        for (int zLevel = zoomStart; zLevel <= zoomStop; ++zLevel) {
            long tilesProcessed = this.traverseTileRangeIter(1, this.gridCoverages, zLevel, zLevel, metaTilingFactors);
            long expected = this.countMetaTiles(this.gridCoverages, zLevel, zLevel, metaTilingFactors);
            Assert.assertEquals((String)("Expected tile count mismatch at zoom level " + zLevel), (long)expected, (long)tilesProcessed);
        }
    }

    @Test
    public void testWholeRangeMultiThreaded() throws Exception {
        int zoomStart = this.gridSubSet.getZoomStart();
        int zoomStop = this.gridSubSet.getZoomStop();
        int[] metaTilingFactors = new int[]{1, 1};
        int nThreads = 32;
        long tilesProcessed = this.traverseTileRangeIter(nThreads, this.gridCoverages, zoomStart, zoomStop, metaTilingFactors);
        long expected = this.countMetaTiles(this.gridCoverages, zoomStart, zoomStop, metaTilingFactors);
        Assert.assertEquals((long)expected, (long)tilesProcessed);
    }

    @Test
    public void testWholeRangeMultiThreadedMetaTiling() throws Exception {
        int zoomStart = this.gridSubSet.getZoomStart();
        int zoomStop = this.gridSubSet.getZoomStop();
        int[] metaTilingFactors = new int[]{3, 3};
        int nThreads = 32;
        long tilesProcessed = this.traverseTileRangeIter(nThreads, this.gridCoverages, zoomStart, zoomStop, metaTilingFactors);
        long expected = this.countMetaTiles(this.gridCoverages, zoomStart, zoomStop, metaTilingFactors);
        Assert.assertEquals((long)expected, (long)tilesProcessed);
    }

    @Test
    public void testDiscontinuousTileRange() throws Exception {
        this.rasterMask = (RasterMask)EasyMock.createMock(RasterMask.class);
        EasyMock.expect((Object)this.rasterMask.getGridCoverages()).andReturn((Object)this.gridCoverages);
        EasyMock.expect((Object)this.rasterMask.lookup(EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0))).andReturn((Object)Boolean.TRUE);
        EasyMock.expect((Object)this.rasterMask.lookup(EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)1))).andReturn((Object)Boolean.FALSE);
        EasyMock.expect((Object)this.rasterMask.lookup(EasyMock.eq((long)1L), EasyMock.eq((long)0L), EasyMock.eq((int)1))).andReturn((Object)Boolean.FALSE);
        EasyMock.expect((Object)this.rasterMask.lookup(EasyMock.eq((long)0L), EasyMock.eq((long)1L), EasyMock.eq((int)1))).andReturn((Object)Boolean.FALSE);
        EasyMock.expect((Object)this.rasterMask.lookup(EasyMock.eq((long)1L), EasyMock.eq((long)1L), EasyMock.eq((int)1))).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{this.rasterMask});
        boolean zoomStart = false;
        boolean zoomStop = true;
        int[] metaTilingFactors = new int[]{1, 1};
        boolean nThreads = true;
        long tilesProcessed = this.traverseTileRangeIter(1, this.gridCoverages, 0, 1, metaTilingFactors);
        long expected = 2L;
        Assert.assertEquals((long)2L, (long)tilesProcessed);
        EasyMock.verify((Object[])new Object[]{this.rasterMask});
    }

    private long traverseTileRangeIter(int nThreads, long[][] coveredGridLevels, int zoomStart, int zoomStop, int[] metaTilingFactors) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        Object tileRange = this.rasterMask == null ? new TileRange("layer", "gridset", zoomStart, zoomStop, coveredGridLevels, this.mimeType, ServletUtils.queryStringToMap((String)this.parameters)) : new DiscontinuousTileRange("layer", "gridset", zoomStart, zoomStop, (TileRangeMask)this.rasterMask, this.mimeType, ServletUtils.queryStringToMap((String)this.parameters));
        TileRangeIterator tri = new TileRangeIterator(tileRange, metaTilingFactors);
        ArrayList<TileRangeIteratorConsumer> tasks = new ArrayList<TileRangeIteratorConsumer>(nThreads);
        for (int taskN = 0; taskN < nThreads; ++taskN) {
            tasks.add(new TileRangeIteratorConsumer(tri));
        }
        List<Future<Long>> values = executorService.invokeAll(tasks);
        executorService.shutdown();
        try {
            executorService.awaitTermination(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Assert.fail((String)("Executor service timeout: " + ie.getMessage()));
        }
        long totalProcessed = this.sumValues(values);
        return totalProcessed;
    }

    private long sumValues(List<Future<Long>> values) throws InterruptedException, ExecutionException {
        long total = 0L;
        for (Future<Long> value : values) {
            long countedByTask = value.get();
            total += countedByTask;
        }
        return total;
    }

    private long countMetaTiles(long[][] coveredGridLevels, int startZoom, int stopZoom, int[] metaTilingFactors) {
        long count = 0L;
        int metaX = metaTilingFactors[0];
        int metaY = metaTilingFactors[1];
        for (int i = startZoom; i <= stopZoom; ++i) {
            long[] gridBounds = coveredGridLevels[i];
            long boundsMinX = gridBounds[0];
            long boundsMaxX = gridBounds[2];
            long boundsMinY = gridBounds[1];
            long boundsMaxY = gridBounds[3];
            long tilesX = 1L + boundsMaxX - boundsMinX;
            long tilesY = 1L + boundsMaxY - boundsMinY;
            long metaTilesX = (long)Math.ceil((double)tilesX / (double)metaX);
            long metaTilesY = (long)Math.ceil((double)tilesY / (double)metaY);
            long thisLevelMetaTiles = metaTilesX * metaTilesY;
            count += thisLevelMetaTiles;
        }
        return count;
    }

    private static final class TileRangeIteratorConsumer
    implements Callable<Long> {
        private final TileRangeIterator tri;

        private TileRangeIteratorConsumer(TileRangeIterator tri) {
            this.tri = tri;
        }

        @Override
        public Long call() throws Exception {
            long nprocessed = 0L;
            long[] gridLoc = new long[3];
            while (null != (gridLoc = this.tri.nextMetaGridLocation(gridLoc))) {
                ++nprocessed;
            }
            return nprocessed;
        }
    }
}

