/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.File;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.DefaultStorageBroker;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TransientCache;
import org.geowebcache.storage.blobstore.file.FileBlobStore;
import org.junit.Test;

public class StorageBrokerTest {
    static final Logger LOG = Logging.getLogger((String)StorageBrokerTest.class.getName());
    public static final String TEST_DB_NAME = "gwcTestStorageBroker";
    public static final String TEST_BLOB_DIR_NAME = "gwcTestBlobs";
    public static final int THREAD_COUNT = 4;
    public static final long REPEAT_COUNT = 10L;
    public static final long TILE_GET_COUNT = 20000L;
    public static final long TILE_PUT_COUNT = 30000L;
    public static final boolean RUN_PERFORMANCE_TESTS = false;

    @Test
    public void testTileSingleThread() throws Exception {
    }

    @Test
    public void testTileMultiThread() throws Exception {
    }

    private StorageBroker resetAndPrepStorageBroker() throws Exception {
        String blobPath = StorageBrokerTest.findTempDir() + File.separator + TEST_BLOB_DIR_NAME;
        File blobDirs = new File(blobPath);
        if (!blobDirs.exists() && !blobDirs.mkdirs()) {
            throw new StorageException("Unable to create " + blobPath);
        }
        FileBlobStore blobStore = new FileBlobStore(blobPath);
        DefaultStorageBroker sb = new DefaultStorageBroker((BlobStore)blobStore, new TransientCache(100, 1024, 2000L));
        ByteArrayResource blob = new ByteArrayResource(new byte[20480]);
        long startInsert = System.currentTimeMillis();
        int i = 1;
        while ((long)i < 30000L) {
            long tmp = (long)Math.log(i) + 1L;
            long tmp2 = (long)i % tmp;
            long[] xyz = new long[]{tmp2, tmp2, (long)Math.log10(i)};
            TileObject completeObj = TileObject.createCompleteTileObject((String)"test", (long[])xyz, (String)"hefty-gridSet:id1", (String)"image/jpeg", null, (Resource)blob);
            sb.put(completeObj);
            ++i;
        }
        long stopInsert = System.currentTimeMillis();
        LOG.info("30000 inserts took " + (stopInsert - startInsert) + "ms");
        return sb;
    }

    public static String findTempDir() throws Exception {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null || !new File(tmpDir).canWrite()) {
            throw new Exception("Temporary directory " + tmpDir + " does not exist or is not writable.");
        }
        return tmpDir;
    }

    private void runBasicTileTest(StorageBroker sb, long run, String name) throws StorageException {
        long start = System.currentTimeMillis();
        int i = 1;
        while ((long)i < 20000L) {
            long tmp = (long)Math.log(i) + 1L;
            long tmp2 = (long)i % tmp;
            long[] xyz = new long[]{tmp2, tmp2, (long)Math.log10(i)};
            TileObject queryObj2 = TileObject.createQueryTileObject((String)"test", (long[])xyz, (String)"hefty-gridSet:id1", (String)"image/jpeg", null);
            sb.get(queryObj2);
            ++i;
        }
        long stop = System.currentTimeMillis();
        LOG.info(name + " - run " + run + ", 20000 gets took " + Long.toString(stop - start) + "ms");
    }

    public class StorageBrokerTesterThread
    extends Thread {
        StorageBroker sb = null;
        String fail = null;
        String name = null;
        long iterations;

        public StorageBrokerTesterThread(StorageBroker sb, String name, long iterations) {
            this.sb = sb;
            this.name = name;
            this.iterations = iterations;
        }

        @Override
        public void run() {
            try {
                for (long i = 0L; i < this.iterations; ++i) {
                    StorageBrokerTest.this.runBasicTileTest(this.sb, i, this.name);
                }
            }
            catch (Exception e) {
                this.fail = e.getMessage();
            }
        }
    }
}

