/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.IOException;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ConfigurationPersistenceException;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.config.GWCConfigIntegrationTest;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class CompositeBlobStoreConfigurationIntegrationTest
extends GWCConfigIntegrationTest {
    CompositeBlobStore compositeBlobStore;
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public MockWepAppContextRule context = new MockWepAppContextRule();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Override
    @Before
    public void setUpTest() throws Exception {
        super.setUpTest();
        this.compositeBlobStore = new CompositeBlobStore(this.tileLayerDispatcher, new DefaultStorageFinder(this.context.getContextProvider()), this.testSupport.getServerConfiguration(), this.blobStoreAggregator);
    }

    private FileBlobStoreInfo createInfo(String id, boolean isDefault, boolean isEnabled, String baseDirectory, int fileSystemBlockSize) {
        FileBlobStoreInfo c = new FileBlobStoreInfo(id);
        c.setDefault(isDefault);
        c.setEnabled(isEnabled);
        c.setBaseDirectory(baseDirectory);
        c.setFileSystemBlockSize(fileSystemBlockSize);
        return c;
    }

    @Test
    public void testAdd() throws IOException {
        Assert.assertFalse((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
        FileBlobStoreInfo info = this.createInfo("newFileBlobStore", false, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024);
        this.blobStoreAggregator.addBlobStore((BlobStoreInfo)info);
        Assert.assertTrue((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
    }

    @Test
    public void testAddDefault() throws IOException {
        Assert.assertFalse((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
        FileBlobStoreInfo info = this.createInfo("newFileBlobStore", true, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024);
        this.blobStoreAggregator.addBlobStore((BlobStoreInfo)info);
        Assert.assertTrue((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
        Assert.assertEquals(this.compositeBlobStore.blobStores.get("newFileBlobStore"), this.compositeBlobStore.blobStores.get("_DEFAULT_STORE_"));
    }

    @Test
    public void testModify() throws IOException, GeoWebCacheException {
        this.testAdd();
        BlobStore oldLiveInstance = ((CompositeBlobStore.LiveStore)this.compositeBlobStore.blobStores.get((Object)"newFileBlobStore")).liveInstance;
        FileBlobStoreInfo info = (FileBlobStoreInfo)this.blobStoreAggregator.getBlobStore("newFileBlobStore");
        info.setFileSystemBlockSize(2048);
        this.blobStoreAggregator.modifyBlobStore((BlobStoreInfo)info);
        Assert.assertTrue((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
        Assert.assertNotEquals((Object)oldLiveInstance, (Object)((CompositeBlobStore.LiveStore)this.compositeBlobStore.blobStores.get((Object)"newFileBlobStore")).liveInstance);
    }

    @Test
    public void testModifyDefault() throws IOException, GeoWebCacheException {
        this.testAddDefault();
        BlobStore oldLiveInstance = ((CompositeBlobStore.LiveStore)this.compositeBlobStore.blobStores.get((Object)"newFileBlobStore")).liveInstance;
        FileBlobStoreInfo info = (FileBlobStoreInfo)this.blobStoreAggregator.getBlobStore("newFileBlobStore");
        info.setFileSystemBlockSize(2048);
        this.blobStoreAggregator.modifyBlobStore((BlobStoreInfo)info);
        Assert.assertTrue((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
        Assert.assertNotEquals((Object)oldLiveInstance, (Object)((CompositeBlobStore.LiveStore)this.compositeBlobStore.blobStores.get((Object)"newFileBlobStore")).liveInstance);
        Assert.assertEquals(this.compositeBlobStore.blobStores.get("newFileBlobStore"), this.compositeBlobStore.blobStores.get("_DEFAULT_STORE_"));
    }

    @Test
    public void testModifySetDefault() throws IOException, GeoWebCacheException {
        this.testAdd();
        FileBlobStoreInfo info = (FileBlobStoreInfo)this.blobStoreAggregator.getBlobStore("newFileBlobStore");
        info.setDefault(true);
        this.blobStoreAggregator.modifyBlobStore((BlobStoreInfo)info);
        Assert.assertTrue((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
        Assert.assertEquals(this.compositeBlobStore.blobStores.get("newFileBlobStore"), this.compositeBlobStore.blobStores.get("_DEFAULT_STORE_"));
    }

    @Test
    public void testRename() throws IOException, GeoWebCacheException {
        this.testAdd();
        this.blobStoreAggregator.renameBlobStore("newFileBlobStore", "renamedFileBlobStore");
        Assert.assertFalse((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
        Assert.assertTrue((boolean)this.compositeBlobStore.blobStores.containsKey("renamedFileBlobStore"));
    }

    @Test
    public void testRenameDefault() throws IOException, GeoWebCacheException {
        this.testAddDefault();
        this.blobStoreAggregator.renameBlobStore("newFileBlobStore", "renamedFileBlobStore");
        Assert.assertFalse((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
        Assert.assertTrue((boolean)this.compositeBlobStore.blobStores.containsKey("renamedFileBlobStore"));
        Assert.assertEquals(this.compositeBlobStore.blobStores.get("renamedFileBlobStore"), this.compositeBlobStore.blobStores.get("_DEFAULT_STORE_"));
    }

    @Test
    public void testRemove() throws IOException {
        this.testAdd();
        this.blobStoreAggregator.removeBlobStore("newFileBlobStore");
        Assert.assertFalse((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
    }

    @Ignore
    @Test
    public void testRemoveDefault() throws IOException {
        this.testAddDefault();
        try {
            this.exception.expect(ConfigurationPersistenceException.class);
            this.exception.expectCause(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationException.class), (Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.containsString((String)"default blob store can't be removed"))));
            this.blobStoreAggregator.removeBlobStore("newFileBlobStore");
        }
        finally {
            Assert.assertTrue((boolean)this.compositeBlobStore.blobStores.containsKey("newFileBlobStore"));
            Assert.assertTrue((boolean)this.blobStoreAggregator.blobStoreExists("newFileBlobStore"));
        }
    }
}

