/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.easymock.EasyMock;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageBrokerTest;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FileBlobStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BlobStoreTest {
    public static final String TEST_BLOB_DIR_NAME = "gwcTestBlobs";
    private BlobStore fbs;

    @After
    public void tearDown() throws Exception {
        File fh;
        if (this.fbs != null) {
            this.fbs.destroy();
        }
        if ((fh = new File(StorageBrokerTest.findTempDir() + File.separator + TEST_BLOB_DIR_NAME)).exists()) {
            FileUtils.deleteDirectory((File)fh);
            if (fh.exists()) {
                Assert.fail((String)("Could not cleanup blob store directory\nUnable to delete " + org.geowebcache.util.FileUtils.printFileTree((File)fh)));
            }
        }
    }

    @Test
    public void testTile() throws Exception {
        this.fbs = this.setup();
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{1L, 2L, 3L};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        TileObject to = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.fbs.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.fbs.get(to2);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to2.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is2 = to2.getBlob().getInputStream();){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)is, (InputStream)is2));
        }
    }

    @Test
    public void testTileDelete() throws Exception {
        this.fbs = this.setup();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{5L, 6L, 7L};
        TileObject to = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.fbs.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.fbs.get(to2);
        try (InputStream is = to2.getBlob().getInputStream();
             InputStream is2 = bytes.getInputStream();){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)is, (InputStream)is2));
        }
        TileObject to3 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.fbs.delete(to3);
        TileObject to4 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        Assert.assertFalse((boolean)this.fbs.get(to4));
    }

    @Test
    public void testTilRangeDelete() throws Exception {
        this.fbs = this.setup();
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        ImageMime mime = ImageMime.png;
        SRS srs = SRS.getEPSG4326();
        String layerName = "test:123123 112";
        int zoomLevel = 7;
        int x = 25;
        int y = 6;
        TileObject[] tos = new TileObject[6];
        for (int i = 0; i < tos.length; ++i) {
            long[] xyz = new long[]{x + i - 1, y, zoomLevel};
            tos[i] = TileObject.createCompleteTileObject((String)layerName, (long[])xyz, (String)srs.toString(), (String)mime.getFormat(), parameters, (Resource)bytes);
            this.fbs.put(tos[i]);
        }
        long[][] rangeBounds = new long[zoomLevel + 2][5];
        int zoomStart = zoomLevel - 1;
        int zoomStop = zoomLevel + 1;
        long[] range = new long[]{x, y, x + tos.length - 3, y, zoomLevel};
        rangeBounds[zoomLevel] = range;
        TileRange trObj = new TileRange(layerName, srs.toString(), zoomStart, zoomStop, rangeBounds, (MimeType)mime, parameters);
        this.fbs.delete(trObj);
        TileObject firstTO = TileObject.createQueryTileObject((String)layerName, (long[])tos[0].xyz, (String)srs.toString(), (String)mime.getFormat(), parameters);
        this.fbs.get(firstTO);
        try (InputStream is = firstTO.getBlob().getInputStream();
             InputStream is2 = bytes.getInputStream();){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)is, (InputStream)is2));
        }
        TileObject lastTO = TileObject.createQueryTileObject((String)layerName, (long[])tos[tos.length - 1].xyz, (String)srs.toString(), (String)mime.getFormat(), parameters);
        this.fbs.get(lastTO);
        try (InputStream is = lastTO.getBlob().getInputStream();
             InputStream is2 = bytes.getInputStream();){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)is, (InputStream)is2));
        }
        TileObject midTO = TileObject.createQueryTileObject((String)layerName, (long[])tos[(tos.length - 1) / 2].xyz, (String)srs.toString(), (String)mime.getFormat(), parameters);
        this.fbs.get(midTO);
        Resource res = midTO.getBlob();
        Assert.assertNull((Object)res);
    }

    @Test
    public void testRenameLayer() throws Exception {
        this.fbs = this.setup();
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        ImageMime mime = ImageMime.png;
        SRS srs = SRS.getEPSG4326();
        String layerName = "test:123123 112";
        int zoomLevel = 7;
        int x = 25;
        int y = 6;
        TileObject[] tos = new TileObject[6];
        for (int i = 0; i < tos.length; ++i) {
            long[] xyz = new long[]{x + i - 1, y, zoomLevel};
            tos[i] = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)srs.toString(), (String)mime.getFormat(), parameters, (Resource)bytes);
            this.fbs.put(tos[i]);
        }
        String newLayerName = "modifiedLayerName";
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        listener.layerRenamed((String)EasyMock.eq((Object)"test:123123 112"), (String)EasyMock.eq((Object)"modifiedLayerName"));
        EasyMock.replay((Object[])new Object[]{listener});
        this.fbs.addListener(listener);
        boolean renamed = this.fbs.rename("test:123123 112", "modifiedLayerName");
        Assert.assertTrue((boolean)renamed);
        EasyMock.verify((Object[])new Object[]{listener});
        try {
            this.fbs.rename("test:123123 112", "modifiedLayerName");
            Assert.fail((String)"Expected StorageException, target dir already exists");
        }
        catch (StorageException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    public BlobStore setup() throws Exception {
        File fh = new File(StorageBrokerTest.findTempDir() + File.separator + TEST_BLOB_DIR_NAME);
        if (!fh.exists()) {
            Files.createDirectory(fh.toPath(), new FileAttribute[0]);
            if (!fh.exists()) {
                throw new StorageException("Unable to create " + fh.getAbsolutePath() + "\nUnable to create " + org.geowebcache.util.FileUtils.printFileTree((File)fh));
            }
        }
        return new FileBlobStore(StorageBrokerTest.findTempDir() + File.separator + TEST_BLOB_DIR_NAME);
    }

    @Test
    public void testLayerMetadata() throws Exception {
        this.fbs = this.setup();
        String layerName = "TestLayer";
        String key1 = "Test.Metadata.Property_1";
        String key2 = "Test.Metadata.Property_2";
        Assert.assertNull((Object)this.fbs.getLayerMetadata("TestLayer", "Test.Metadata.Property_1"));
        Assert.assertNull((Object)this.fbs.getLayerMetadata("TestLayer", "Test.Metadata.Property_2"));
        this.fbs.putLayerMetadata("TestLayer", "Test.Metadata.Property_1", "value 1");
        this.fbs.putLayerMetadata("TestLayer", "Test.Metadata.Property_2", "value 2");
        Assert.assertEquals((Object)"value 1", (Object)this.fbs.getLayerMetadata("TestLayer", "Test.Metadata.Property_1"));
        Assert.assertEquals((Object)"value 2", (Object)this.fbs.getLayerMetadata("TestLayer", "Test.Metadata.Property_2"));
        this.fbs.putLayerMetadata("TestLayer", "Test.Metadata.Property_1", "value 1_1");
        this.fbs.putLayerMetadata("TestLayer", "Test.Metadata.Property_2", null);
        Assert.assertEquals((Object)"value 1_1", (Object)this.fbs.getLayerMetadata("TestLayer", "Test.Metadata.Property_1"));
        Assert.assertNull((Object)this.fbs.getLayerMetadata("TestLayer", "Test.Metadata.Property_2"));
    }
}

