/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.SuitabilityCheckRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public abstract class BlobStoreSuitabilityTest {
    @Rule
    public SuitabilityCheckRule suitability = SuitabilityCheckRule.system();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    static final Class<? extends Exception> EXCEPTION_CLASS = StorageException.class;

    protected abstract Matcher<Object> existing();

    protected abstract Matcher<Object> empty();

    public abstract BlobStore create(Object var1) throws Exception;

    @Theory
    public void emptyOk(Object persistenceLocation) throws Exception {
        this.suitability.setValue(CompositeBlobStore.StoreSuitabilityCheck.EMPTY);
        Assume.assumeThat((Object)persistenceLocation, this.empty());
        BlobStore store = this.create(persistenceLocation);
        Assert.assertThat((Object)store, (Matcher)Matchers.notNullValue(BlobStore.class));
    }

    @Theory
    public void emptyFail(Object persistenceLocation) throws Exception {
        this.suitability.setValue(CompositeBlobStore.StoreSuitabilityCheck.EMPTY);
        Assume.assumeThat((Object)persistenceLocation, (Matcher)Matchers.not(this.empty()));
        this.exception.expect(EXCEPTION_CLASS);
        BlobStore store = this.create(persistenceLocation);
    }

    @Theory
    public void existingOk(Object persistenceLocation) throws Exception {
        this.suitability.setValue(CompositeBlobStore.StoreSuitabilityCheck.EXISTING);
        Assume.assumeThat((Object)persistenceLocation, (Matcher)Matchers.either(this.empty()).or(this.existing()));
        BlobStore store = this.create(persistenceLocation);
        Assert.assertThat((Object)store, (Matcher)Matchers.notNullValue(BlobStore.class));
    }

    @Theory
    public void existingFail(Object persistenceLocation) throws Exception {
        this.suitability.setValue(CompositeBlobStore.StoreSuitabilityCheck.EXISTING);
        Assume.assumeThat((Object)persistenceLocation, (Matcher)Matchers.not((Matcher)Matchers.either(this.empty()).or(this.existing())));
        this.exception.expect(EXCEPTION_CLASS);
        BlobStore store = this.create(persistenceLocation);
    }

    @Theory
    public void noneOk(Object persistenceLocation) throws Exception {
        this.suitability.setValue(CompositeBlobStore.StoreSuitabilityCheck.NONE);
        BlobStore store = this.create(persistenceLocation);
        Assert.assertThat((Object)store, (Matcher)Matchers.notNullValue(BlobStore.class));
    }
}

