/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.TestHelpers;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.SeedTask;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;
import org.geowebcache.util.MockWMSSourceHelper;
import org.geowebcache.util.Sleeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeedTaskTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSeedWMSRequests() throws Exception {
        WMSLayer tl = TestHelpers.createWMSLayer("image/png");
        final byte[] fakeWMSResponse = TestHelpers.createFakeSourceImage(tl);
        WMSSourceHelper mockSourceHelper = (WMSSourceHelper)EasyMock.createMock(WMSSourceHelper.class);
        final AtomicInteger wmsRequestsCounter = new AtomicInteger();
        Capture wmsRequestsCapturer = EasyMock.newCapture();
        final Capture resourceCapturer = EasyMock.newCapture();
        IAnswer<Void> answer = new IAnswer<Void>(){

            public Void answer() throws Throwable {
                wmsRequestsCounter.incrementAndGet();
                try {
                    ((Resource)resourceCapturer.getValue()).transferFrom(Channels.newChannel(new ByteArrayInputStream(fakeWMSResponse)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        };
        mockSourceHelper.makeRequest((WMSMetaTile)EasyMock.capture((Capture)wmsRequestsCapturer), (Resource)EasyMock.capture((Capture)resourceCapturer));
        EasyMock.expectLastCall().andAnswer((IAnswer)answer).anyTimes();
        mockSourceHelper.makeRequest((WMSMetaTile)EasyMock.capture((Capture)wmsRequestsCapturer), (Resource)EasyMock.capture((Capture)resourceCapturer));
        mockSourceHelper.makeRequest((WMSMetaTile)EasyMock.capture((Capture)wmsRequestsCapturer), (Resource)EasyMock.capture((Capture)resourceCapturer));
        mockSourceHelper.setConcurrency(32);
        mockSourceHelper.setBackendTimeout(120);
        EasyMock.replay((Object[])new Object[]{mockSourceHelper});
        tl.setSourceHelper(mockSourceHelper);
        int zoomLevel = 4;
        SeedRequest req = TestHelpers.createRequest(tl, GWCTask.TYPE.SEED, 4, 4);
        TileRange tr = TileBreeder.createTileRange((SeedRequest)req, (TileLayer)tl);
        TileRangeIterator trIter = new TileRangeIterator(tr, tl.getMetaTilingFactors());
        StorageBroker mockStorageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        EasyMock.expect((Object)mockStorageBroker.put((TileObject)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)mockStorageBroker.get((TileObject)EasyMock.anyObject())).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockStorageBroker});
        boolean reseed = false;
        SeedTask seedTask = new SeedTask(mockStorageBroker, trIter, (TileLayer)tl, reseed, false);
        seedTask.setTaskId(1L);
        seedTask.setThreadInfo(new AtomicInteger(), 0);
        Sleeper sleeper = (Sleeper)EasyMock.createMock(Sleeper.class);
        EasyMock.replay((Object[])new Object[]{sleeper});
        seedTask.sleeper = sleeper;
        Thread.currentThread().setName("pool-fake-thread-1");
        seedTask.doAction();
        long expectedWmsRequestsCount = 3L;
        long wmsRequestCount = wmsRequestsCounter.get();
        Assert.assertEquals((long)3L, (long)wmsRequestCount);
        EasyMock.verify((Object[])new Object[]{sleeper});
    }

    @Test
    public void testSeedRetries() throws Exception {
        WMSLayer tl = TestHelpers.createWMSLayer("image/png");
        final byte[] fakeWMSResponse = TestHelpers.createFakeSourceImage(tl);
        MockWMSSourceHelper mockSourceHelper = new MockWMSSourceHelper(){
            private int numCalls;

            @Override
            protected void makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, Map<String, String> wmsParams, MimeType expectedMimeType, Resource target) throws GeoWebCacheException {
                ++this.numCalls;
                switch (this.numCalls) {
                    case 1: {
                        throw new GeoWebCacheException("test exception");
                    }
                    case 2: {
                        throw new RuntimeException("test unexpected exception");
                    }
                    case 3: {
                        throw new GeoWebCacheException("second test exception");
                    }
                    case 4: {
                        throw new RuntimeException("second test unexpected exception");
                    }
                }
                try {
                    target.transferFrom(Channels.newChannel(new ByteArrayInputStream(fakeWMSResponse)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        tl.setSourceHelper((WMSSourceHelper)mockSourceHelper);
        int zoomLevel = 4;
        SeedRequest req = TestHelpers.createRequest(tl, GWCTask.TYPE.SEED, 4, 4);
        TileRange tr = TileBreeder.createTileRange((SeedRequest)req, (TileLayer)tl);
        TileRangeIterator trIter = new TileRangeIterator(tr, tl.getMetaTilingFactors());
        StorageBroker mockStorageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        EasyMock.expect((Object)mockStorageBroker.put((TileObject)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)mockStorageBroker.get((TileObject)EasyMock.anyObject())).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockStorageBroker});
        long tileFailureRetryWaitTime = 10L;
        int tileFailureRetryCount = 1;
        long totalFailuresBeforeAborting = 4L;
        boolean reseed = false;
        SeedTask seedTask = new SeedTask(mockStorageBroker, trIter, (TileLayer)tl, reseed, false);
        seedTask.setTaskId(1L);
        seedTask.setThreadInfo(new AtomicInteger(), 0);
        Sleeper sleeper = (Sleeper)EasyMock.createMock(Sleeper.class);
        sleeper.sleep(tileFailureRetryWaitTime);
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{sleeper});
        seedTask.sleeper = sleeper;
        AtomicLong sharedFailureCounter = new AtomicLong();
        seedTask.setFailurePolicy(tileFailureRetryCount, tileFailureRetryWaitTime, totalFailuresBeforeAborting, sharedFailureCounter);
        Thread.currentThread().setName("pool-fake-thread-1");
        seedTask.doAction();
        Assert.assertEquals((long)totalFailuresBeforeAborting, (long)sharedFailureCounter.get());
        EasyMock.verify((Object[])new Object[]{sleeper});
    }

    @Test
    public void testSeedStoredTiles() throws Exception {
        WMSLayer tl = TestHelpers.createWMSLayer("image/png");
        MockWMSSourceHelper mockSourceHelper = new MockWMSSourceHelper();
        tl.setSourceHelper((WMSSourceHelper)mockSourceHelper);
        String gridSetId = (String)tl.getGridSubsets().iterator().next();
        int zoomLevel = 2;
        SeedRequest req = TestHelpers.createRequest(tl, GWCTask.TYPE.SEED, 2, 2);
        StorageBroker mockStorageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        Capture storedObjects = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)mockStorageBroker.put((TileObject)EasyMock.capture((Capture)storedObjects))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)mockStorageBroker.get((TileObject)EasyMock.anyObject())).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockStorageBroker});
        TileRange tr = TileBreeder.createTileRange((SeedRequest)req, (TileLayer)tl);
        TileRangeIterator trIter = new TileRangeIterator(tr, tl.getMetaTilingFactors());
        boolean reseed = false;
        SeedTask task = new SeedTask(mockStorageBroker, trIter, (TileLayer)tl, reseed, false);
        task.setTaskId(1L);
        task.setThreadInfo(new AtomicInteger(), 0);
        Sleeper sleeper = (Sleeper)EasyMock.createMock(Sleeper.class);
        EasyMock.replay((Object[])new Object[]{sleeper});
        task.sleeper = sleeper;
        Thread.currentThread().setName("pool-fake-thread-1");
        task.doAction();
        GridSubset gridSubset = tl.getGridSubset(gridSetId);
        long[] coveredGridLevels = gridSubset.getCoverage(2);
        long starty = coveredGridLevels[1];
        long startx = coveredGridLevels[0];
        long expectedSavedTileCount = (coveredGridLevels[2] - startx + 1L) * (coveredGridLevels[3] - starty + 1L);
        List storedTiles = storedObjects.getValues();
        int seededTileCount = storedTiles.size();
        Assert.assertEquals((long)expectedSavedTileCount, (long)seededTileCount);
        TreeSet<Tuple> tileKeys = new TreeSet<Tuple>();
        TreeSet<Tuple> expectedTiles = new TreeSet<Tuple>();
        for (long x = startx; x <= coveredGridLevels[2]; ++x) {
            for (long y = starty; y <= coveredGridLevels[3]; ++y) {
                expectedTiles.add(new Tuple((Comparable[])new Long[]{x, y, 2L}));
            }
        }
        for (TileObject obj : storedTiles) {
            tileKeys.add(new Tuple((Comparable[])new Long[]{obj.getXYZ()[0], obj.getXYZ()[1], obj.getXYZ()[2]}));
        }
        Assert.assertEquals(expectedTiles, tileKeys);
        EasyMock.verify((Object[])new Object[]{sleeper});
    }

    private static class Tuple<T extends Comparable<T>>
    implements Comparable<Tuple<T>> {
        private T[] members;

        @SafeVarargs
        public Tuple(T ... members) {
            this.members = members;
        }

        @Override
        public int compareTo(Tuple<T> o) {
            int comparedVal;
            if (this.members == null) {
                if (o.members == null) {
                    return 0;
                }
                return -1;
            }
            if (o.members == null) {
                return 1;
            }
            if (this.members.length == 0 && o.members.length == 0) {
                return 0;
            }
            if (this.members.length != o.members.length) {
                throw new IllegalArgumentException("Tuples shall be of the same dimension");
            }
            for (int i = 0; i < this.members.length && (comparedVal = this.members[i].compareTo(o.members[i])) == 0; ++i) {
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Tuple)) {
                return false;
            }
            return 0 == this.compareTo((Tuple)o);
        }

        public int hashCode() {
            return 17 * Arrays.hashCode(this.members);
        }
    }
}

