/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.TestHelpers;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.TileLayerTest;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;
import org.geowebcache.storage.TransientCache;
import org.geowebcache.util.MockLockProvider;
import org.geowebcache.util.MockWMSSourceHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class WMSLayerTest
extends TileLayerTest {
    private final GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));

    @After
    public void tearDown() throws Exception {
        TestHelpers.mockProvider.verify();
        TestHelpers.mockProvider.clear();
    }

    @Test
    public void testSeedMetaTiled() throws Exception {
        WMSLayer layer = TestHelpers.createWMSLayer("image/png");
        MockWMSSourceHelper mockSourceHelper = new MockWMSSourceHelper();
        MockLockProvider lockProvider = new MockLockProvider();
        layer.setSourceHelper((WMSSourceHelper)mockSourceHelper);
        layer.setLockProvider((LockProvider)lockProvider);
        StorageBroker mockStorageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        Capture captured = EasyMock.newCapture();
        EasyMock.expect((Object)mockStorageBroker.put((TileObject)EasyMock.capture((Capture)captured))).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockStorageBroker});
        String layerId = layer.getName();
        MockHttpServletRequest servletReq = new MockHttpServletRequest();
        MockHttpServletResponse servletResp = new MockHttpServletResponse();
        long[] gridLoc = new long[]{0L, 0L, 0L};
        MimeType mimeType = (MimeType)layer.getMimeTypes().get(0);
        GridSet gridSet = this.gridSetBroker.getWorldEpsg4326();
        String gridSetId = gridSet.getName();
        ConveyorTile tile = new ConveyorTile(mockStorageBroker, layerId, gridSetId, gridLoc, mimeType, null, (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        boolean tryCache = false;
        layer.seedTile(tile, tryCache);
        Assert.assertEquals((long)1L, (long)captured.getValues().size());
        TileObject value = (TileObject)captured.getValue();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"image/png", (Object)value.getBlobFormat());
        Assert.assertNotNull((Object)value.getBlob());
        Assert.assertTrue((value.getBlob().getSize() > 0L ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{mockStorageBroker});
        lockProvider.verify();
        lockProvider.clear();
    }

    @Test
    public void testSeedJpegPngMetaTiled() throws Exception {
        this.checkJpegPng("image/vnd.jpeg-png", (IAnswer<Boolean>)((IAnswer)() -> {
            TileObject to = (TileObject)EasyMock.getCurrentArguments()[0];
            Assert.assertEquals((Object)"image/vnd.jpeg-png", (Object)to.getBlobFormat());
            Assert.assertNotNull((Object)to.getBlob());
            Assert.assertTrue((to.getBlob().getSize() > 0L ? 1 : 0) != 0);
            String format = ImageMime.jpegPng.getMimeType(to.getBlob());
            long[] xyz = to.getXYZ();
            Assert.assertEquals((long)10L, (long)xyz[2]);
            if (xyz[0] == 900L || xyz[1] == 602L) {
                Assert.assertEquals((Object)"image/jpeg", (Object)format);
            } else {
                Assert.assertEquals((Object)"image/png", (Object)format);
            }
            return true;
        }), new RGBASourceHelper());
    }

    @Test
    public void testSeedJpegPng8MetaTiled() throws Exception {
        this.checkJpegPng("image/vnd.jpeg-png8", (IAnswer<Boolean>)((IAnswer)() -> {
            TileObject to = (TileObject)EasyMock.getCurrentArguments()[0];
            Assert.assertEquals((Object)"image/vnd.jpeg-png8", (Object)to.getBlobFormat());
            Assert.assertNotNull((Object)to.getBlob());
            Assert.assertTrue((to.getBlob().getSize() > 0L ? 1 : 0) != 0);
            String format = ImageMime.jpegPng8.getMimeType(to.getBlob());
            long[] xyz = to.getXYZ();
            Assert.assertEquals((long)10L, (long)xyz[2]);
            if (xyz[0] == 900L || xyz[1] == 602L) {
                Assert.assertEquals((Object)"image/jpeg", (Object)format);
            } else {
                Assert.assertEquals((Object)"image/png", (Object)format);
                try (InputStream inputStream = to.getBlob().getInputStream();){
                    BufferedImage image = ImageIO.read(inputStream);
                    Assert.assertThat((Object)image.getColorModel(), (Matcher)CoreMatchers.instanceOf(IndexColorModel.class));
                }
            }
            return true;
        }), new RGBASourceHelper());
    }

    @Test
    public void testSeedJpegPng8GrayAlphaMetaTiled() throws Exception {
        this.checkJpegPng("image/vnd.jpeg-png8", (IAnswer<Boolean>)((IAnswer)() -> {
            TileObject to = (TileObject)EasyMock.getCurrentArguments()[0];
            Assert.assertEquals((Object)"image/vnd.jpeg-png8", (Object)to.getBlobFormat());
            Assert.assertNotNull((Object)to.getBlob());
            Assert.assertTrue((to.getBlob().getSize() > 0L ? 1 : 0) != 0);
            String format = ImageMime.jpegPng8.getMimeType(to.getBlob());
            long[] xyz = to.getXYZ();
            Assert.assertEquals((long)10L, (long)xyz[2]);
            try (InputStream is = to.getBlob().getInputStream();){
                BufferedImage image = ImageIO.read(is);
                if (xyz[0] == 900L || xyz[1] == 602L) {
                    Assert.assertEquals((long)1L, (long)image.getColorModel().getNumComponents());
                    Assert.assertEquals((Object)"image/jpeg", (Object)format);
                } else {
                    Assert.assertEquals((Object)"image/png", (Object)format);
                    Assert.assertThat((Object)image.getColorModel(), (Matcher)CoreMatchers.instanceOf(IndexColorModel.class));
                }
            }
            return true;
        }), new GrayAlphaSourceHelper());
    }

    public void checkJpegPng(String format, IAnswer<Boolean> tileVerifier, WMSSourceHelper sourceHelper) throws GeoWebCacheException, IOException {
        WMSLayer layer = TestHelpers.createWMSLayer(format);
        MockLockProvider lockProvider = new MockLockProvider();
        layer.setSourceHelper(sourceHelper);
        layer.setLockProvider((LockProvider)lockProvider);
        StorageBroker mockStorageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        Capture captured = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)mockStorageBroker.put((TileObject)EasyMock.capture((Capture)captured))).andAnswer(tileVerifier).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockStorageBroker});
        String layerId = layer.getName();
        MockHttpServletRequest servletReq = new MockHttpServletRequest();
        MockHttpServletResponse servletResp = new MockHttpServletResponse();
        long[] gridLoc = new long[]{900L, 600L, 10L};
        MimeType mimeType = (MimeType)layer.getMimeTypes().get(0);
        GridSet gridSet = this.gridSetBroker.getWorldEpsg4326();
        String gridSetId = gridSet.getName();
        ConveyorTile tile = new ConveyorTile(mockStorageBroker, layerId, gridSetId, gridLoc, mimeType, null, (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        boolean tryCache = false;
        layer.seedTile(tile, tryCache);
        Assert.assertEquals((long)9L, (long)captured.getValues().size());
        EasyMock.verify((Object[])new Object[]{mockStorageBroker});
        lockProvider.verify();
        lockProvider.clear();
    }

    @Test
    public void testHttpClientPassedIn() throws Exception {
        StorageBroker mockStorageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        MockHttpServletRequest servletReq = new MockHttpServletRequest();
        MockHttpServletResponse servletResp = new MockHttpServletResponse();
        ConveyorTile tile = new ConveyorTile(mockStorageBroker, "name", (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        WMSLayer layer = TestHelpers.createWMSLayer("image/png");
        byte[] responseBody = "Fake body".getBytes();
        HttpResponse response = (HttpResponse)EasyMock.createNiceMock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)EasyMock.createMock(StatusLine.class);
        EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)statusLine);
        HttpEntity entity = (HttpEntity)EasyMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)entity.getContent()).andReturn((Object)new ByteArrayInputStream(responseBody));
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)entity);
        BasicHeader contentEncoding = new BasicHeader("ContentEncoding", "UTF-8");
        EasyMock.expect((Object)entity.getContentEncoding()).andReturn((Object)contentEncoding);
        EasyMock.expect((Object)response.getFirstHeader("Content-Type")).andReturn((Object)new BasicHeader("Content-Type", "image/png"));
        EasyMock.replay((Object[])new Object[]{entity});
        EasyMock.replay((Object[])new Object[]{response});
        HttpClient httpClient = (HttpClient)EasyMock.createNiceMock(HttpClient.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)EasyMock.anyObject())).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{httpClient});
        WMSHttpHelper httpHelper = new WMSHttpHelper(){

            public WMSHttpHelper setClient(HttpClient httpClient) {
                this.client = httpClient;
                return this;
            }
        }.setClient(httpClient);
        httpHelper.setBackendTimeout(10);
        layer.setSourceHelper((WMSSourceHelper)httpHelper);
        layer.proxyRequest(tile);
        Assert.assertEquals((long)200L, (long)servletResp.getStatus());
        Assert.assertEquals((Object)"Fake body", (Object)servletResp.getContentAsString());
    }

    @Test
    public void testHttpClientNeedsToBeCreated() throws Exception {
        WMSHttpHelper httpHelper = new WMSHttpHelper();
        Assert.assertNull((Object)httpHelper.client);
        Assert.assertNotNull((Object)httpHelper.getHttpClient());
        Assert.assertNotNull((Object)httpHelper.client);
    }

    @Test
    public void testCascadeGetLegendGraphics() throws Exception {
        WMSLayer layer = TestHelpers.createWMSLayer("image/png");
        final byte[] responseBody = "Fake body".getBytes();
        layer.setSourceHelper((WMSSourceHelper)new WMSHttpHelper(){

            public HttpResponse executeRequest(URL url, Map<String, String> queryParams, Integer backendTimeout, WMSLayer.HttpRequestMode httpRequestMode) throws UnsupportedOperationException, IOException {
                HttpResponse response = (HttpResponse)EasyMock.createNiceMock(HttpResponse.class);
                StatusLine statusLine = (StatusLine)EasyMock.createMock(StatusLine.class);
                EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)statusLine);
                HttpEntity entity = (HttpEntity)EasyMock.createMock(HttpEntity.class);
                EasyMock.expect((Object)entity.getContent()).andReturn((Object)new ByteArrayInputStream(responseBody));
                EasyMock.expect((Object)response.getEntity()).andReturn((Object)entity);
                BasicHeader contentEncoding = new BasicHeader("ContentEncoding", "UTF-8");
                EasyMock.expect((Object)entity.getContentEncoding()).andReturn((Object)contentEncoding);
                EasyMock.expect((Object)response.getFirstHeader("Content-Type")).andReturn((Object)new BasicHeader("Content-Type", "image/png"));
                EasyMock.replay((Object[])new Object[]{entity});
                EasyMock.replay((Object[])new Object[]{response});
                return response;
            }
        });
        MockLockProvider lockProvider = new MockLockProvider();
        layer.setLockProvider((LockProvider)lockProvider);
        StorageBroker mockStorageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        String layerId = layer.getName();
        MockHttpServletRequest servletReq = new MockHttpServletRequest();
        servletReq.setQueryString("REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&LAYER=topp:states");
        MockHttpServletResponse servletResp = new MockHttpServletResponse();
        long[] gridLoc = new long[]{0L, 0L, 0L};
        MimeType mimeType = (MimeType)layer.getMimeTypes().get(0);
        GridSet gridSet = this.gridSetBroker.getWorldEpsg4326();
        String gridSetId = gridSet.getName();
        ConveyorTile tile = new ConveyorTile(mockStorageBroker, layerId, gridSetId, gridLoc, mimeType, null, (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        layer.proxyRequest(tile);
        Assert.assertEquals((long)200L, (long)servletResp.getStatus());
        Assert.assertEquals((Object)"Fake body", (Object)servletResp.getContentAsString());
        Assert.assertEquals((Object)"image/png", (Object)servletResp.getContentType());
    }

    @Test
    public void testCascadeWithoutContentType() throws Exception {
        WMSLayer layer = TestHelpers.createWMSLayer("image/png");
        final byte[] responseBody = "Fake body".getBytes();
        layer.setSourceHelper((WMSSourceHelper)new WMSHttpHelper(){

            public HttpResponse executeRequest(URL url, Map<String, String> queryParams, Integer backendTimeout, WMSLayer.HttpRequestMode httpRequestMode) throws UnsupportedOperationException, IOException {
                HttpResponse response = (HttpResponse)EasyMock.createNiceMock(HttpResponse.class);
                StatusLine statusLine = (StatusLine)EasyMock.createMock(StatusLine.class);
                EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)statusLine);
                EasyMock.expect((Object)response.getFirstHeader("Content-Type")).andReturn(null);
                HttpEntity entity = (HttpEntity)EasyMock.createMock(HttpEntity.class);
                EasyMock.expect((Object)entity.getContent()).andReturn((Object)new ByteArrayInputStream(responseBody));
                EasyMock.expect((Object)response.getEntity()).andReturn((Object)entity);
                BasicHeader contentEncoding = new BasicHeader("ContentEncoding", "UTF-8");
                EasyMock.expect((Object)entity.getContentEncoding()).andReturn((Object)contentEncoding);
                EasyMock.replay((Object[])new Object[]{entity});
                EasyMock.replay((Object[])new Object[]{response});
                return response;
            }
        });
        StorageBroker mockStorageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        MockHttpServletRequest servletReq = new MockHttpServletRequest();
        MockHttpServletResponse servletResp = new MockHttpServletResponse();
        ConveyorTile tile = new ConveyorTile(mockStorageBroker, "name", (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        layer.proxyRequest(tile);
        Assert.assertNull((Object)servletResp.getContentType());
    }

    @Test
    public void testMinMaxCacheSeedTile() throws Exception {
        WMSLayer tl = TestHelpers.createWMSLayer("image/png", 5, 6);
        MockTileSupport mock = new MockTileSupport(tl);
        SeedRequest req = TestHelpers.createRequest(tl, GWCTask.TYPE.SEED, 4, 7);
        TileRange tr = TileBreeder.createTileRange((SeedRequest)req, (TileLayer)tl);
        this.seedTiles(mock.storageBroker, tr, tl);
        Assert.assertEquals((long)0L, (long)mock.cacheHits.get());
        Assert.assertEquals((long)0L, (long)mock.cacheMisses.get());
        Assert.assertEquals((long)42L, (long)mock.wmsMetaRequestCounter.get());
        Assert.assertEquals((long)218L, (long)mock.storagePutCounter.get());
    }

    @Test
    public void testGetFeatureInfoQueryLayers() throws MimeException {
        WMSLayer l = this.createFeatureInfoLayer("a,b", null);
        Assert.assertNotNull((Object)l.getWmsLayers());
        Assert.assertNull((Object)l.getWmsQueryLayers());
        Map rt = l.getWMSRequestTemplate(MimeType.createFromFormat((String)"text/plain"), WMSLayer.RequestType.FEATUREINFO);
        Assert.assertEquals((Object)l.getWmsLayers(), rt.get("QUERY_LAYERS"));
        l = this.createFeatureInfoLayer("a,b", "b");
        Assert.assertNotNull((Object)l.getWmsLayers());
        Assert.assertNotNull((Object)l.getWmsQueryLayers());
        rt = l.getWMSRequestTemplate(MimeType.createFromFormat((String)"text/plain"), WMSLayer.RequestType.FEATUREINFO);
        Assert.assertEquals((Object)l.getWmsQueryLayers(), rt.get("QUERY_LAYERS"));
    }

    private WMSLayer createFeatureInfoLayer(String wmsLayers, String wmsQueryLayers) {
        return new WMSLayer("name", new String[0], null, wmsLayers, null, null, null, null, null, true, wmsQueryLayers);
    }

    @Test
    @Ignore
    public void testMinMaxCacheGetTile() throws Exception {
        WMSLayer tl = TestHelpers.createWMSLayer("image/png", 5, 6);
        MockTileSupport mock = new MockTileSupport(tl);
        SeedRequest req = TestHelpers.createRequest(tl, GWCTask.TYPE.SEED, 4, 7);
        TileRange tr = TileBreeder.createTileRange((SeedRequest)req, (TileLayer)tl);
        List<ConveyorTile> tiles = this.getTiles(mock.storageBroker, tr, tl);
        Assert.assertEquals((long)880L, (long)tiles.size());
        for (ConveyorTile tile : tiles) {
            Assert.assertNotNull((Object)tile.getBlob());
        }
        Assert.assertEquals((long)218L, (long)mock.storagePutCounter.get());
        Assert.assertEquals((long)176L, (long)mock.storageGetCounter.get());
    }

    private void seedTiles(StorageBroker storageBroker, TileRange tr, WMSLayer tl) throws Exception {
        String layerName = tl.getName();
        TileRangeIterator trIter = new TileRangeIterator(tr, tl.getMetaTilingFactors());
        long[] gridLoc = trIter.nextMetaGridLocation(new long[3]);
        while (gridLoc != null) {
            Map fullParameters = tr.getParameters();
            ConveyorTile tile = new ConveyorTile(storageBroker, layerName, tr.getGridSetId(), gridLoc, tr.getMimeType(), fullParameters, null, null);
            tile.setTileLayer((TileLayer)tl);
            tl.seedTile(tile, false);
            gridLoc = trIter.nextMetaGridLocation(gridLoc);
        }
    }

    private List<ConveyorTile> getTiles(StorageBroker storageBroker, TileRange tr, WMSLayer tl) throws Exception {
        String layerName = tl.getName();
        TileRangeIterator trIter = new TileRangeIterator(tr, new int[]{1, 1});
        long[] gridLoc = trIter.nextMetaGridLocation(new long[3]);
        ExecutorService requests = Executors.newFixedThreadPool(6);
        ExecutorCompletionService<ConveyorTile> completer = new ExecutorCompletionService<ConveyorTile>(requests);
        ArrayList<Future<ConveyorTile>> futures = new ArrayList<Future<ConveyorTile>>();
        while (gridLoc != null) {
            Map fullParameters = tr.getParameters();
            ConveyorTile tile = new ConveyorTile(storageBroker, layerName, tr.getGridSetId(), gridLoc, tr.getMimeType(), fullParameters, null, null);
            futures.add(completer.submit(() -> {
                try {
                    return tl.getTile(tile);
                }
                catch (OutsideCoverageException oce) {
                    return null;
                }
            }));
            gridLoc = trIter.nextMetaGridLocation(gridLoc);
        }
        ArrayList<ConveyorTile> results = new ArrayList<ConveyorTile>();
        for (Future future : futures) {
            ConveyorTile get = (ConveyorTile)future.get();
            if (get == null) continue;
            results.add(get);
        }
        requests.shutdown();
        return results;
    }

    @Override
    protected TileLayer getLayerWithFilters(Collection<ParameterFilter> filters) throws Exception {
        WMSLayer tl = TestHelpers.createWMSLayer("image/png", 5, 6);
        MockTileSupport mock = new MockTileSupport(tl);
        tl.getParameterFilters().addAll(filters);
        return tl;
    }

    class MockTileSupport {
        final byte[] fakeWMSResponse;
        final StorageBroker storageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        final AtomicInteger cacheHits = new AtomicInteger();
        final AtomicInteger cacheMisses = new AtomicInteger();
        final AtomicInteger storagePutCounter = new AtomicInteger();
        final AtomicInteger storageGetCounter = new AtomicInteger();
        final AtomicInteger wmsMetaRequestCounter = new AtomicInteger();
        final AtomicInteger tileTransferCounter = new AtomicInteger();
        final TransientCache transientCache = new TransientCache(100, 100, 2000L);

        public MockTileSupport(WMSLayer tl) throws Exception {
            this.fakeWMSResponse = TestHelpers.createFakeSourceImage(tl);
            this.installSourceHelper(tl);
            this.installMockBroker();
        }

        private void installSourceHelper(WMSLayer tl) throws Exception {
            WMSSourceHelper mockSourceHelper = (WMSSourceHelper)EasyMock.createMock(WMSSourceHelper.class);
            Capture metaTileCapturer = EasyMock.newCapture();
            Capture resourceCapturer = EasyMock.newCapture();
            mockSourceHelper.makeRequest((WMSMetaTile)EasyMock.capture((Capture)metaTileCapturer), (Resource)EasyMock.capture((Capture)resourceCapturer));
            EasyMock.expectLastCall().andAnswer(() -> {
                Resource resource = (Resource)resourceCapturer.getValue();
                this.wmsMetaRequestCounter.incrementAndGet();
                try {
                    resource.transferFrom(Channels.newChannel(new ByteArrayInputStream(this.fakeWMSResponse)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
            EasyMock.expectLastCall().anyTimes().asStub();
            mockSourceHelper.setConcurrency(32);
            mockSourceHelper.setBackendTimeout(120);
            EasyMock.replay((Object[])new Object[]{mockSourceHelper});
            tl.setSourceHelper(mockSourceHelper);
        }

        private void installMockBroker() throws Exception {
            EasyMock.expect((Object)this.storageBroker.getTransient((TileObject)EasyMock.anyObject())).andAnswer(() -> {
                Resource resource;
                TileObject tile = (TileObject)EasyMock.getCurrentArguments()[0];
                String key = TransientCache.computeTransientKey((TileObject)tile);
                TransientCache transientCache = this.transientCache;
                synchronized (transientCache) {
                    resource = this.transientCache.get(key);
                }
                if (resource != null) {
                    this.cacheHits.incrementAndGet();
                } else {
                    this.cacheMisses.incrementAndGet();
                }
                tile.setBlob(resource);
                return resource != null;
            }).anyTimes();
            Capture tileCapturer = EasyMock.newCapture();
            this.storageBroker.putTransient((TileObject)EasyMock.capture((Capture)tileCapturer));
            EasyMock.expectLastCall().andAnswer(() -> {
                TileObject tile = (TileObject)tileCapturer.getValue();
                String key = TransientCache.computeTransientKey((TileObject)tile);
                TransientCache transientCache = this.transientCache;
                synchronized (transientCache) {
                    this.transientCache.put(key, tile.getBlob());
                }
                return null;
            }).anyTimes();
            HashSet puts = new HashSet();
            EasyMock.expect((Object)this.storageBroker.put((TileObject)EasyMock.capture((Capture)tileCapturer))).andAnswer(() -> {
                TileObject tile = (TileObject)tileCapturer.getValue();
                puts.add(TransientCache.computeTransientKey((TileObject)tile));
                this.storagePutCounter.incrementAndGet();
                return true;
            }).anyTimes();
            EasyMock.expect((Object)this.storageBroker.get((TileObject)EasyMock.anyObject())).andAnswer(() -> {
                TileObject tile = (TileObject)EasyMock.getCurrentArguments()[0];
                if (puts.contains(TransientCache.computeTransientKey((TileObject)tile))) {
                    tile.setBlob((Resource)new ByteArrayResource(this.fakeWMSResponse));
                    this.storageGetCounter.incrementAndGet();
                    return true;
                }
                return false;
            }).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.storageBroker});
        }
    }

    private static class GrayAlphaSourceHelper
    extends WMSSourceHelper {
        private GrayAlphaSourceHelper() {
        }

        protected void makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, Map<String, String> wmsParams, MimeType expectedMimeType, Resource target) throws GeoWebCacheException {
            int width = Integer.parseInt(wmsParams.get("WIDTH"));
            int height = Integer.parseInt(wmsParams.get("HEIGHT"));
            Assert.assertEquals((long)768L, (long)width);
            Assert.assertEquals((long)768L, (long)height);
            BufferedImage baseImage = new BufferedImage(width, height, 6);
            Graphics2D graphics = baseImage.createGraphics();
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, width, 300);
            graphics.fillRect(0, 0, 300, height);
            graphics.dispose();
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 0);
            SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(width, height);
            ImageLayout il = new ImageLayout();
            il.setSampleModel(sm);
            il.setColorModel((ColorModel)cm);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il);
            RenderedOp grayAlpha = BandSelectDescriptor.create((RenderedImage)baseImage, (int[])new int[]{0, 3}, (RenderingHints)hints);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)grayAlpha, "PNG", output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                target.transferFrom(Channels.newChannel(new ByteArrayInputStream(output.toByteArray())));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class RGBASourceHelper
    extends WMSSourceHelper {
        private RGBASourceHelper() {
        }

        protected void makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, Map<String, String> wmsParams, MimeType expectedMimeType, Resource target) throws GeoWebCacheException {
            int width = Integer.parseInt(wmsParams.get("WIDTH"));
            int height = Integer.parseInt(wmsParams.get("HEIGHT"));
            Assert.assertEquals((long)768L, (long)width);
            Assert.assertEquals((long)768L, (long)height);
            BufferedImage img = new BufferedImage(width, height, 6);
            Graphics2D graphics = img.createGraphics();
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, width, 300);
            graphics.fillRect(0, 0, 300, height);
            graphics.dispose();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)img, "PNG", output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                target.transferFrom(Channels.newChannel(new ByteArrayInputStream(output.toByteArray())));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

