/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.GWCConfigIntegrationTest;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.TileLayerDispatcherFilter;
import org.geowebcache.layer.wms.WMSLayer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TileLayerDispatcherTest
extends GWCConfigIntegrationTest {
    @Test
    public void testLayerList() {
        int count = this.tileLayerDispatcher.getLayerCount();
        Set names = this.tileLayerDispatcher.getLayerNames();
        int i = 0;
        for (TileLayer layer : this.tileLayerDispatcher.getLayerList()) {
            Assert.assertTrue((boolean)names.contains(layer.getName()));
            ++i;
        }
        Assert.assertEquals((long)count, (long)i);
        Assert.assertEquals((long)count, (long)names.size());
    }

    @Test
    public void testAddLayer() throws GeoWebCacheException {
        String layerName = "newLayer";
        WMSLayer layer = new WMSLayer(layerName, new String[]{"http://example.com/"}, null, null, null, null, null, null, null, false, null);
        this.tileLayerDispatcher.addLayer((TileLayer)layer);
        Assert.assertTrue((boolean)this.tileLayerDispatcher.getLayerNames().contains(layerName));
        Assert.assertEquals((Object)layer, (Object)this.tileLayerDispatcher.getTileLayer(layerName));
    }

    @Test
    public void testAddBadLayer() throws GeoWebCacheException {
        String duplicateLayerName = "topp:states";
        String transientLayerName = "transientLayer";
        TileLayer layer = this.tileLayerDispatcher.getTileLayer(duplicateLayerName);
        try {
            this.tileLayerDispatcher.addLayer(layer);
            Assert.fail((String)"Expected error when adding a layer that already exists");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        layer = new WMSLayer(transientLayerName, new String[]{"http://example.com/"}, null, null, null, null, null, null, null, false, null);
        layer.setTransientLayer(true);
        try {
            this.tileLayerDispatcher.addLayer(layer);
            Assert.fail((String)"Expected error when adding a transient layer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tileLayerDispatcher.addLayer(null);
            Assert.fail((String)"Expected error when adding a null layer");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveLayer() {
        String layerToRemove = "topp:states";
        this.tileLayerDispatcher.removeLayer(layerToRemove);
        Assert.assertFalse((boolean)this.tileLayerDispatcher.getLayerNames().contains(layerToRemove));
        try {
            this.tileLayerDispatcher.getTileLayer(layerToRemove);
            Assert.fail((String)"Expected exception when trying to get removed layer");
        }
        catch (GeoWebCacheException geoWebCacheException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveLayerException() {
        try {
            this.tileLayerDispatcher.removeLayer(null);
            Assert.fail((String)"Expected failure when trying to remove null layer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tileLayerDispatcher.removeLayer("nonexistantLayer");
            Assert.fail((String)"Expected failure when trying to remove nonexistant layer");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testModifyLayer() throws GeoWebCacheException {
        String modifiedLayerName = "topp:states";
        TileLayer layer = this.tileLayerDispatcher.getTileLayer(modifiedLayerName);
        layer.removeGridSubset("EPSG:2163");
        boolean advertised = !layer.isAdvertised();
        layer.setAdvertised(advertised);
        this.tileLayerDispatcher.modify(layer);
        TileLayer modifiedLayer = this.tileLayerDispatcher.getTileLayer(modifiedLayerName);
        Assert.assertEquals((Object)layer, (Object)modifiedLayer);
        Assert.assertEquals((Object)advertised, (Object)modifiedLayer.isAdvertised());
        Assert.assertNull((Object)modifiedLayer.getGridSubset("EPSG:2163"));
    }

    @Test
    public void testModifyBadLayer() {
        String layerName = "newLayer";
        WMSLayer layer = new WMSLayer(layerName, new String[]{"http://example.com/"}, null, null, null, null, null, null, null, false, null);
        try {
            this.tileLayerDispatcher.modify((TileLayer)layer);
            Assert.fail((String)"Expected exception when modifiying nonexistant layer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tileLayerDispatcher.modify(null);
            Assert.fail((String)"Expected exception when modifiying null layer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddGridset() throws GeoWebCacheException, IOException {
        String gridsetName = "EPSG:3005";
        GridSet epsg3005 = GridSetFactory.createGridSet((String)gridsetName, (SRS)SRS.getSRS((String)gridsetName), (BoundingBox)new BoundingBox(35043.6538, 440006.8768, 1885895.3117, 1735643.8497), (boolean)false, null, (double[])new double[]{2.5E7, 1250000.0, 500000.0, 250000.0}, null, (double)2.8E-4, null, (int)256, (int)256, (boolean)false);
        this.tileLayerDispatcher.addGridSet(epsg3005);
        Assert.assertTrue((boolean)this.gridSetBroker.getNames().contains(gridsetName));
        Assert.assertEquals((Object)this.gridSetBroker.get(gridsetName), (Object)epsg3005);
    }

    @Test
    public void testAddBadGridset() throws IOException {
        GridSet existingGridSet = this.gridSetBroker.get("EPSG:2163");
        try {
            this.tileLayerDispatcher.addGridSet(existingGridSet);
            Assert.fail((String)"Expected exception adding existing gridset");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tileLayerDispatcher.addGridSet(null);
            Assert.fail((String)"Expected exception adding null gridset");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveGridset() throws IOException {
        String gridsetToRemove = "EPSG:2163";
        this.tileLayerDispatcher.removeLayer("topp:states");
        this.tileLayerDispatcher.removeGridSet(gridsetToRemove);
        Assert.assertFalse((boolean)this.gridSetBroker.getNames().contains(gridsetToRemove));
        Assert.assertNull((Object)this.gridSetBroker.get(gridsetToRemove));
    }

    @Test
    public void testRemoveGridsetException() throws IOException {
        String gridsetToRemove = "EPSG:2163";
        try {
            this.tileLayerDispatcher.removeGridSet(gridsetToRemove);
            Assert.fail((String)"Expected exception removing a gridset referenced by a layer");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLayerListFiltered() {
        TileLayer tileLayer1 = (TileLayer)Mockito.mock(TileLayer.class);
        TileLayer tileLayer2 = (TileLayer)Mockito.mock(TileLayer.class);
        TileLayerDispatcherFilter tileLayerDispatcherFilter = (TileLayerDispatcherFilter)Mockito.mock(TileLayerDispatcherFilter.class);
        ((TileLayerDispatcherFilter)Mockito.doReturn((Object)true).when((Object)tileLayerDispatcherFilter)).exclude(tileLayer1);
        ((TileLayerDispatcherFilter)Mockito.doReturn((Object)false).when((Object)tileLayerDispatcherFilter)).exclude(tileLayer2);
        TileLayerDispatcher tileLayerDispatcher = new TileLayerDispatcher(null, tileLayerDispatcherFilter);
        TileLayerDispatcher tileLayerDispatcherSpy = (TileLayerDispatcher)Mockito.spy((Object)tileLayerDispatcher);
        ((TileLayerDispatcher)Mockito.doReturn(Arrays.asList(tileLayer1, tileLayer2)).when((Object)tileLayerDispatcherSpy)).getLayerList();
        Iterable filteredResult = tileLayerDispatcherSpy.getLayerListFiltered();
        ArrayList result = new ArrayList();
        filteredResult.forEach(result::add);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)tileLayer2, result.get(0));
        ((TileLayerDispatcherFilter)Mockito.verify((Object)tileLayerDispatcherFilter)).exclude(tileLayer1);
        ((TileLayerDispatcherFilter)Mockito.verify((Object)tileLayerDispatcherFilter)).exclude(tileLayer2);
    }
}

