/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.util.MockLockProvider;
import org.junit.Assert;
import org.junit.Test;

public class GridSubSetTest {
    @Test
    public void testCreateTileRange() throws IOException, GeoWebCacheException {
        WMSLayer tl = GridSubSetTest.createWMSLayer();
        String gridSet = (String)tl.getGridSubsets().iterator().next();
        GridSubset gridSubSet = tl.getGridSubset(gridSet);
        BoundingBox bounds = new BoundingBox(0.0, 0.0, 1.0, 1.0);
        long[][] result = gridSubSet.getCoverageIntersections(bounds);
        Assert.assertNotNull((Object)result);
    }

    private static WMSLayer createWMSLayer() {
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>();
        GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)gridSetBroker.getWorldEpsg4326(), (BoundingBox)new BoundingBox(-30.0, 15.0, 45.0, 30.0), (Integer)5, (Integer)10, null, null);
        grids.put(grid.getName(), grid);
        String[] urls = new String[]{"http://localhost:38080/wms"};
        List<String> formatList = Collections.singletonList("image/png");
        int[] metaWidthHeight = new int[]{3, 3};
        WMSLayer layer = new WMSLayer("test:layer", urls, "aStyle", "test:layer", formatList, grids, null, metaWidthHeight, "vendorparam=true", false, null);
        layer.initialize(gridSetBroker);
        layer.setLockProvider((LockProvider)new MockLockProvider());
        return layer;
    }
}

