/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;
import org.junit.Assert;
import org.junit.Test;

public class GridSetFactoryTest {
    @Test
    public void testResolutionsArrayEPSG4326() throws Exception {
        BoundingBox extent = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
        double[] resolutions = new double[]{0.703125, 0.3515625, 0.17578125, 0.087890625};
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)extent, (boolean)false, (double[])resolutions, null, null, (double)2.8E-4, null, (int)256, (int)256, (boolean)false);
        Assert.assertEquals((Object)"test", (Object)gridSet.getName());
        Assert.assertEquals((double)-180.0, (double)gridSet.tileOrigin()[0], (double)0.0);
        Assert.assertEquals((double)-90.0, (double)gridSet.tileOrigin()[1], (double)0.0);
        Assert.assertEquals((long)resolutions.length, (long)gridSet.getNumLevels());
        Grid grid0 = gridSet.getGrid(0);
        Assert.assertEquals((double)0.703125, (double)grid0.getResolution(), (double)0.0);
        Assert.assertEquals((long)2L, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesHigh());
        Grid grid3 = gridSet.getGrid(3);
        Assert.assertEquals((double)0.087890625, (double)grid3.getResolution(), (double)0.0);
        Assert.assertEquals((long)((long)Math.pow(2.0, 4.0)), (long)grid3.getNumTilesWide());
        Assert.assertEquals((long)((long)Math.pow(2.0, 3.0)), (long)grid3.getNumTilesHigh());
    }

    @Test
    public void testResolutionsArrayEPSG3785() throws Exception {
        BoundingBox extent = new BoundingBox(-2.003750834E7, -2.003750834E7, 2.003750834E7, 2.003750834E7);
        double[] resolutions = new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125};
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG3857(), (BoundingBox)extent, (boolean)false, (double[])resolutions, null, null, (double)2.8E-4, null, (int)256, (int)256, (boolean)false);
        Grid grid0 = gridSet.getGrid(0);
        Assert.assertEquals((double)156543.03390625, (double)grid0.getResolution(), (double)0.0);
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesHigh());
        Grid grid3 = gridSet.getGrid(3);
        Assert.assertEquals((long)((long)Math.pow(2.0, 3.0)), (long)grid3.getNumTilesWide());
        Assert.assertEquals((long)((long)Math.pow(2.0, 3.0)), (long)grid3.getNumTilesHigh());
    }

    @Test
    public void testResolutionsArrayTricky1() throws Exception {
        BoundingBox extent = new BoundingBox(-173.0, -90.0, 180.0, 96.0);
        double[] resolutions = new double[]{0.9, 0.45, 0.225};
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)extent, (boolean)false, (double[])resolutions, null, null, (double)2.8E-4, null, (int)200, (int)200, (boolean)false);
        Assert.assertEquals((double)-173.0, (double)gridSet.tileOrigin()[0], (double)0.0);
        Assert.assertEquals((double)-90.0, (double)gridSet.tileOrigin()[1], (double)0.0);
        Assert.assertEquals((long)resolutions.length, (long)gridSet.getNumLevels());
        Grid grid0 = gridSet.getGrid(0);
        Assert.assertEquals((double)0.9, (double)grid0.getResolution(), (double)0.0);
        Assert.assertEquals((long)2L, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)2L, (long)grid0.getNumTilesHigh());
        Grid grid3 = gridSet.getGrid(2);
        Assert.assertEquals((double)0.225, (double)grid3.getResolution(), (double)0.0);
        Assert.assertEquals((long)8L, (long)grid3.getNumTilesWide());
        Assert.assertEquals((long)5L, (long)grid3.getNumTilesHigh());
    }

    @Test
    public void testBoundingBoxEPSG4326() throws Exception {
        BoundingBox extent = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)extent, (boolean)false, (int)4, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        Assert.assertEquals((Object)"test", (Object)gridSet.getName());
        Assert.assertEquals((double)-180.0, (double)gridSet.tileOrigin()[0], (double)0.0);
        Assert.assertEquals((double)-90.0, (double)gridSet.tileOrigin()[1], (double)0.0);
        Assert.assertEquals((long)4L, (long)gridSet.getNumLevels());
        Grid grid0 = gridSet.getGrid(0);
        Assert.assertEquals((double)0.703125, (double)grid0.getResolution(), (double)0.0);
        Assert.assertEquals((long)2L, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesHigh());
        Grid grid3 = gridSet.getGrid(3);
        Assert.assertEquals((double)0.087890625, (double)grid3.getResolution(), (double)0.0);
        Assert.assertEquals((long)((long)Math.pow(2.0, 4.0)), (long)grid3.getNumTilesWide());
        Assert.assertEquals((long)((long)Math.pow(2.0, 3.0)), (long)grid3.getNumTilesHigh());
    }

    @Test
    public void testBoundingBoxEPSG3785() throws Exception {
        BoundingBox extent = new BoundingBox(-2.003750834E7, -2.003750834E7, 2.003750834E7, 2.003750834E7);
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG3857(), (BoundingBox)extent, (boolean)false, (int)6, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        Grid grid0 = gridSet.getGrid(0);
        Assert.assertEquals((double)156543.03390625, (double)grid0.getResolution(), (double)0.0);
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesHigh());
        Grid grid3 = gridSet.getGrid(3);
        Assert.assertEquals((long)((long)Math.pow(2.0, 3.0)), (long)grid3.getNumTilesWide());
        Assert.assertEquals((long)((long)Math.pow(2.0, 3.0)), (long)grid3.getNumTilesHigh());
    }

    @Test
    public void testBoundingBoxTricky1() throws Exception {
        BoundingBox extent = new BoundingBox(-180.0, -90.0, 172.0, 90.0);
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)extent, (boolean)false, (int)4, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        Assert.assertEquals((Object)"test", (Object)gridSet.getName());
        Assert.assertEquals((double)-180.0, (double)gridSet.tileOrigin()[0], (double)0.0);
        Assert.assertEquals((double)-90.0, (double)gridSet.tileOrigin()[1], (double)0.0);
        Assert.assertEquals((long)4L, (long)gridSet.getNumLevels());
        Grid grid0 = gridSet.getGrid(0);
        Assert.assertEquals((double)0.703125, (double)grid0.getResolution(), (double)0.0);
        Assert.assertEquals((long)2L, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesHigh());
    }

    @Test
    public void testBoundingBoxTricky2() throws Exception {
        BoundingBox extent = new BoundingBox(-180.0, -90.0, 180.0, 82.0);
        SRS srs = SRS.getEPSG4326();
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)srs, (BoundingBox)extent, (boolean)false, (int)4, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        Assert.assertEquals((Object)"test", (Object)gridSet.getName());
        Assert.assertEquals((double)-180.0, (double)gridSet.tileOrigin()[0], (double)0.0);
        Assert.assertEquals((double)-90.0, (double)gridSet.tileOrigin()[1], (double)0.0);
        Assert.assertEquals((long)4L, (long)gridSet.getNumLevels());
        Grid grid0 = gridSet.getGrid(0);
        Assert.assertEquals((double)0.703125, (double)grid0.getResolution(), (double)0.0);
        Assert.assertEquals((long)2L, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesHigh());
    }

    @Test
    public void testResolutionsPreservedFlag() throws Exception {
        BoundingBox extent = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
        double[] resolutions = new double[]{0.703125, 0.3515625, 0.17578125, 0.087890625};
        double[] scales = new double[]{5.0E8, 2.5E8, 1.0E8};
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)extent, (boolean)false, (double[])resolutions, null, null, (double)2.8E-4, null, (int)256, (int)256, (boolean)false);
        Assert.assertTrue((boolean)gridSet.isResolutionsPreserved());
        gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)extent, (boolean)false, null, (double[])scales, null, (double)2.8E-4, null, (int)256, (int)256, (boolean)false);
        Assert.assertFalse((boolean)gridSet.isResolutionsPreserved());
    }

    @Test
    public void testLevels2() throws Exception {
        BoundingBox extent = new BoundingBox(0.0, 0.0, 1000.0, 1000.0);
        int levels = 16;
        int tileW = 300;
        int tileH = 100;
        Double metersPerUnit = 1.0;
        double pixelSize = 2.8E-4;
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getSRS((int)3005), (BoundingBox)extent, (boolean)false, (int)levels, (Double)metersPerUnit, (double)pixelSize, (int)tileW, (int)tileH, (boolean)false);
        Assert.assertEquals((Object)extent, (Object)gridSet.getOriginalExtent());
        Assert.assertEquals((long)16L, (long)gridSet.getNumLevels());
        Assert.assertEquals((long)1L, (long)gridSet.getGrid(0).getNumTilesWide());
        Assert.assertEquals((long)3L, (long)gridSet.getGrid(0).getNumTilesHigh());
        for (int i = 1; i < gridSet.getNumLevels(); ++i) {
            Assert.assertEquals((long)(2L * gridSet.getGrid(i - 1).getNumTilesWide()), (long)gridSet.getGrid(i).getNumTilesWide());
            Assert.assertEquals((long)(2L * gridSet.getGrid(i - 1).getNumTilesHigh()), (long)gridSet.getGrid(i).getNumTilesHigh());
        }
    }

    @Test
    public void testWideBoundsTallTile() throws Exception {
        BoundingBox extent = new BoundingBox(0.0, 0.0, 100.0, 45.0);
        int tileWidth = 10;
        int tileHeight = 20;
        SRS srs = SRS.getEPSG4326();
        boolean alignTopLeft = false;
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)srs, (BoundingBox)extent, (boolean)alignTopLeft, (int)4, null, (double)2.8E-4, (int)tileWidth, (int)tileHeight, (boolean)false);
        Assert.assertEquals((Object)"test", (Object)gridSet.getName());
        Assert.assertEquals((double)0.0, (double)gridSet.tileOrigin()[0], (double)0.0);
        Assert.assertEquals((double)0.0, (double)gridSet.tileOrigin()[1], (double)0.0);
        Assert.assertEquals((Object)new BoundingBox(0.0, 0.0, 100.0, 50.0), (Object)gridSet.getBounds());
        Assert.assertEquals((long)4L, (long)gridSet.getNumLevels());
        Grid grid0 = gridSet.getGrid(0);
        Assert.assertEquals((long)4L, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)1L, (long)grid0.getNumTilesHigh());
        Assert.assertEquals((double)2.5, (double)grid0.getResolution(), (double)0.0);
        alignTopLeft = true;
        gridSet = GridSetFactory.createGridSet((String)"test", (SRS)srs, (BoundingBox)extent, (boolean)alignTopLeft, (int)4, null, (double)2.8E-4, (int)tileWidth, (int)tileHeight, (boolean)false);
        Assert.assertEquals((Object)new BoundingBox(0.0, -5.0, 100.0, 45.0), (Object)gridSet.getBounds());
        Assert.assertEquals((Object)"test", (Object)gridSet.getName());
        Assert.assertEquals((double)0.0, (double)gridSet.tileOrigin()[0], (double)0.0);
        Assert.assertEquals((double)45.0, (double)gridSet.tileOrigin()[1], (double)0.0);
    }

    @Test
    public void testTallBoundsWideTile() throws Exception {
        BoundingBox extent = new BoundingBox(0.0, 0.0, 100.0, 490.0);
        int tileWidth = 20;
        int tileHeight = 10;
        SRS srs = SRS.getEPSG4326();
        boolean alignTopLeft = false;
        GridSet gridSet = GridSetFactory.createGridSet((String)"test", (SRS)srs, (BoundingBox)extent, (boolean)alignTopLeft, (int)4, null, (double)2.8E-4, (int)tileWidth, (int)tileHeight, (boolean)false);
        Assert.assertEquals((Object)new BoundingBox(0.0, 0.0, 100.0, 500.0), (Object)gridSet.getBounds());
        Assert.assertEquals((long)4L, (long)gridSet.getNumLevels());
        Grid grid0 = gridSet.getGrid(0);
        long tilesWide = 1L;
        long tilesHigh = 10L;
        Assert.assertEquals((long)tilesWide, (long)grid0.getNumTilesWide());
        Assert.assertEquals((long)tilesHigh, (long)grid0.getNumTilesHigh());
        Assert.assertEquals((double)(500.0 / (double)tileHeight / (double)tilesHigh), (double)grid0.getResolution(), (double)0.0);
        alignTopLeft = true;
        gridSet = GridSetFactory.createGridSet((String)"test", (SRS)srs, (BoundingBox)extent, (boolean)alignTopLeft, (int)4, null, (double)2.8E-4, (int)tileWidth, (int)tileHeight, (boolean)false);
        BoundingBox bounds = gridSet.getBounds();
        Assert.assertEquals((Object)new BoundingBox(0.0, -10.0, 100.0, 490.0), (Object)bounds);
        Assert.assertEquals((Object)"test", (Object)gridSet.getName());
        Assert.assertEquals((double)0.0, (double)gridSet.tileOrigin()[0], (double)0.0);
        Assert.assertEquals((double)490.0, (double)gridSet.tileOrigin()[1], (double)0.0);
    }
}

