/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Collections;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridCalculatorTest {
    GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void test1gridLevels4326() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[][] solution = new long[][]{{1L, 0L, 1L, 0L, 0L}, {2L, 1L, 3L, 1L, 1L}, {4L, 2L, 7L, 3L, 2L}, {8L, 4L, 15L, 7L, 3L}};
        for (int i = 0; i < solution.length; ++i) {
            long[] bounds = grid.getCoverage(i);
            Assert.assertArrayEquals((long[])solution[i], (long[])bounds);
        }
    }

    @Test
    public void test2gridLevels4326() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[][] solution = new long[][]{{1L, 0L, 1L, 0L, 0L}, {2L, 1L, 3L, 1L, 1L}, {4L, 2L, 7L, 3L, 2L}, {8L, 4L, 15L, 7L, 3L}, {16L, 8L, 31L, 15L, 4L}, {32L, 16L, 63L, 31L, 5L}, {64L, 32L, 127L, 63L, 6L}};
        for (int i = 0; i < solution.length; ++i) {
            long[] bounds = grid.getCoverage(i);
            Assert.assertArrayEquals((long[])solution[i], (long[])bounds);
        }
    }

    @Test
    public void test3gridLevels4326() throws Exception {
        BoundingBox bbox = new BoundingBox(-10.0, -10.0, 10.0, 10.0);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[][] solution = new long[][]{{0L, 0L, 1L, 0L, 0L}, {1L, 0L, 2L, 1L, 1L}, {3L, 1L, 4L, 2L, 2L}, {7L, 3L, 8L, 4L, 3L}, {15L, 7L, 16L, 8L, 4L}, {30L, 14L, 33L, 17L, 5L}, {60L, 28L, 67L, 35L, 6L}, {120L, 56L, 135L, 71L, 7L}};
        for (int i = 0; i < solution.length; ++i) {
            long[] bounds = grid.getCoverage(i);
            Assert.assertArrayEquals((long[])solution[i], (long[])bounds);
        }
    }

    @Test
    public void test4gridLevels4326() throws Exception {
        BoundingBox bbox = new BoundingBox(175.0, 87.0, 180.0, 90.0);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[][] solution = new long[][]{{1L, 0L, 1L, 0L, 0L}, {3L, 1L, 3L, 1L, 1L}, {7L, 3L, 7L, 3L, 2L}, {15L, 7L, 15L, 7L, 3L}, {31L, 15L, 31L, 15L, 4L}, {63L, 31L, 63L, 31L, 5L}, {126L, 62L, 127L, 63L, 6L}, {252L, 125L, 255L, 127L, 7L}, {504L, 251L, 511L, 255L, 8L}};
        for (int i = 0; i < solution.length; ++i) {
            long[] bounds = grid.getCoverage(i);
            Assert.assertArrayEquals((long[])solution[i], (long[])bounds);
        }
    }

    @Test
    public void test1gridLevels900913() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 2.003750834E7, 2.003750834E7);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg3857(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[][] solution = new long[][]{{0L, 0L, 0L, 0L, 0L}, {1L, 1L, 1L, 1L, 1L}, {2L, 2L, 3L, 3L, 2L}, {4L, 4L, 7L, 7L, 3L}, {8L, 8L, 15L, 15L, 4L}};
        for (int i = 0; i < solution.length; ++i) {
            long[] bounds = grid.getCoverage(i);
            Assert.assertArrayEquals((long[])solution[i], (long[])bounds);
        }
    }

    @Test
    public void test2gridLevels900913() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 2.003750834E7, 2.003750834E7);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg3857(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[][] solution = new long[][]{{0L, 0L, 0L, 0L, 0L}, {1L, 1L, 1L, 1L, 1L}, {2L, 2L, 3L, 3L, 2L}, {4L, 4L, 7L, 7L, 3L}, {8L, 8L, 15L, 15L, 4L}, {16L, 16L, 31L, 31L, 5L}, {32L, 32L, 63L, 63L, 6L}};
        for (int i = 0; i < solution.length; ++i) {
            long[] bounds = grid.getCoverage(i);
            Assert.assertArrayEquals((long[])solution[i], (long[])bounds);
        }
    }

    @Test
    public void test3gridLevels900913() throws Exception {
        BoundingBox bbox = new BoundingBox(-500000.0, -500000.0, 500000.0, 500000.0);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg3857(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[][] solution = new long[][]{{0L, 0L, 0L, 0L, 0L}, {0L, 0L, 1L, 1L, 1L}, {1L, 1L, 2L, 2L, 2L}, {3L, 3L, 4L, 4L, 3L}, {7L, 7L, 8L, 8L, 4L}, {15L, 15L, 16L, 16L, 5L}, {31L, 31L, 32L, 32L, 6L}, {62L, 62L, 65L, 65L, 7L}};
        for (int i = 0; i < solution.length; ++i) {
            long[] bounds = grid.getCoverage(i);
            Assert.assertArrayEquals((long[])solution[i], (long[])bounds);
        }
    }

    @Test
    public void test5gridBoundsLoc4326() throws Exception {
        BoundingBox bbox = new BoundingBox(-124.73, 24.96, -66.97, 49.37);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[] bestFit = grid.getCoverageBestFit();
        long[] solution = new long[]{0L, 0L, 0L, 0L, 0L};
        Assert.assertArrayEquals((long[])bestFit, (long[])solution);
    }

    @Test
    public void test6gridLoctoBounds4326() throws Exception {
        BoundingBox bbox = new BoundingBox(-124.73, 24.96, -66.97, 49.37);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[] gridLoc1 = new long[]{1L, 1L, 1L};
        BoundingBox box1 = grid.boundsFromIndex(gridLoc1);
        boolean box1_comparison = box1.equals((Object)new BoundingBox(-90.0, 0.0, 0.0, 90.0));
        Assert.assertTrue((boolean)box1_comparison);
        boolean box1_kml = box1.toKMLLatLonBox().equals("<LatLonBox><north>90.0</north><south>0.0</south><east>0.0</east><west>-90.0</west></LatLonBox>");
        Assert.assertTrue((boolean)box1_kml);
        long[] gridLoc2 = new long[]{5L, 1L, 2L};
        BoundingBox box2 = grid.boundsFromIndex(gridLoc2);
        boolean box2_comparison = box2.equals((Object)new BoundingBox(45.0, -45.0, 90.0, 0.0));
        Assert.assertTrue((boolean)box2_comparison);
        boolean box2_kml = box2.toKMLLatLonAltBox().equals("<LatLonAltBox><north>0.0</north><south>-45.0</south><east>90.0</east><west>45.0</west></LatLonAltBox>");
        Assert.assertTrue((boolean)box2_kml);
    }

    @Test
    public void test5gridLevels4326() throws Exception {
        BoundingBox bbox = new BoundingBox(-124.731422, 24.955967, -66.969849, 49.371735);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)10);
        long[][] solution = new long[][]{{0L, 0L, 0L, 0L, 0L}, {0L, 1L, 1L, 1L, 1L}, {1L, 2L, 2L, 3L, 2L}, {2L, 5L, 5L, 6L, 3L}};
        for (int i = 0; i < solution.length; ++i) {
            long[] bounds = grid.getCoverage(i);
            Assert.assertArrayEquals((long[])solution[i], (long[])bounds);
        }
    }

    @Test
    public void test0linearSearch() throws Exception {
        BoundingBox bbox = new BoundingBox(-4.0, -4.0, 4.0, 4.0);
        double[] resolutions = new double[]{8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
        GridSet gridSet = GridSetFactory.createGridSet((String)"bogus", (SRS)SRS.getSRS((int)0), (BoundingBox)bbox, (boolean)false, (double[])resolutions, null, null, (double)2.8E-4, null, (int)256, (int)256, (boolean)false);
        GridSubset gridSubset = GridSubsetFactory.createGridSubSet((GridSet)gridSet);
        BoundingBox tileBounds = this.createApproximateTileBounds(gridSubset, bbox, 5.04, 256, 256);
        long[] test = gridSubset.closestIndex(tileBounds);
        Assert.assertEquals((long)3L, (long)test[2]);
        tileBounds = this.createApproximateTileBounds(gridSubset, bbox, 8.03, 256, 256);
        test = gridSubset.closestIndex(tileBounds);
        Assert.assertEquals((long)0L, (long)test[2]);
        tileBounds = this.createApproximateTileBounds(gridSubset, bbox, 0.98, 256, 256);
        test = gridSubset.closestIndex(tileBounds);
        Assert.assertEquals((long)7L, (long)test[2]);
        tileBounds = this.createApproximateTileBounds(gridSubset, bbox, 1.005, 256, 256);
        test = gridSubset.closestIndex(tileBounds);
        Assert.assertEquals((long)7L, (long)test[2]);
        tileBounds = this.createApproximateTileBounds(gridSubset, bbox, 6.025, 256, 256);
        test = gridSubset.closestIndex(tileBounds);
        Assert.assertEquals((long)2L, (long)test[2]);
    }

    @Test
    public void testCustomSRSGridBottomLeft() throws Exception {
        BoundingBox bbox = new BoundingBox(587334.20625, 4912451.9275, 611635.54375, 4936753.265000001);
        BoundingBox gridBase = new BoundingBox(587334.20625, 4912451.9275, 611635.54375, 4936753.265000001);
        GridSet gridSet = GridSetFactory.createGridSet((String)"bogus", (SRS)SRS.getSRS((int)26713), (BoundingBox)gridBase, (boolean)false, (int)30, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        GridSubset gridSubset = GridSubsetFactory.createGridSubSet((GridSet)gridSet, (BoundingBox)bbox, (Integer)0, (Integer)20);
        Assert.assertTrue((Math.abs(gridSubset.getResolutions()[0] - 94.927) / 94.927 < 0.01 ? 1 : 0) != 0);
        long[] solution = new long[]{0L, 0L, 0L};
        Assert.assertArrayEquals((long[])solution, (long[])gridSubset.closestIndex(bbox));
        long[] gridLoc = new long[]{1L, 0L, 1L};
        BoundingBox bboxSolution = new BoundingBox(599484.8750000002, 4912451.9275, 611635.5437500004, 4924602.59625);
        Assert.assertEquals((Object)bboxSolution, (Object)gridSubset.boundsFromIndex(gridLoc));
        Assert.assertArrayEquals((long[])gridLoc, (long[])gridSubset.closestIndex(bboxSolution));
    }

    @Test
    public void testTopLeftNaive() throws Exception {
        BoundingBox bbox = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
        BoundingBox gridBase = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
        GridSet gridSet = GridSetFactory.createGridSet((String)"bogus", (SRS)SRS.getSRS((int)4326), (BoundingBox)gridBase, (boolean)true, (int)30, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        GridSubset gridSubset = GridSubsetFactory.createGridSubSet((GridSet)gridSet, (BoundingBox)bbox, (Integer)0, (Integer)20);
        long[] solution = new long[]{0L, 0L, 0L};
        long[] closest = gridSubset.closestIndex(new BoundingBox(-180.0, -90.0, 0.0, 90.0));
        Assert.assertArrayEquals((long[])solution, (long[])closest);
        long[] solution2 = new long[]{1L, 0L, 0L};
        closest = gridSubset.closestIndex(new BoundingBox(0.0, -90.0, 180.0, 90.0));
        Assert.assertArrayEquals((long[])solution2, (long[])closest);
        long[] t1 = new long[]{0L, 0L, 1L};
        BoundingBox test1 = gridSubset.boundsFromIndex(t1);
        Assert.assertTrue((Math.abs(test1.getMinX() + 180.0) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(test1.getMinY() + 90.0) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(test1.getMaxY()) < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testCustomSRSGridTopLeft() throws Exception {
        BoundingBox bbox = new BoundingBox(587334.20625, 4912451.9275, 611635.54375, 4936753.265000001);
        BoundingBox gridBase = new BoundingBox(587334.20625, 4912451.9275, 611635.54375, 4936753.265000001);
        GridSet gridSet = GridSetFactory.createGridSet((String)"bogus", (SRS)SRS.getSRS((int)26713), (BoundingBox)gridBase, (boolean)true, (int)30, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        GridSubset gridSubset = GridSubsetFactory.createGridSubSet((GridSet)gridSet, (BoundingBox)bbox, (Integer)0, (Integer)20);
        Assert.assertTrue((Math.abs(gridSubset.getResolutions()[0] - 94.927) / 94.927 < 0.01 ? 1 : 0) != 0);
        long[] solution = new long[]{0L, 0L, 0L};
        long[] closest = gridSubset.closestIndex(bbox);
        Assert.assertArrayEquals((long[])solution, (long[])closest);
        long[] gridLoc = new long[]{1L, 0L, 1L};
        BoundingBox bboxSolution = new BoundingBox(599484.8750000002, 4912451.9275, 611635.5437500004, 4924602.59625);
        Assert.assertEquals((Object)bboxSolution, (Object)gridSubset.boundsFromIndex(gridLoc));
        closest = gridSubset.closestIndex(bboxSolution);
        Assert.assertArrayEquals((long[])gridLoc, (long[])closest);
    }

    private BoundingBox createApproximateTileBounds(GridSubset gridSubset, BoundingBox bbox, double resolution, int tileWidth, int tileHeight) {
        double width = (double)tileWidth * resolution;
        double height = (double)tileHeight * resolution;
        BoundingBox ret = new BoundingBox(bbox.getMinX() + width, bbox.getMinY() + height, bbox.getMinX() + width * 2.0, bbox.getMinY() + height * 2.0);
        return ret;
    }
}

