/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Arrays;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DefaultGridSetsTest {
    @Test
    public void testDefaultMercatorGridSet() throws Exception {
        DefaultGridsets defaultGridSets = new DefaultGridsets(false, true);
        GridSetBroker broker = new GridSetBroker(Arrays.asList(defaultGridSets));
        GridSet epsg3857GridSet = broker.get("EPSG:3857");
        Assert.assertNotNull((String)"GridSetBroker missing EPSG:3857 GridSet", (Object)epsg3857GridSet);
        GridSet googleMapsCompatible = broker.get("GoogleMapsCompatible");
        Assert.assertNull((String)"Unexpected GoogleMapsCompatible GridSet found", (Object)googleMapsCompatible);
        GridSet epsg900913GridSet = broker.get("EPSG:900913");
        Assert.assertNull((String)"Unexpected EPSG:900913 GridSet found", (Object)epsg900913GridSet);
        GridSet defaultMercatorGridSet = broker.getWorldEpsg3857();
        Assert.assertNotNull((String)"GridSetBroker missing default mercator GridSet", (Object)defaultMercatorGridSet);
        Assert.assertEquals((String)"Unexpected default mercator GridSet", (Object)epsg3857GridSet, (Object)defaultMercatorGridSet);
    }

    @Test
    public void testNonGwc11xDefaultGridSets() throws Exception {
        DefaultGridsets defaultGridSets = new DefaultGridsets(false, false);
        GridSetBroker broker = new GridSetBroker(Arrays.asList(defaultGridSets));
        GridSet globalCrs84GridSet = broker.get("GlobalCRS84Geometric");
        Assert.assertNotNull((String)"GridSetBroker missing GlobalCRS84Geometric GridSet", (Object)globalCrs84GridSet);
        GridSet epsg4326GridSet = broker.get("EPSG:4326");
        Assert.assertNull((String)"Unexpected EPSG:4326 GridSet found", (Object)epsg4326GridSet);
        GridSet defaultUnprojectedGridSet = broker.getWorldEpsg4326();
        Assert.assertNotNull((String)"GridSetBroker missing default unprojected GridSet", (Object)defaultUnprojectedGridSet);
        Assert.assertEquals((String)"Unexpected default unprojected GridSet", (Object)globalCrs84GridSet, (Object)defaultUnprojectedGridSet);
        GridSet googleMapsCompatible = broker.get("GoogleMapsCompatible");
        Assert.assertNotNull((String)"GridSetBroker missing GoogleMapsCompatible GridSet", (Object)googleMapsCompatible);
        GridSet epsg3857GridSet = broker.get("EPSG:3857");
        Assert.assertNull((String)"Unexpected EPSG:3857 GridSet found", (Object)epsg3857GridSet);
        GridSet epsg900913GridSet = broker.get("EPSG:900913");
        Assert.assertNull((String)"Unexpected EPSG:900913 GridSet found", (Object)epsg900913GridSet);
        GridSet defaultMercatorGridSet = broker.getWorldEpsg3857();
        Assert.assertNotNull((String)"GridSetBroker missing default mercator GridSet", (Object)defaultMercatorGridSet);
        Assert.assertEquals((String)"Unexpected default mercator GridSet", (Object)googleMapsCompatible, (Object)defaultMercatorGridSet);
    }

    @Test
    public void test4326x2() {
        DefaultGridsets gs = new DefaultGridsets(true, true);
        GridSet base = gs.worldEpsg4326();
        GridSet x2 = gs.worldEpsg4326x2();
        Assert.assertThat((Object)base.getDescription(), (Matcher)CoreMatchers.containsString((String)"256"));
        Assert.assertThat((Object)x2.getDescription(), (Matcher)CoreMatchers.containsString((String)"512"));
        Assert.assertEquals((long)256L, (long)base.getTileWidth());
        Assert.assertEquals((long)256L, (long)base.getTileHeight());
        Assert.assertEquals((long)512L, (long)x2.getTileWidth());
        Assert.assertEquals((long)512L, (long)x2.getTileHeight());
        for (int level = 0; level < base.getNumLevels(); ++level) {
            Assert.assertEquals((double)base.getGrid(level).getScaleDenominator(), (double)(x2.getGrid(level).getScaleDenominator() * 2.0), (double)1.0E-6);
        }
    }

    @Test
    public void test3857x2() {
        DefaultGridsets gs = new DefaultGridsets(true, true);
        GridSet base = gs.worldEpsg3857();
        GridSet x2 = gs.worldEpsg3857x2();
        Assert.assertThat((Object)base.getDescription(), (Matcher)CoreMatchers.containsString((String)"256x256"));
        Assert.assertThat((Object)x2.getDescription(), (Matcher)CoreMatchers.containsString((String)"512x512"));
        Assert.assertEquals((long)256L, (long)base.getTileWidth());
        Assert.assertEquals((long)256L, (long)base.getTileHeight());
        Assert.assertEquals((long)512L, (long)x2.getTileWidth());
        Assert.assertEquals((long)512L, (long)x2.getTileHeight());
        for (int level = 0; level < base.getNumLevels(); ++level) {
            Assert.assertEquals((double)base.getGrid(level).getScaleDenominator(), (double)(x2.getGrid(level).getScaleDenominator() * 2.0), (double)1.0E-6);
        }
    }
}

