/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.thoughtworks.xstream.XStream;
import java.util.Arrays;
import org.custommonkey.xmlunit.XMLAssert;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.filter.parameters.IntegerParameterFilter;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.io.GeoWebCacheXStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StaticWebApplicationContext;

public class IntegerParameterFilterTest {
    private IntegerParameterFilter filter;
    private XStream xs;

    @Before
    public void setUp() {
        this.filter = new IntegerParameterFilter();
        this.filter.setKey("TEST");
        this.filter.setValues(Arrays.asList(42, 2, 0, -1, -200));
        this.filter.setDefaultValue("Default");
        this.filter.setThreshold(Integer.valueOf(1));
        this.xs = new GeoWebCacheXStream();
        this.xs = XMLConfiguration.getConfiguredXStream((XStream)this.xs, (WebApplicationContext)new StaticWebApplicationContext());
    }

    @Test
    public void testBasic() throws Exception {
        Assert.assertThat((Object)this.filter.getLegalValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"42", "2", "0", "-1", "-200"}));
        for (String test : Arrays.asList("42", "2", "0", "-1", "-200")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test));
        }
        for (String test : Arrays.asList("43", "41", "3", "1", "-2", "-199", "-201", "-42")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)false));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        Assert.assertThat((Object)this.filter.apply(null), (Matcher)Matchers.equalTo((Object)"Default"));
        Assert.assertThat((Object)this.filter.apply(""), (Matcher)Matchers.equalTo((Object)"Default"));
    }

    @Test
    public void testThreshold() throws Exception {
        this.filter.setThreshold(Integer.valueOf(15));
        for (String test : Arrays.asList("42", "2", "0", "-1", "-200")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test));
        }
        for (String test : Arrays.asList("42", "56", "28")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"42"));
        }
        for (String test : Arrays.asList("2", "16", "1")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"2"));
        }
        for (String test : Arrays.asList("0")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"0"));
        }
        for (String test : Arrays.asList("-1", "-15")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"-1"));
        }
        for (String test : Arrays.asList("-200", "-186", "-214")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"-200"));
        }
        for (String test : Arrays.asList("57", "27", "-42", "-100")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should not apply to %0", (Matcher)Matchers.is((Object)false), (Object[])new Object[]{test}));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        Assert.assertThat((Object)this.filter.apply(null), (Matcher)Matchers.equalTo((Object)"Default"));
        Assert.assertThat((Object)this.filter.apply(""), (Matcher)Matchers.equalTo((Object)"Default"));
    }

    @Test
    public void testToXML() throws Exception {
        XMLAssert.assertXMLEqual((String)"<integerParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <values>\n    <int>42</int>\n    <int>2</int>\n    <int>0</int>\n    <int>-1</int>\n    <int>-200</int>\n  </values>\n  <threshold>1</threshold>\n</integerParameterFilter>", (String)this.xs.toXML((Object)this.filter));
    }

    @Test
    public void testFromXML() throws Exception {
        Object o = this.xs.fromXML("<integerParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <values>\n    <int>42</int>\n    <int>2</int>\n    <int>0</int>\n    <int>-1</int>\n    <int>-200</int>\n  </values>\n  <threshold>15</threshold>\n</integerParameterFilter>");
        Assert.assertThat((Object)o, (Matcher)Matchers.instanceOf(IntegerParameterFilter.class));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)"TEST")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"defaultValue", (Matcher)Matchers.equalTo((Object)"Default")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"threshold", (Matcher)Matchers.equalTo((Object)15)));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"values", (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{42, 2, 0, -1, -200})));
    }

    @Test
    public void testCloneable() throws Exception {
        IntegerParameterFilter clone = this.filter.clone();
        Assert.assertThat((Object)clone.getDefaultValue(), (Matcher)Matchers.equalTo((Object)this.filter.getDefaultValue()));
        Assert.assertThat((Object)clone.getValues(), (Matcher)Matchers.equalTo((Object)this.filter.getValues()));
    }
}

