/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import java.util.Collections;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.util.PropertyRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StaticWebApplicationContext;

public class XMLConfigurationXSchemaTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public PropertyRule whitelistProperty = PropertyRule.system("GEOWEBCACHE_XSTREAM_WHITELIST");

    @Test
    public void testNotAllowNonGWCClass() throws Exception {
        ContextualConfigurationProvider.Context pc = ContextualConfigurationProvider.Context.REST;
        try (StaticWebApplicationContext wac = new StaticWebApplicationContext();){
            GeoWebCacheXStream xs = new GeoWebCacheXStream();
            xs = XMLConfiguration.getConfiguredXStreamWithContext((XStream)xs, (WebApplicationContext)wac, (ContextualConfigurationProvider.Context)pc);
            this.exception.expect(ForbiddenClassException.class);
            Object object = xs.fromXML("<" + Capture.class.getCanonicalName() + " />");
        }
    }

    @Ignore
    @Test
    public void testNotAllowNonXMLGWCClass() throws Exception {
        ContextualConfigurationProvider.Context pc = ContextualConfigurationProvider.Context.REST;
        try (StaticWebApplicationContext wac = new StaticWebApplicationContext();){
            GeoWebCacheXStream xs = new GeoWebCacheXStream();
            xs = XMLConfiguration.getConfiguredXStreamWithContext((XStream)xs, (WebApplicationContext)wac, (ContextualConfigurationProvider.Context)pc);
            this.exception.expect(ForbiddenClassException.class);
            Object object = xs.fromXML("<" + XMLConfigurationXSchemaTest.class.getCanonicalName() + " />");
        }
    }

    @Test
    public void testExtensionsCanAllow() throws Exception {
        GeoWebCacheXStream xs = new GeoWebCacheXStream();
        ContextualConfigurationProvider.Context pc = ContextualConfigurationProvider.Context.REST;
        WebApplicationContext wac = (WebApplicationContext)EasyMock.createMock((String)"wac", WebApplicationContext.class);
        XMLConfigurationProvider provider = (XMLConfigurationProvider)EasyMock.createMock((String)"provider", XMLConfigurationProvider.class);
        EasyMock.expect((Object)wac.getBeansOfType(XMLConfigurationProvider.class)).andReturn(Collections.singletonMap("provider", provider));
        EasyMock.expect((Object)wac.getBean("provider")).andReturn((Object)provider);
        Capture xsCap = EasyMock.newCapture();
        EasyMock.expect((Object)provider.getConfiguredXStream((XStream)EasyMock.capture((Capture)xsCap))).andStubAnswer(() -> {
            XStream xs1 = (XStream)xsCap.getValue();
            xs1.allowTypes(new Class[]{Capture.class});
            return xs1;
        });
        EasyMock.replay((Object[])new Object[]{wac, provider});
        xs = XMLConfiguration.getConfiguredXStreamWithContext((XStream)xs, (WebApplicationContext)wac, (ContextualConfigurationProvider.Context)pc);
        Object o = xs.fromXML("<" + Capture.class.getCanonicalName() + " />");
        Assert.assertThat((Object)o, (Matcher)Matchers.instanceOf(Capture.class));
        EasyMock.verify((Object[])new Object[]{wac, provider});
    }

    @Test
    public void testPropertyCanAllow() throws Exception {
        this.whitelistProperty.setValue("org.easymock.**");
        ContextualConfigurationProvider.Context pc = ContextualConfigurationProvider.Context.REST;
        try (StaticWebApplicationContext wac = new StaticWebApplicationContext();){
            GeoWebCacheXStream xs = new GeoWebCacheXStream();
            xs = XMLConfiguration.getConfiguredXStreamWithContext((XStream)xs, (WebApplicationContext)wac, (ContextualConfigurationProvider.Context)pc);
            Object o = xs.fromXML("<" + Capture.class.getCanonicalName() + " />");
            Assert.assertThat((Object)o, (Matcher)Matchers.instanceOf(Capture.class));
        }
    }

    @Test
    public void testPropertyCanAllowMultiple() throws Exception {
        this.whitelistProperty.setValue("org.easymock.**; org.junit.**");
        ContextualConfigurationProvider.Context pc = ContextualConfigurationProvider.Context.REST;
        try (StaticWebApplicationContext wac = new StaticWebApplicationContext();){
            GeoWebCacheXStream xs = new GeoWebCacheXStream();
            xs = XMLConfiguration.getConfiguredXStreamWithContext((XStream)xs, (WebApplicationContext)wac, (ContextualConfigurationProvider.Context)pc);
            Object o1 = xs.fromXML("<" + Capture.class.getCanonicalName() + " />");
            Object o2 = xs.fromXML("<" + TestName.class.getCanonicalName() + " />");
            Assert.assertThat((Object)o1, (Matcher)Matchers.instanceOf(Capture.class));
            Assert.assertThat((Object)o2, (Matcher)Matchers.instanceOf(TestName.class));
        }
    }
}

