/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.legends.LegendRawInfo;
import org.geowebcache.config.legends.LegendsRawInfo;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.util.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class XMLConfigurationTest {
    private static final Logger log = Logging.getLogger((String)XMLConfigurationTest.class.getName());
    private File configDir;
    private File configFile;
    private GridSetBroker gridSetBroker;
    private XMLConfiguration config;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public MockWepAppContextRule contextRule = new MockWepAppContextRule();

    @Before
    public void setUp() throws Exception {
        this.configDir = this.temp.getRoot();
        this.configFile = this.temp.newFile("geowebcache.xml");
        URL source = XMLConfiguration.class.getResource("geowebcache_130.xml");
        FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        this.gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        this.config = new XMLConfiguration(null, this.configDir.getAbsolutePath());
        this.config.setGridSetBroker(this.gridSetBroker);
        this.config.afterPropertiesSet();
    }

    @Test
    public void testAddLayer() throws Exception {
        int count = this.config.getLayerCount();
        WMSLayer tl = this.createTestLayer("testLayer");
        this.config.addLayer((TileLayer)tl);
        Assert.assertEquals((long)(count + 1), (long)this.config.getLayerCount());
        Assert.assertSame((Object)tl, this.config.getLayer("testLayer").get());
        try {
            this.config.addLayer((TileLayer)tl);
            Assert.fail((String)"Expected IllegalArgumentException on duplicate layer name");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Layer 'testLayer' already exists", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotAddLayer() throws Exception {
        TileLayer tl = (TileLayer)Mockito.mock(WMSLayer.class);
        Mockito.when((Object)tl.getName()).thenReturn((Object)"testLayer");
        Mockito.when((Object)tl.isTransientLayer()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.config.canSave(tl));
    }

    @Test
    public void testModifyLayer() throws Exception {
        WMSLayer layer1 = this.createTestLayer("testLayer");
        this.config.addLayer((TileLayer)layer1);
        int count = this.config.getLayerCount();
        WMSLayer layer2 = this.createTestLayer("testLayer");
        this.config.modifyLayer((TileLayer)layer2);
        Assert.assertEquals((long)count, (long)this.config.getLayerCount());
        Assert.assertSame((Object)layer2, this.config.getLayer("testLayer").get());
        layer1 = this.createTestLayer("another");
        try {
            this.config.modifyLayer((TileLayer)layer1);
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testRemoveLayer() {
        try {
            this.config.removeLayer("nonExistent");
            Assert.fail((String)"Expected exception removing nonExistant layer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Set tileLayerNames = this.config.getLayerNames();
        for (String name : tileLayerNames) {
            int count = this.config.getLayerCount();
            this.config.removeLayer(name);
            Assert.assertEquals((long)(count - 1), (long)this.config.getLayerCount());
        }
    }

    @Test
    public void testTemplate() throws Exception {
        Assert.assertTrue((boolean)this.configFile.delete());
        this.config.setTemplate("/geowebcache_empty.xml");
        this.config.setGridSetBroker(this.gridSetBroker);
        this.config.deinitialize();
        this.config.reinitialize();
        this.config.getLayerCount();
        Assert.assertEquals((long)0L, (long)this.config.getLayerCount());
        Assert.assertTrue((boolean)this.configFile.delete());
        this.config.setTemplate("/geowebcache.xml");
        this.config.setGridSetBroker(this.gridSetBroker);
        this.config.deinitialize();
        this.config.reinitialize();
        this.config.getLayerCount();
        Assert.assertEquals((long)3L, (long)this.config.getLayerCount());
        Assert.assertThat((Object)this.config.isWmtsCiteCompliant(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSave() throws Exception {
        for (String name : this.config.getLayerNames()) {
            int count = this.config.getLayerCount();
            this.config.removeLayer(name);
            Assert.assertEquals((long)(count - 1), (long)this.config.getLayerCount());
        }
        String layerName = "testLayer";
        Object[] wmsURL = new String[]{"http://wms.example.com/1", "http://wms.example.com/2"};
        String wmsStyles = "default,line";
        String wmsLayers = "states,border";
        List<String> mimeFormats = Arrays.asList("image/png", "image/jpeg");
        HashMap<String, GridSubset> subSets = new HashMap<String, GridSubset>();
        GridSubset gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.get("EPSG:4326"));
        subSets.put(gridSubSet.getName(), gridSubSet);
        StringParameterFilter filter = new StringParameterFilter();
        filter.setKey("STYLES");
        filter.setValues(Arrays.asList("polygon", "point"));
        filter.setDefaultValue("polygon");
        ArrayList<ParameterFilter> parameterFilters = new ArrayList<ParameterFilter>(new ArrayList<ParameterFilter>(Arrays.asList(filter)));
        int[] metaWidthHeight = new int[]{9, 9};
        String vendorParams = "vendor=1";
        boolean queryable = false;
        String wmsQueryLayers = null;
        WMSLayer layer = new WMSLayer(layerName, (String[])wmsURL, wmsStyles, wmsLayers, mimeFormats, subSets, parameterFilters, metaWidthHeight, vendorParams, queryable, wmsQueryLayers);
        LegendsRawInfo legendsRawInfo = new LegendsRawInfo();
        legendsRawInfo.setDefaultWidth(Integer.valueOf(50));
        legendsRawInfo.setDefaultHeight(Integer.valueOf(100));
        legendsRawInfo.setDefaultFormat("image/png");
        LegendRawInfo legendRawInfoA = new LegendRawInfo();
        legendRawInfoA.setStyle("polygon");
        legendRawInfoA.setWidth(Integer.valueOf(75));
        legendRawInfoA.setHeight(Integer.valueOf(125));
        legendRawInfoA.setFormat("image/jpeg");
        legendRawInfoA.setUrl("http://url");
        legendRawInfoA.setMinScale(Double.valueOf(5000.0));
        legendRawInfoA.setMaxScale(Double.valueOf(10000.0));
        LegendRawInfo legendRawInfoB = new LegendRawInfo();
        legendRawInfoB.setStyle("point");
        legendRawInfoB.setCompleteUrl("http://url");
        LegendRawInfo legendRawInfoC = new LegendRawInfo();
        legendRawInfoC.setStyle("");
        legendsRawInfo.addLegendRawInfo(legendRawInfoA);
        legendsRawInfo.addLegendRawInfo(legendRawInfoB);
        legendsRawInfo.addLegendRawInfo(legendRawInfoC);
        layer.setLegends(legendsRawInfo);
        this.config.addLayer((TileLayer)layer);
        try {
            XMLConfiguration.validate((Node)XMLConfiguration.loadDocument((InputStream)new FileInputStream(this.configFile)));
        }
        catch (SAXParseException e) {
            log.log(Level.SEVERE, e.getMessage());
            Assert.fail((String)e.getMessage());
        }
        XMLConfiguration config2 = new XMLConfiguration(null, this.configDir.getAbsolutePath());
        config2.setGridSetBroker(this.gridSetBroker);
        config2.afterPropertiesSet();
        config2.getLayerCount();
        Assert.assertEquals((long)1L, (long)config2.getLayerCount());
        Assert.assertThat((Object)config2.getLayer("testLayer"), TestUtils.isPresent());
        WMSLayer l = (WMSLayer)config2.getLayer("testLayer").get();
        Assert.assertArrayEquals((Object[])wmsURL, (Object[])l.getWMSurl());
        Assert.assertEquals((Object)wmsStyles, (Object)l.getStyles());
        Assert.assertEquals((Object)wmsLayers, (Object)l.getWmsLayers());
        Assert.assertEquals(mimeFormats, (Object)l.getMimeFormats());
        Assert.assertEquals(parameterFilters, (Object)l.getParameterFilters());
        for (GridSubset expected : subSets.values()) {
            GridSubset actual = l.getGridSubset(expected.getName());
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((Object)new XMLGridSubset(expected), (Object)new XMLGridSubset(actual));
        }
        Assert.assertThat((Object)l.getLegends(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)l.getLegends().getDefaultWidth(), (Matcher)Matchers.is((Object)50));
        Assert.assertThat((Object)l.getLegends().getDefaultHeight(), (Matcher)Matchers.is((Object)100));
        Assert.assertThat((Object)l.getLegends().getDefaultFormat(), (Matcher)Matchers.is((Object)"image/png"));
        Assert.assertThat((Object)l.getLegends().getLegendsRawInfo().size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)l.getLegends().getLegendsRawInfo(), (Matcher)Matchers.containsInAnyOrder((Object[])new LegendRawInfo[]{legendRawInfoA, legendRawInfoB, legendRawInfoC}));
    }

    public WMSLayer createTestLayer(String layerName) {
        String[] wmsURL = new String[]{"http://wms.example.com/1", "http://wms.example.com/2"};
        String wmsStyles = "default,line";
        String wmsLayers = "states,border";
        List<String> mimeFormats = Arrays.asList("image/png", "image/jpeg");
        HashMap<String, GridSubset> subSets = new HashMap<String, GridSubset>();
        GridSubset gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.get("EPSG:4326"));
        subSets.put(gridSubSet.getName(), gridSubSet);
        StringParameterFilter filter = new StringParameterFilter();
        filter.setKey("STYLES");
        filter.setValues(Arrays.asList("polygon", "point"));
        filter.setDefaultValue("polygon");
        ArrayList<ParameterFilter> parameterFilters = new ArrayList<ParameterFilter>(new ArrayList<ParameterFilter>(Arrays.asList(filter)));
        int[] metaWidthHeight = new int[]{9, 9};
        String vendorParams = "vendor=1";
        boolean queryable = false;
        String wmsQueryLayers = null;
        WMSLayer layer = new WMSLayer(layerName, wmsURL, wmsStyles, wmsLayers, mimeFormats, subSets, parameterFilters, metaWidthHeight, vendorParams, queryable, wmsQueryLayers);
        LegendsRawInfo legendsRawInfo = new LegendsRawInfo();
        legendsRawInfo.setDefaultWidth(Integer.valueOf(50));
        legendsRawInfo.setDefaultHeight(Integer.valueOf(100));
        legendsRawInfo.setDefaultFormat("image/png");
        LegendRawInfo legendRawInfoA = new LegendRawInfo();
        legendRawInfoA.setStyle("polygon");
        legendRawInfoA.setWidth(Integer.valueOf(75));
        legendRawInfoA.setHeight(Integer.valueOf(125));
        legendRawInfoA.setFormat("image/jpeg");
        legendRawInfoA.setUrl("http://url");
        legendRawInfoA.setMinScale(Double.valueOf(5000.0));
        legendRawInfoA.setMaxScale(Double.valueOf(10000.0));
        LegendRawInfo legendRawInfoB = new LegendRawInfo();
        legendRawInfoB.setStyle("point");
        legendRawInfoB.setCompleteUrl("http://url");
        LegendRawInfo legendRawInfoC = new LegendRawInfo();
        legendRawInfoC.setStyle("");
        legendsRawInfo.addLegendRawInfo(legendRawInfoA);
        legendsRawInfo.addLegendRawInfo(legendRawInfoB);
        legendsRawInfo.addLegendRawInfo(legendRawInfoC);
        layer.setLegends(legendsRawInfo);
        return layer;
    }

    @Test
    public void testSaveGridSet() throws Exception {
        String name = "testGrid";
        SRS srs = SRS.getEPSG4326();
        BoundingBox extent = new BoundingBox(-1.0, -1.0, 1.0, 1.0);
        boolean alignTopLeft = true;
        double[] resolutions = new double[]{3.0, 2.0, 1.0};
        double[] scaleDenoms = null;
        Double metersPerUnit = 1.5;
        double pixelSize = 5.6E-4;
        String[] scaleNames = new String[]{"uno", "dos", "tres"};
        int tileWidth = 128;
        int tileHeight = 512;
        boolean yCoordinateFirst = true;
        GridSet gridSet = GridSetFactory.createGridSet((String)name, (SRS)srs, (BoundingBox)extent, (boolean)alignTopLeft, (double[])resolutions, scaleDenoms, (Double)metersPerUnit, (double)pixelSize, (String[])scaleNames, (int)tileWidth, (int)tileHeight, (boolean)yCoordinateFirst);
        gridSet.setDescription("test description");
        this.config.addGridSet(gridSet);
        try {
            XMLConfiguration.validate((Node)XMLConfiguration.loadDocument((InputStream)new FileInputStream(this.configFile)));
        }
        catch (SAXParseException e) {
            log.log(Level.SEVERE, e.getMessage());
            Assert.fail((String)e.getMessage());
        }
        XMLConfiguration config2 = new XMLConfiguration(null, this.configDir.getAbsolutePath());
        GridSetBroker gridSetBroker2 = new GridSetBroker(Arrays.asList(new DefaultGridsets(true, true), config2));
        config2.setGridSetBroker(gridSetBroker2);
        config2.afterPropertiesSet();
        config2.getLayerCount();
        GridSet gridSet2 = gridSetBroker2.get(name);
        Assert.assertNotNull((Object)gridSet2);
        Assert.assertEquals((Object)gridSet, (Object)gridSet2);
    }

    @Test
    public void testOverrideGridSetDefaults() throws Exception {
        URL source = XMLConfiguration.class.getResource("geowebcache_4326_override.xml");
        FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        XMLConfiguration config2 = new XMLConfiguration(null, this.configDir.getAbsolutePath());
        DefaultGridsets defaultGridSets = new DefaultGridsets(true, true);
        this.gridSetBroker = new GridSetBroker(Arrays.asList(defaultGridSets));
        config2.setGridSetBroker(this.gridSetBroker);
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        HashMap<String, Object> beans = new HashMap<String, Object>(2);
        beans.put("defaultGridSets", defaultGridSets);
        beans.put("xmlConfig", config2);
        EasyMock.expect((Object)appContext.getBeansOfType(GridSetConfiguration.class)).andReturn(beans);
        EasyMock.expect((Object)appContext.getBean("defaultGridSets")).andReturn((Object)defaultGridSets);
        EasyMock.expect((Object)appContext.getBean("xmlConfig")).andReturn((Object)config2);
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoWebCacheExtensions gwcExtensions = new GeoWebCacheExtensions();
        gwcExtensions.setApplicationContext(appContext);
        GridSet override4326 = this.gridSetBroker.get("EPSG:4326");
        Assert.assertNotNull((Object)override4326);
        GridSet worldEpsg4326 = this.gridSetBroker.getWorldEpsg4326();
        Assert.assertNotNull((Object)worldEpsg4326);
        Assert.assertEquals((Object)override4326, (Object)worldEpsg4326);
        GridSet internal4326 = defaultGridSets.worldEpsg4326();
        Assert.assertEquals((String)"Unexpected number of Default EPSG:4326 resolution levels", (long)22L, (long)internal4326.getNumLevels());
        Assert.assertEquals((String)"Unexpected number of Overriden EPSG:4326 resolution levels", (long)14L, (long)override4326.getNumLevels());
        Grid overrideLevel = override4326.getGrid(0);
        Grid defaultLevel = internal4326.getGrid(0);
        Assert.assertEquals((String)"Unexpected default resolution level 0", (double)0.703125, (double)defaultLevel.getResolution(), (double)0.0);
        Assert.assertEquals((String)"Unexpected override resolution level 0", (double)1.40625, (double)overrideLevel.getResolution(), (double)0.0);
        String overrideDescription = override4326.getDescription();
        String defaultDescription = internal4326.getDescription();
        Assert.assertFalse((String)"Default EPSG:4326 GridSet description should not contain 'OVERRIDE'", (boolean)defaultDescription.contains("OVERRIDE"));
        Assert.assertTrue((String)"Overriden EPSG:4326 GridSet description should contain 'OVERRIDE'", (boolean)overrideDescription.contains("OVERRIDE"));
    }

    @Test
    public void testNoBlobStores() throws Exception {
        Assert.assertNotNull((Object)this.config.getBlobStores());
        Assert.assertTrue((boolean)this.config.getBlobStores().isEmpty());
    }

    @Test
    public void testSaveBlobStores() throws Exception {
        FileBlobStoreInfo store1 = new FileBlobStoreInfo();
        store1.setName("store1");
        store1.setDefault(true);
        store1.setEnabled(true);
        store1.setFileSystemBlockSize(8096);
        store1.setBaseDirectory("/tmp/test");
        FileBlobStoreInfo store2 = new FileBlobStoreInfo();
        store2.setName("store2");
        store2.setDefault(false);
        store2.setEnabled(false);
        store2.setFileSystemBlockSize(512);
        store2.setBaseDirectory("/tmp/test2");
        this.config.addBlobStore((BlobStoreInfo)store1);
        this.config.addBlobStore((BlobStoreInfo)store2);
        try {
            XMLConfiguration.validate((Node)XMLConfiguration.loadDocument((InputStream)new FileInputStream(this.configFile)));
        }
        catch (SAXParseException e) {
            log.log(Level.SEVERE, e.getMessage());
            Assert.fail((String)e.getMessage());
        }
        XMLConfiguration config2 = new XMLConfiguration(null, this.configDir.getAbsolutePath());
        config2.setGridSetBroker(new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true))));
        config2.afterPropertiesSet();
        config2.getLayerCount();
        List stores = config2.getBlobStores();
        Assert.assertNotNull((Object)stores);
        Assert.assertEquals((long)2L, (long)stores.size());
        Assert.assertNotSame((Object)store1, stores.get(0));
        Assert.assertEquals((Object)store1, stores.get(0));
        Assert.assertNotSame((Object)store2, stores.get(1));
        Assert.assertEquals((Object)store2, stores.get(1));
    }

    @Test
    public void testSaveCurrentVersion() throws Exception {
        URL source = XMLConfiguration.class.getResource("geowebcache_125.xml");
        this.configFile = new File(this.configDir, "geowebcache.xml");
        FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        this.gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        this.config = new XMLConfiguration(null, this.configDir.getAbsolutePath());
        this.config.setGridSetBroker(this.gridSetBroker);
        this.config.afterPropertiesSet();
        this.config.getLayerCount();
        String previousVersion = this.config.getVersion();
        Assert.assertNotNull((Object)previousVersion);
        this.config.modifyLayer((TileLayer)this.config.getLayer((String)this.config.getLayerNames().iterator().next()).get());
        String currVersion = XMLConfiguration.getCurrentSchemaVersion();
        Assert.assertNotNull((Object)currVersion);
        Assert.assertNotEquals((Object)previousVersion, (Object)currVersion);
        this.config = new XMLConfiguration(null, this.configDir.getAbsolutePath());
        this.config.setGridSetBroker(this.gridSetBroker);
        this.config.afterPropertiesSet();
        this.config.getLayerCount();
        String savedVersion = this.config.getVersion();
        Assert.assertEquals((Object)currVersion, (Object)savedVersion);
    }

    @Test
    public void testWmtsCiteStrictComplianceIsActivated() throws Exception {
        Assert.assertThat((Object)this.configFile.delete(), (Matcher)Matchers.is((Object)true));
        this.config.setTemplate("/geowebcache_cite.xml");
        this.config.setGridSetBroker(this.gridSetBroker);
        this.config.deinitialize();
        this.config.reinitialize();
        this.config.getLayerCount();
        Assert.assertThat((Object)this.config.isWmtsCiteCompliant(), (Matcher)Matchers.is((Object)true));
    }
}

