/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.GridSetConfigurationTest;
import org.geowebcache.config.TestXMLConfigurationSource;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.GridSet;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class XMLConfigurationGridsetConformanceTest
extends GridSetConfigurationTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    protected File configDir;
    protected File configFile;
    @Rule
    public MockWepAppContextRule extensions = new MockWepAppContextRule();
    @Rule
    public MockWepAppContextRule extensions2 = new MockWepAppContextRule(false);
    TestXMLConfigurationSource configSource = new TestXMLConfigurationSource();

    @Override
    protected GridSetConfiguration getConfig() throws Exception {
        this.makeConfigFile();
        return this.getConfig(this.extensions);
    }

    @Override
    protected GridSetConfiguration getSecondConfig() throws Exception {
        return this.getConfig(this.extensions2);
    }

    protected GridSetConfiguration getConfig(MockWepAppContextRule extensions) throws Exception {
        return this.configSource.create(extensions, this.configDir);
    }

    protected void makeConfigFile() throws IOException {
        if (this.configFile == null) {
            this.configDir = this.temp.getRoot();
            this.configFile = this.temp.newFile("geowebcache.xml");
            URL source = XMLConfiguration.class.getResource("geowebcache_130.xml");
            FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        }
    }

    @Override
    protected Matcher<GridSet> infoEquals(final GridSet expected) {
        return new CustomMatcher<GridSet>("GridSet matching " + expected.getName() + " with " + expected.getDescription()){

            public boolean matches(Object item) {
                return item instanceof GridSet && ((GridSet)item).getName().equals(expected.getName()) && ((GridSet)item).getDescription().equals(expected.getDescription());
            }
        };
    }

    @Override
    protected Matcher<GridSet> infoEquals(final int expected) {
        return new CustomMatcher<GridSet>("GridSet with value " + expected){

            public boolean matches(Object item) {
                return item instanceof GridSet && Objects.equals(((GridSet)item).getDescription(), Integer.toString(expected));
            }
        };
    }

    @Override
    protected String getExistingInfo() {
        return "EPSG:2163";
    }

    @Override
    public void failNextRead() {
        this.configSource.setFailNextRead(true);
    }

    @Override
    public void failNextWrite() {
        this.configSource.setFailNextWrite(true);
    }

    @Override
    protected void renameInfo(GridSetConfiguration config, String name1, String name2) throws Exception {
        Assume.assumeFalse((boolean)true);
    }
}

