/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.util.ApplicationContextProvider;
import org.geowebcache.util.PropertyRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.web.context.WebApplicationContext;

public class XMLConfigurationConstructorsTest {
    public static final String MARKED_CONFIG_FILE_NAME = "geowebcache-test-correct-config.xml";
    public static final String MARKED_LAYER = "LOADED_CORRECT_CONFIG_FILE";
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public PropertyRule gwcConfigDirProp = PropertyRule.system("GEOWEBCACHE_CONFIG_DIR");
    File configDir;
    File cacheDir;
    ApplicationContextProvider provider;
    WebApplicationContext appContext;
    ServletContext svltContext;
    DefaultStorageFinder storageFinder;
    GridSetBroker broker;

    @Before
    public void setUp() throws Exception {
        this.configDir = this.temp.newFolder("config");
        this.cacheDir = this.temp.newFolder("cache");
        this.provider = (ApplicationContextProvider)EasyMock.createMock(ApplicationContextProvider.class);
        this.appContext = (WebApplicationContext)EasyMock.createMock(WebApplicationContext.class);
        this.svltContext = (ServletContext)EasyMock.createMock(ServletContext.class);
        this.storageFinder = (DefaultStorageFinder)EasyMock.createMock(DefaultStorageFinder.class);
        this.broker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
        EasyMock.expect((Object)this.provider.getApplicationContext()).andStubReturn((Object)this.appContext);
        EasyMock.expect((Object)this.appContext.getServletContext()).andStubReturn((Object)this.svltContext);
        EasyMock.expect((Object)this.svltContext.getInitParameter((String)EasyMock.anyObject())).andStubReturn(null);
        EasyMock.expect((Object)this.storageFinder.getDefaultPath()).andStubReturn((Object)this.cacheDir.getCanonicalPath());
        EasyMock.expect((Object)this.appContext.getBeansOfType(XMLConfigurationProvider.class)).andReturn(Collections.emptyMap());
        EasyMock.expect((Object)this.svltContext.getRealPath("")).andStubReturn((Object)this.temp.getRoot().getCanonicalPath());
        EasyMock.replay((Object[])new Object[]{this.provider, this.appContext, this.svltContext, this.storageFinder});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.provider, this.appContext, this.svltContext, this.storageFinder});
    }

    public void shouldLoadFrom(File dir) throws IOException {
        File configFile = this.configFile(dir);
        URL source = XMLConfigurationConstructorsTest.class.getResource(MARKED_CONFIG_FILE_NAME);
        FileUtils.copyURLToFile((URL)source, (File)configFile);
    }

    protected File configFile(File dir) {
        return new File(dir, "geowebcache.xml");
    }

    public void shouldNotLoadFrom(File dir) throws IOException {
        File configFile = this.configFile(dir);
        URL source = XMLConfigurationConstructorsTest.class.getResource("geowebcache_130.xml");
        FileUtils.copyURLToFile((URL)source, (File)configFile);
    }

    @Test
    public void testDefaultToCacheDir() throws Exception {
        this.shouldLoadFrom(this.cacheDir);
        XMLConfiguration config = new XMLConfiguration(this.provider, this.storageFinder);
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        config.getLayerCount();
        Assert.assertThat((Object)config.getLayer(MARKED_LAYER), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testOverrideWithProperty() throws Exception {
        this.shouldLoadFrom(this.configDir);
        this.shouldNotLoadFrom(this.cacheDir);
        this.gwcConfigDirProp.setValue(this.configDir.getCanonicalPath());
        XMLConfiguration config = new XMLConfiguration(this.provider, this.storageFinder);
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        config.getLayerCount();
        Assert.assertThat((Object)config.getLayer(MARKED_LAYER), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testOverrideWithPropertyRelative() throws Exception {
        this.shouldLoadFrom(this.configDir);
        this.shouldNotLoadFrom(this.cacheDir);
        this.gwcConfigDirProp.setValue(this.configDir.getName());
        XMLConfiguration config = new XMLConfiguration(this.provider, this.storageFinder);
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        config.getLayerCount();
        Assert.assertThat((Object)config.getLayer(MARKED_LAYER), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testPathAsArgument() throws Exception {
        this.shouldLoadFrom(this.configDir);
        this.shouldNotLoadFrom(this.cacheDir);
        XMLConfiguration config = new XMLConfiguration(this.provider, this.configDir.getCanonicalPath());
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        Assert.assertThat((Object)config.getLayer(MARKED_LAYER), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testDefaultToCacheDirCreate() throws Exception {
        XMLConfiguration config = new XMLConfiguration(this.provider, this.storageFinder);
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        Assert.assertThat((Object)this.configFile(this.cacheDir).exists(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.configFile(this.configDir).exists(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testOverrideWithPropertyCreate() throws Exception {
        this.gwcConfigDirProp.setValue(this.configDir.getCanonicalPath());
        XMLConfiguration config = new XMLConfiguration(this.provider, this.storageFinder);
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        Assert.assertThat((Object)this.configFile(this.cacheDir).exists(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.configFile(this.configDir).exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testPathAsArgumentCreate() throws Exception {
        XMLConfiguration config = new XMLConfiguration(this.provider, this.configDir.getCanonicalPath());
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        Assert.assertThat((Object)this.configFile(this.cacheDir).exists(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.configFile(this.configDir).exists(), (Matcher)CoreMatchers.is((Object)true));
    }
}

