/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.MockConfigurationResourceProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class XMLConfigurationBackwardsCompatibilityTest {
    public static final String GWC_125_CONFIG_FILE = "geowebcache_125.xml";
    public static final String LATEST_FILENAME = "geowebcache_130.xml";

    @Test
    public void testLoadPre10() throws Exception {
        Iterable<TileLayer> layers = this.loadResource("geowebcache_pre10.xml");
        TileLayer layer = this.findLayer(layers, "topp:states");
        Assert.assertNotNull((Object)layer);
        TileLayer layer2 = this.findLayer(layers, "topp:states2");
        GridSubset grid = layer2.getGridSubsetForSRS(SRS.getSRS((int)2163));
        Assert.assertNotNull((Object)layer2);
        Assert.assertNotNull((Object)grid);
    }

    @Test
    public void testLoad10() throws Exception {
        Iterable<TileLayer> layers = this.loadResource("geowebcache_10.xml");
        TileLayer layer = this.findLayer(layers, "topp:states");
        Assert.assertNotNull((Object)layer);
        TileLayer layer2 = this.findLayer(layers, "topp:states2");
        GridSubset grid = layer2.getGridSubsetForSRS(SRS.getSRS((int)2163));
        Assert.assertNotNull((Object)layer2);
        Assert.assertNotNull((Object)grid);
    }

    @Test
    public void testLoad101() throws Exception {
        Iterable<TileLayer> layers = this.loadResource("geowebcache_101.xml");
        TileLayer layer = this.findLayer(layers, "topp:states");
        Assert.assertNotNull((Object)layer);
        TileLayer layer2 = this.findLayer(layers, "topp:states2");
        GridSubset grid = layer2.getGridSubsetForSRS(SRS.getSRS((int)2163));
        Assert.assertNotNull((Object)layer2);
        Assert.assertNotNull((Object)grid);
        Assert.assertEquals((long)layer.getBackendTimeout().intValue(), (long)60L);
        Assert.assertEquals((long)layer2.getBackendTimeout().intValue(), (long)235L);
        Assert.assertTrue((boolean)layer.isCacheBypassAllowed());
        Assert.assertFalse((boolean)layer2.isCacheBypassAllowed());
    }

    @Test
    public void testLoad114() throws Exception {
        Iterable<TileLayer> layers = this.loadResource("geowebcache_114.xml");
        TileLayer layer = this.findLayer(layers, "topp:states");
        Assert.assertNotNull((Object)layer);
        TileLayer layer2 = this.findLayer(layers, "topp:states2");
        GridSubset grid = layer2.getGridSubsetForSRS(SRS.getSRS((int)2163));
        Assert.assertNotNull((Object)layer2);
        Assert.assertNotNull((Object)grid);
        Assert.assertEquals((long)layer.getBackendTimeout().intValue(), (long)120L);
        Assert.assertEquals((long)layer2.getBackendTimeout().intValue(), (long)120L);
        Assert.assertTrue((boolean)layer.isCacheBypassAllowed());
        Assert.assertTrue((boolean)layer2.isCacheBypassAllowed());
        FormatModifier fm = layer.getFormatModifier((MimeType)ImageMime.jpeg);
        Assert.assertEquals((Object)fm.getBgColor(), (Object)"0xDDDDDD");
        Assert.assertEquals((Object)fm.getRequestFormat(), (Object)ImageMime.png);
        List filters = layer.getRequestFilters();
        Assert.assertEquals((Object)((RequestFilter)filters.get(0)).getName(), (Object)"testWMSRasterFilter");
        Assert.assertEquals((Object)((RequestFilter)filters.get(1)).getName(), (Object)"testFileRasterFilter");
    }

    @Test
    public void testLoad115() throws Exception {
        Iterable<TileLayer> layers = this.loadResource("geowebcache_115.xml");
        TileLayer layer = this.findLayer(layers, "topp:states");
        Assert.assertNotNull((Object)layer);
        TileLayer layer2 = this.findLayer(layers, "topp:states2");
        GridSubset grid = layer2.getGridSubsetForSRS(SRS.getSRS((int)2163));
        Assert.assertNotNull((Object)layer2);
        Assert.assertNotNull((Object)grid);
        Assert.assertEquals((long)layer.getBackendTimeout().intValue(), (long)120L);
        Assert.assertEquals((long)layer2.getBackendTimeout().intValue(), (long)120L);
        Assert.assertTrue((boolean)layer.isCacheBypassAllowed());
        Assert.assertTrue((boolean)layer2.isCacheBypassAllowed());
        FormatModifier fm = layer.getFormatModifier((MimeType)ImageMime.jpeg);
        Assert.assertEquals((Object)fm.getBgColor(), (Object)"0xDDDDDD");
        Assert.assertEquals((Object)fm.getRequestFormat(), (Object)ImageMime.png);
        List filters = layer.getRequestFilters();
        RequestFilter filter0 = (RequestFilter)filters.get(0);
        Assert.assertEquals((Object)filter0.getName(), (Object)"testWMSRasterFilter");
        RequestFilter filter1 = (RequestFilter)filters.get(1);
        Assert.assertEquals((Object)filter1.getName(), (Object)"testFileRasterFilter");
    }

    @Test
    public void testLoad126() throws Exception {
        XMLConfiguration config = this.loadConfig("geowebcache_126.xml");
        ServiceInformation serviceInfo = config.getServiceInformation();
        Assert.assertNotNull((Object)serviceInfo);
        Assert.assertEquals((Object)"GeoWebCache", (Object)serviceInfo.getTitle());
        Assert.assertEquals((Object)"GeoWebCache description.", (Object)serviceInfo.getDescription());
        Assert.assertEquals(Arrays.asList("WFS", "WMS", "WMTS", "GEOWEBCACHE"), (Object)serviceInfo.getKeywords());
        Assert.assertNotNull((Object)serviceInfo.getAccessConstraints());
        Assert.assertNotNull((Object)serviceInfo.getFees());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getProviderName());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getProviderSite());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getAddressAdministrativeArea());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getAddressCity());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getAddressCountry());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getAddressEmail());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getAddressPostalCode());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getAddressStreet());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getAddressType());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getFaxNumber());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getIndividualName());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getPhoneNumber());
        Assert.assertNotNull((Object)serviceInfo.getServiceProvider().getServiceContact().getPositionName());
        Collection layers = config.getLayers();
        TileLayer layer = this.findLayer(layers, "topp:states");
        Assert.assertNotNull((Object)layer);
        Assert.assertEquals((long)4L, (long)layer.getMimeTypes().size());
        Assert.assertTrue((boolean)layer.getGridSubsets().contains("EPSG:2163"));
    }

    private TileLayer findLayer(Iterable<TileLayer> layers, String layerName) throws GeoWebCacheException {
        Iterator<TileLayer> iter = layers.iterator();
        int i = 0;
        while (iter.hasNext()) {
            TileLayer layer = iter.next();
            if (layer.getName().equals(layerName)) {
                return layer;
            }
            ++i;
        }
        throw new GeoWebCacheException("Layer " + layerName + " not found, set has " + i + " layers.");
    }

    private Iterable<TileLayer> loadResource(String fileName) throws Exception {
        return this.loadConfig(fileName).getLayers();
    }

    private XMLConfiguration loadConfig(String fileName) throws Exception {
        XMLConfiguration xmlConfig = new XMLConfiguration(null, (ConfigurationResourceProvider)new MockConfigurationResourceProvider(() -> XMLConfiguration.class.getResourceAsStream(fileName)));
        GridSetBroker gsb = new GridSetBroker(Arrays.asList(new DefaultGridsets(true, true), xmlConfig));
        xmlConfig.setGridSetBroker(gsb);
        xmlConfig.afterPropertiesSet();
        for (TileLayer layer : xmlConfig.getLayers()) {
            layer.initialize(gsb);
        }
        return xmlConfig;
    }

    protected void print(Document dom) throws Exception {
        TransformerFactory txFactory = TransformerFactory.newInstance();
        try {
            txFactory.setAttribute("{http://xml.apache.org/xalan}indent-number", 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Transformer tx = txFactory.newTransformer();
        tx.setOutputProperty("method", "xml");
        tx.setOutputProperty("indent", "yes");
        tx.transform(new DOMSource(dom), new StreamResult(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
    }
}

