/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLFileResourceProvider;
import org.geowebcache.grid.GridSetBroker;
import org.springframework.context.ApplicationContext;

public class TestXMLConfigurationSource {
    protected boolean failNextRead;
    protected boolean failNextWrite;

    public XMLConfiguration create(MockWepAppContextRule extensions, File configDir) throws Exception {
        GridSetBroker gridSetBroker = new GridSetBroker();
        gridSetBroker.setApplicationContext((ApplicationContext)extensions.getMockContext());
        DefaultGridsets defaultGridsets = new DefaultGridsets(true, true);
        extensions.addBean("DefaultGridSets", defaultGridsets, DefaultGridsets.class, GridSetConfiguration.class, BaseConfiguration.class);
        XMLFileResourceProvider configProvider = new XMLFileResourceProvider("geowebcache.xml", extensions.getMockContext(), configDir.getAbsolutePath(), null){

            public InputStream in() throws IOException {
                if (TestXMLConfigurationSource.this.failNextRead) {
                    TestXMLConfigurationSource.this.failNextRead = false;
                    throw new IOException("Test failure on read");
                }
                return super.in();
            }

            public OutputStream out() throws IOException {
                if (TestXMLConfigurationSource.this.failNextWrite) {
                    TestXMLConfigurationSource.this.failNextWrite = false;
                    throw new IOException("Test failure on write");
                }
                return super.out();
            }
        };
        XMLConfiguration config = new XMLConfiguration(extensions.getContextProvider(), (ConfigurationResourceProvider)configProvider);
        extensions.addBean("XMLConfiguration", config, XMLConfiguration.class.getInterfaces());
        config.setGridSetBroker(gridSetBroker);
        config.afterPropertiesSet();
        defaultGridsets.afterPropertiesSet();
        gridSetBroker.afterPropertiesSet();
        return config;
    }

    public boolean isFailNextRead() {
        return this.failNextRead;
    }

    public void setFailNextRead(boolean failNextRead) {
        this.failNextRead = failNextRead;
    }

    public boolean isFailNextWrite() {
        return this.failNextWrite;
    }

    public void setFailNextWrite(boolean failNextWrite) {
        this.failNextWrite = failNextWrite;
    }
}

