/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.geowebcache.config.ListenerCollection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ListenerCollectionTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testEmpty() throws Exception {
        ListenerCollection collection = new ListenerCollection();
        collection.safeForEach(x -> Assert.fail((String)"should not be called"));
    }

    @Test
    public void testCallsListener() throws Exception {
        ListenerCollection collection = new ListenerCollection();
        Runnable l1 = (Runnable)EasyMock.createMock((String)"l1", Runnable.class);
        l1.run();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{l1});
        collection.add((Object)l1);
        collection.safeForEach(Runnable::run);
        EasyMock.verify((Object[])new Object[]{l1});
    }

    @Test
    public void testCallsListeners() throws Exception {
        ListenerCollection collection = new ListenerCollection();
        IMocksControl control = EasyMock.createControl();
        Runnable l1 = (Runnable)control.createMock("l1", Runnable.class);
        Runnable l2 = (Runnable)control.createMock("l2", Runnable.class);
        control.checkOrder(true);
        l1.run();
        EasyMock.expectLastCall().once();
        l2.run();
        EasyMock.expectLastCall().once();
        control.replay();
        collection.add((Object)l1);
        collection.add((Object)l2);
        collection.safeForEach(Runnable::run);
        control.verify();
    }

    @Test
    public void testRemove() throws Exception {
        ListenerCollection collection = new ListenerCollection();
        IMocksControl control = EasyMock.createControl();
        Runnable l1 = (Runnable)control.createMock("l1", Runnable.class);
        Runnable l2 = (Runnable)control.createMock("l2", Runnable.class);
        control.checkOrder(true);
        l2.run();
        EasyMock.expectLastCall().once();
        control.replay();
        collection.add((Object)l1);
        collection.add((Object)l2);
        collection.remove((Object)l1);
        collection.safeForEach(Runnable::run);
        control.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testException() throws Exception {
        ListenerCollection collection = new ListenerCollection();
        IMocksControl control = EasyMock.createControl();
        Runnable l1 = (Runnable)control.createMock("l1", Runnable.class);
        IllegalArgumentException e1 = new IllegalArgumentException();
        control.checkOrder(true);
        l1.run();
        EasyMock.expectLastCall().andThrow((Throwable)e1);
        control.replay();
        try {
            collection.add((Object)l1);
            this.exception.expect(Matchers.sameInstance((Object)e1));
            collection.safeForEach(Runnable::run);
        }
        finally {
            control.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionDoesntPreventOthers() throws Exception {
        ListenerCollection collection = new ListenerCollection();
        IMocksControl control = EasyMock.createControl();
        Runnable l1 = (Runnable)control.createMock("l1", Runnable.class);
        Runnable l2 = (Runnable)control.createMock("l2", Runnable.class);
        IllegalArgumentException e1 = new IllegalArgumentException();
        control.checkOrder(true);
        l1.run();
        EasyMock.expectLastCall().andThrow((Throwable)e1);
        l2.run();
        EasyMock.expectLastCall().once();
        control.replay();
        try {
            collection.add((Object)l1);
            collection.add((Object)l2);
            this.exception.expect(Matchers.sameInstance((Object)e1));
            collection.safeForEach(Runnable::run);
        }
        finally {
            control.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuppressedExceptionsRecorded() throws Exception {
        ListenerCollection collection = new ListenerCollection();
        IMocksControl control = EasyMock.createControl();
        Runnable l1 = (Runnable)control.createMock("l1", Runnable.class);
        Runnable l2 = (Runnable)control.createMock("l2", Runnable.class);
        IllegalArgumentException e1 = new IllegalArgumentException();
        IllegalArgumentException e2 = new IllegalArgumentException();
        control.checkOrder(true);
        l1.run();
        EasyMock.expectLastCall().andThrow((Throwable)e1);
        l2.run();
        EasyMock.expectLastCall().andThrow((Throwable)e2);
        control.replay();
        try {
            collection.add((Object)l1);
            collection.add((Object)l2);
            this.exception.expect((Matcher)Matchers.both((Matcher)Matchers.sameInstance((Object)e2)).and(Matchers.hasProperty((String)"suppressed", (Matcher)Matchers.arrayContaining((Matcher[])new Matcher[]{Matchers.sameInstance((Object)e1)}))));
            collection.safeForEach(Runnable::run);
        }
        finally {
            control.verify();
        }
    }
}

