/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.geowebcache.config.GWCConfigIntegrationTestData;
import org.geowebcache.config.GWCConfigIntegrationTestSupport;
import org.geowebcache.config.GWCXMLConfigIntegrationTestSupport;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.storage.BlobStoreAggregator;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class GWCConfigIntegrationTest {
    @Parameterized.Parameter
    public GWCConfigIntegrationTestSupport testSupport;
    public GridSetBroker gridSetBroker;
    public TileLayerDispatcher tileLayerDispatcher;
    public BlobStoreAggregator blobStoreAggregator;

    @Parameterized.Parameters
    public static Collection<GWCConfigIntegrationTestSupport[]> data() throws Exception {
        return Arrays.asList(new GWCConfigIntegrationTestSupport[][]{{new GWCXMLConfigIntegrationTestSupport()}});
    }

    @Before
    public void setUpTest() throws Exception {
        this.testSupport.resetConfiguration();
        GWCConfigIntegrationTestData.setUpTestData(this.testSupport);
        this.gridSetBroker = this.testSupport.getGridSetBroker();
        this.tileLayerDispatcher = new TileLayerDispatcher(this.gridSetBroker, this.testSupport.getTileLayerConfigurations(), null);
        this.blobStoreAggregator = new BlobStoreAggregator(Collections.singletonList(this.testSupport.getBlobStoreConfiguration()), this.tileLayerDispatcher);
    }
}

