/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.GWCConfigIntegrationTestData;
import org.geowebcache.config.GWCXMLConfigIntegrationTestSupport;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.GridSetBroker;
import org.junit.Assert;
import org.junit.Test;

public class GWCConfigIntegrationRoundTripTest {
    @Test
    public void testXMLConfiguration() throws Exception {
        GWCXMLConfigIntegrationTestSupport testSupport = new GWCXMLConfigIntegrationTestSupport();
        GWCConfigIntegrationTestData.setUpTestData(testSupport);
        File configDirCopy = Files.createTempDirectory("gwc", new FileAttribute[0]).toFile();
        File configFileCopy = new File(configDirCopy, "geowebcache.xml");
        configDirCopy.deleteOnExit();
        FileUtils.copyFile((File)testSupport.configFile, (File)configFileCopy);
        XMLConfiguration configCopy = new XMLConfiguration(null, configDirCopy.getAbsolutePath());
        configCopy.setGridSetBroker(new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true))));
        configCopy.afterPropertiesSet();
        this.assertTileLayerConfiguration((TileLayerConfiguration)configCopy);
        this.assertGridSetConfiguration((GridSetConfiguration)configCopy);
        this.assertBlobStoreConfiguration((BlobStoreConfiguration)configCopy);
    }

    private void assertTileLayerConfiguration(TileLayerConfiguration config) {
        List<String> layerNames = Arrays.asList(GWCConfigIntegrationTestData.LAYERS);
        for (String layerName : config.getLayerNames()) {
            Assert.assertTrue((boolean)layerNames.contains(layerName));
        }
        Assert.assertEquals((long)GWCConfigIntegrationTestData.LAYERS.length, (long)config.getLayerNames().size());
        Assert.assertEquals((long)GWCConfigIntegrationTestData.LAYERS.length, (long)config.getLayerCount());
    }

    private void assertGridSetConfiguration(GridSetConfiguration config) {
    }

    private void assertBlobStoreConfiguration(BlobStoreConfiguration config) {
        List blobStores = config.getBlobStores();
        List<String> blobStoreNames = Arrays.asList(GWCConfigIntegrationTestData.BLOBSTORES);
        for (BlobStoreInfo blobStoreConfig : blobStores) {
            Assert.assertTrue((boolean)blobStoreNames.contains(blobStoreConfig.getName()));
        }
        Assert.assertEquals((long)GWCConfigIntegrationTestData.BLOBSTORES.length, (long)blobStores.size());
    }
}

