/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.DefaultingConfiguration;
import org.geowebcache.config.GeoWebCacheConfiguration;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.junit.Assert;
import org.junit.Test;

public class DefaultingConfigurationTest {
    DefaultingConfiguration config = this.getConfig();
    TileLayer tl = new WMSLayer("test", new String[]{"http://example.com/"}, null, Integer.toString(1), null, null, null, null, null, false, null);
    GeoWebCacheConfiguration gwcConfig = new GeoWebCacheConfiguration();
    GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));

    @Test
    public void testUnsetConfigs() {
        Assert.assertNull((Object)this.tl.isCacheBypassAllowed());
        Assert.assertNull((Object)this.tl.getBackendTimeout());
        Assert.assertNull((Object)this.tl.getFormatModifiers());
    }

    @Test
    public void testSetDefault() {
        this.config.setDefaultValues(this.tl);
        boolean cacheBypass = this.tl.isCacheBypassAllowed();
        int timeout = this.tl.getBackendTimeout();
        Assert.assertFalse((boolean)cacheBypass);
        Assert.assertEquals((long)timeout, (long)120L);
        Assert.assertNull((Object)this.tl.getFormatModifiers());
    }

    @Test
    public void initializationTest() {
        this.initialize(this.tl);
        Set subsets = this.tl.getGridSubsets();
        Assert.assertEquals((long)subsets.size(), (long)2L);
        Assert.assertEquals((Object)subsets.toArray()[0], (Object)"EPSG:4326");
        Assert.assertEquals((Object)subsets.toArray()[1], (Object)"EPSG:900913");
    }

    GeoWebCacheConfiguration getGwcConfig() {
        return this.gwcConfig;
    }

    DefaultingConfiguration getConfig() {
        return new DefaultingConfiguration(){

            public void setDefaultValues(TileLayer layer) {
                if (layer.isCacheBypassAllowed() == null) {
                    if (DefaultingConfigurationTest.this.getGwcConfig().getCacheBypassAllowed() != null) {
                        layer.setCacheBypassAllowed(DefaultingConfigurationTest.this.getGwcConfig().getCacheBypassAllowed().booleanValue());
                    } else {
                        layer.setCacheBypassAllowed(false);
                    }
                }
                if (layer.getBackendTimeout() == null) {
                    if (DefaultingConfigurationTest.this.getGwcConfig().getBackendTimeout() != null) {
                        layer.setBackendTimeout(DefaultingConfigurationTest.this.getGwcConfig().getBackendTimeout().intValue());
                    } else {
                        layer.setBackendTimeout(120);
                    }
                }
                if (layer.getFormatModifiers() == null && DefaultingConfigurationTest.this.getGwcConfig().getFormatModifiers() != null) {
                    layer.setFormatModifiers(DefaultingConfigurationTest.this.getGwcConfig().getFormatModifiers());
                }
                if (layer instanceof WMSLayer) {
                    WMSLayer wl = (WMSLayer)layer;
                    URL proxyUrl = null;
                    try {
                        if (DefaultingConfigurationTest.this.getGwcConfig().getProxyUrl() != null) {
                            proxyUrl = new URL(DefaultingConfigurationTest.this.getGwcConfig().getProxyUrl());
                        } else if (wl.getProxyUrl() != null) {
                            proxyUrl = new URL(wl.getProxyUrl());
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    WMSHttpHelper sourceHelper = wl.getHttpUsername() != null ? new WMSHttpHelper(wl.getHttpUsername(), wl.getHttpPassword(), proxyUrl) : (DefaultingConfigurationTest.this.getGwcConfig().getHttpUsername() != null ? new WMSHttpHelper(DefaultingConfigurationTest.this.getGwcConfig().getHttpUsername(), DefaultingConfigurationTest.this.getGwcConfig().getHttpPassword(), proxyUrl) : new WMSHttpHelper(null, null, proxyUrl));
                    wl.setSourceHelper((WMSSourceHelper)sourceHelper);
                    wl.setLockProvider(DefaultingConfigurationTest.this.getGwcConfig().getLockProvider());
                }
            }

            public void afterPropertiesSet() throws GeoWebCacheException {
            }

            public String getIdentifier() {
                return null;
            }

            public String getLocation() {
                return null;
            }

            public void deinitialize() throws Exception {
            }
        };
    }

    private void initialize(TileLayer layer) {
        this.config.setDefaultValues(layer);
        layer.initialize(this.gridSetBroker);
    }
}

