/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.ConfigurationPersistenceException;
import org.geowebcache.config.Info;
import org.geowebcache.util.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class ConfigurationTest<I extends Info, C extends BaseConfiguration> {
    protected C config;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUpTestUnit() throws Exception {
        this.config = this.getConfig();
    }

    @After
    public void assertNameSetMatchesCollection() throws Exception {
        this.assertNameSetMatchesCollection(this.config);
    }

    @Test
    public void testAdd() throws Exception {
        I goodGridSet = this.getGoodInfo("test", 1);
        this.addInfo(this.config, goodGridSet);
        Info retrieved = (Info)TestUtils.assertPresent(this.getInfo(this.config, "test"));
        Assert.assertThat((Object)retrieved, this.infoEquals(goodGridSet));
    }

    @Test
    public void testPersistAdd() throws Exception {
        I goodGridSet = this.getGoodInfo("test", 1);
        this.addInfo(this.config, goodGridSet);
        C config2 = this.getSecondConfig();
        Info retrieved = (Info)TestUtils.assertPresent(this.getInfo(config2, "test"));
        Assert.assertThat((Object)retrieved, this.infoEquals(goodGridSet));
        this.assertNameSetMatchesCollection(config2);
    }

    @Test
    public void testDoubleAddException() throws Exception {
        I goodGridSet = this.getGoodInfo("test", 1);
        I doubleGridSet = this.getGoodInfo("test", 2);
        Assert.assertThat((String)"Invalid test", goodGridSet, (Matcher)Matchers.not(this.infoEquals(doubleGridSet)));
        this.addInfo(this.config, goodGridSet);
        this.exception.expect(Matchers.instanceOf(IllegalArgumentException.class));
        this.addInfo(this.config, doubleGridSet);
    }

    @Test
    public void testDoubleAddNoChange() throws Exception {
        I goodGridSet = this.getGoodInfo("test", 1);
        I doubleGridSet = this.getGoodInfo("test", 2);
        Assert.assertThat((String)"Invalid test", goodGridSet, (Matcher)Matchers.not(this.infoEquals(doubleGridSet)));
        this.addInfo(this.config, goodGridSet);
        try {
            this.addInfo(this.config, doubleGridSet);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Info retrieved = (Info)TestUtils.assertPresent(this.getInfo(this.config, "test"));
        Assert.assertThat((Object)retrieved, this.infoEquals(goodGridSet));
    }

    @Test
    public void testAddBadInfoException() throws Exception {
        I badGridSet = this.getBadInfo("test", 1);
        this.exception.expect(IllegalArgumentException.class);
        this.addInfo(this.config, badGridSet);
    }

    @Test
    public void testBadInfoNoAdd() throws Exception {
        I badInfo = this.getBadInfo("test", 1);
        try {
            this.addInfo(this.config, badInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Optional<I> retrieved = this.getInfo(this.config, "test");
        Assert.assertThat(retrieved, TestUtils.notPresent());
    }

    @Test
    public void testRemove() throws Exception {
        this.testAdd();
        this.removeInfo(this.config, "test");
        Optional<I> retrieved = this.getInfo(this.config, "test");
        Assert.assertThat(retrieved, TestUtils.notPresent());
    }

    @Test
    public void testPersistRemove() throws Exception {
        I goodGridSet = this.getGoodInfo("test", 1);
        this.addInfo(this.config, goodGridSet);
        this.removeInfo(this.config, "test");
        C config2 = this.getSecondConfig();
        Optional<I> retrieved = this.getInfo(config2, "test");
        Assert.assertThat(retrieved, TestUtils.notPresent());
        this.assertNameSetMatchesCollection(config2);
    }

    @Test
    public void testGetNotExists() throws Exception {
        Optional<I> retrieved = this.getInfo(this.config, "GridSetThatDoesntExist");
    }

    @Test
    public void testRemoveNotExists() throws Exception {
        this.exception.expect(NoSuchElementException.class);
        this.removeInfo(this.config, "GridSetThatDoesntExist");
    }

    @Test
    public void testModify() throws Exception {
        this.testAdd();
        I goodGridSet = this.getGoodInfo("test", 2);
        this.modifyInfo(this.config, goodGridSet);
        Optional<I> retrieved = this.getInfo(this.config, "test");
        Assert.assertThat(retrieved, TestUtils.isPresent(this.infoEquals(goodGridSet)));
    }

    @Test
    public void testModifyBadGridSetException() throws Exception {
        this.testAdd();
        I badGridSet = this.getBadInfo("test", 2);
        this.exception.expect(IllegalArgumentException.class);
        this.modifyInfo(this.config, badGridSet);
    }

    @Test
    public void testModifyBadGridSetNoChange() throws Exception {
        this.testAdd();
        Info goodGridSet = (Info)TestUtils.requirePresent(this.getInfo(this.config, "test"));
        I badGridSet = this.getBadInfo("test", 2);
        try {
            this.modifyInfo(this.config, badGridSet);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Optional<I> retrieved = this.getInfo(this.config, "test");
        Assert.assertThat(retrieved, TestUtils.isPresent(this.infoEquals(goodGridSet)));
    }

    @Test
    public void testPersistModify() throws Exception {
        I goodGridSet1 = this.getGoodInfo("test", 1);
        this.addInfo(this.config, goodGridSet1);
        I goodGridSet = this.getGoodInfo("test", 2);
        this.modifyInfo(this.config, goodGridSet);
        C config2 = this.getSecondConfig();
        Optional<I> retrieved = this.getInfo(config2, "test");
        Assert.assertThat(retrieved, TestUtils.isPresent(this.infoEquals(goodGridSet)));
        this.assertNameSetMatchesCollection(config2);
    }

    @Test
    public void testModifyNotExistsExcpetion() throws Exception {
        I goodGridSet = this.getGoodInfo("test", 2);
        this.exception.expect(NoSuchElementException.class);
        this.modifyInfo(this.config, goodGridSet);
    }

    @Test
    public void testModifyNotExistsNoChange() throws Exception {
        I goodGridSet = this.getGoodInfo("GridSetThatDoesntExist", 2);
        try {
            this.modifyInfo(this.config, goodGridSet);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Optional<I> retrieved = this.getInfo(this.config, "GridSetThatDoesntExist");
        Assert.assertThat(retrieved, TestUtils.notPresent());
    }

    @Test
    public void testGetExisting() throws Exception {
        Optional<I> retrieved = this.getInfo(this.config, this.getExistingInfo());
        Assert.assertThat(retrieved, TestUtils.isPresent());
    }

    @Test
    public void testCantModifyReturnedCollection() throws Exception {
        I info = this.getGoodInfo("test", 1);
        try {
            this.getInfos(this.config).add(info);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertThat(this.getInfo(this.config, "test"), TestUtils.notPresent());
    }

    @Test
    public void testModifyCallRequiredToChangeInfoFromGetInfo() throws Exception {
        this.testAdd();
        Info goodGridSet = (Info)TestUtils.requirePresent(this.getInfo(this.config, "test"));
        this.doModifyInfo(goodGridSet, 2);
        Optional<I> retrieved = this.getInfo(this.config, "test");
        Assert.assertThat(retrieved, TestUtils.isPresent(this.infoEquals(this.getGoodInfo("test", 1))));
        Assert.assertThat(retrieved, TestUtils.isPresent(Matchers.not(this.infoEquals(this.getGoodInfo("test", 2)))));
    }

    @Test
    public void testModifyCallRequiredToChangeInfoFromGetInfos() throws Exception {
        this.testAdd();
        Info goodGridSet = TestUtils.requirePresent(this.getInfos(this.config).stream().filter(i -> i.getName().equals("test")).findAny());
        this.doModifyInfo(goodGridSet, 2);
        Optional<I> retrieved = this.getInfo(this.config, "test");
        Assert.assertThat(retrieved, TestUtils.isPresent(this.infoEquals(this.getGoodInfo("test", 1))));
        Assert.assertThat(retrieved, TestUtils.isPresent(Matchers.not(this.infoEquals(this.getGoodInfo("test", 2)))));
    }

    @Test
    public void testModifyCallRequiredToChangeExistingInfoFromGetInfo() throws Exception {
        String name = this.getExistingInfo();
        Info goodGridSet = (Info)TestUtils.requirePresent(this.getInfo(this.config, name));
        this.doModifyInfo(goodGridSet, 2);
        Optional<I> retrieved = this.getInfo(this.config, name);
        Assert.assertThat(retrieved, TestUtils.isPresent(Matchers.not(this.infoEquals(2))));
    }

    @Test
    public void testModifyCallRequiredToChangeExistingInfoFromGetInfos() throws Exception {
        String name = this.getExistingInfo();
        Info goodGridSet = TestUtils.requirePresent(this.getInfos(this.config).stream().filter(i -> i.getName().equals(name)).findAny());
        this.doModifyInfo(goodGridSet, 2);
        Optional<I> retrieved = this.getInfo(this.config, name);
        Assert.assertThat(retrieved, TestUtils.isPresent(Matchers.not(this.infoEquals(2))));
    }

    protected abstract void doModifyInfo(I var1, int var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoChangeOnPersistExceptionOnAdd() throws Exception {
        I goodGridSet = this.getGoodInfo("test", 1);
        this.failNextWrite();
        this.exception.expect(ConfigurationPersistenceException.class);
        try {
            this.addInfo(this.config, goodGridSet);
        }
        finally {
            Optional<I> retrieved = this.getInfo(this.config, "test");
            Assert.assertThat(retrieved, TestUtils.notPresent());
            C config2 = this.getSecondConfig();
            Optional<I> retrieved2 = this.getInfo(config2, "test");
            Assert.assertThat(retrieved2, TestUtils.notPresent());
            this.assertNameSetMatchesCollection(config2);
        }
    }

    @Test
    public void testRename() throws Exception {
        this.testAdd();
        this.renameInfo(this.config, "test", "test2");
        Optional<I> retrieved = this.getInfo(this.config, "test2");
        Assert.assertThat(retrieved, TestUtils.isPresent());
        Optional<I> retrievedOld = this.getInfo(this.config, "test");
        Assert.assertThat(retrievedOld, TestUtils.notPresent());
    }

    @Test
    public void testConcurrentAdds() throws Exception {
        int defaultCount = this.getInfoNames(this.config).size();
        for (int i = 0; i < 10; ++i) {
            I goodInfo = this.getGoodInfo(Integer.toString(i), i);
            this.addInfo(this.config, goodInfo);
        }
        Assert.assertEquals((String)"Unexpected number of Info config elements", (long)(defaultCount + 10), (long)this.getInfoNames(this.config).size());
        ExecutorService pool = Executors.newFixedThreadPool(16, r -> new Thread(r, "Info Concurrency Test for ADD"));
        ArrayList<Future<Info>> futures = new ArrayList<Future<Info>>(100);
        for (int i = 0; i < 100; ++i) {
            int n = 100 + i;
            I info = this.getGoodInfo(Integer.toString(n), n);
            Future<Info> future = pool.submit(() -> {
                this.addInfo(this.config, info);
                return info;
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((String)"Unexpected number of Info config elements", (long)(defaultCount + 110), (long)this.getInfoNames(this.config).size());
    }

    @Test
    public void testConcurrentDeletes() throws Exception {
        int defaultCount = this.getInfoNames(this.config).size();
        for (int i = 0; i < 100; ++i) {
            I goodInfo = this.getGoodInfo(Integer.toString(i), i);
            this.addInfo(this.config, goodInfo);
        }
        Assert.assertEquals((String)"Unexpected number of Info config elements", (long)(defaultCount + 100), (long)this.getInfoNames(this.config).size());
        ExecutorService pool = Executors.newFixedThreadPool(16, r -> new Thread(r, "Info Concurrency Test for DELETE"));
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>(100);
        for (int i = 0; i < 100; ++i) {
            String string = Integer.toString(i);
            Future<String> future = pool.submit(() -> {
                this.removeInfo(this.config, name);
                return name;
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((String)"Unexpected number of Info config elements", (long)defaultCount, (long)this.getInfoNames(this.config).size());
    }

    @Test
    public void testConcurrentModifies() throws Exception {
        int defaultCount = this.getInfoNames(this.config).size();
        for (int i = 0; i < 100; ++i) {
            I goodInfo = this.getGoodInfo(Integer.toString(i), i);
            this.addInfo(this.config, goodInfo);
        }
        Assert.assertEquals((String)"Unexpected number of Info config elements", (long)(defaultCount + 100), (long)this.getInfoNames(this.config).size());
        ExecutorService pool = Executors.newFixedThreadPool(16, r -> new Thread(r, "Info Concurrency Test for MODIFY"));
        ArrayList<Future<Info>> futures = new ArrayList<Future<Info>>(100);
        for (int i = 0; i < 100; ++i) {
            int n = i;
            int modifiedId = 200 + i;
            I modifiedInfo = this.getGoodInfo(Integer.toString(n), modifiedId);
            Future<Info> future = pool.submit(() -> {
                this.modifyInfo(this.config, modifiedInfo);
                return modifiedInfo;
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((String)"Unexpected number of Info config elements", (long)(defaultCount + 100), (long)this.getInfoNames(this.config).size());
    }

    protected abstract I getGoodInfo(String var1, int var2) throws Exception;

    protected abstract I getBadInfo(String var1, int var2) throws Exception;

    protected abstract String getExistingInfo();

    protected abstract C getConfig() throws Exception;

    protected abstract C getSecondConfig() throws Exception;

    protected abstract Matcher<I> infoEquals(I var1);

    protected abstract Matcher<I> infoEquals(int var1);

    protected abstract void addInfo(C var1, I var2) throws Exception;

    protected abstract Optional<I> getInfo(C var1, String var2) throws Exception;

    protected abstract Collection<? extends I> getInfos(C var1) throws Exception;

    protected abstract Set<String> getInfoNames(C var1) throws Exception;

    protected abstract void removeInfo(C var1, String var2) throws Exception;

    protected abstract void renameInfo(C var1, String var2, String var3) throws Exception;

    protected abstract void modifyInfo(C var1, I var2) throws Exception;

    public void assertNameSetMatchesCollection(C config) throws Exception {
        Set collectionNames = this.getInfos(config).stream().map(Info::getName).collect(Collectors.toSet());
        Set<String> setNames = this.getInfoNames(config);
        Assert.assertThat(setNames, (Matcher)Matchers.equalTo(collectionNames));
    }

    public abstract void failNextRead();

    public abstract void failNextWrite();
}

