/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.BlobStoreConfigurationListener;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationPersistenceException;
import org.geowebcache.config.ConfigurationTest;
import org.geowebcache.storage.UnsuitableStorageException;
import org.geowebcache.util.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BlobStoreConfigurationTest
extends ConfigurationTest<BlobStoreInfo, BlobStoreConfiguration> {
    @Override
    protected void addInfo(BlobStoreConfiguration config, BlobStoreInfo info) throws Exception {
        config.addBlobStore(info);
    }

    @Override
    protected Optional<BlobStoreInfo> getInfo(BlobStoreConfiguration config, String name) throws Exception {
        return config.getBlobStore(name);
    }

    @Override
    protected Collection<? extends BlobStoreInfo> getInfos(BlobStoreConfiguration config) throws Exception {
        return config.getBlobStores();
    }

    @Override
    protected Set<String> getInfoNames(BlobStoreConfiguration config) throws Exception {
        return config.getBlobStoreNames();
    }

    @Override
    protected void removeInfo(BlobStoreConfiguration config, String name) throws Exception {
        config.removeBlobStore(name);
    }

    @Override
    protected void renameInfo(BlobStoreConfiguration config, String oldName, String newName) throws Exception {
        config.renameBlobStore(oldName, newName);
    }

    @Override
    protected void modifyInfo(BlobStoreConfiguration config, BlobStoreInfo info) throws Exception {
        config.modifyBlobStore(info);
    }

    @Test
    public void testRollBackOnUnsuitableStorageExceptionInAddHandler() throws Exception {
        BlobStoreInfo info = (BlobStoreInfo)this.getGoodInfo("test", 1);
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock(BlobStoreConfigurationListener.class);
        listener.handleAddBlobStore(info);
        EasyMock.expectLastCall().andThrow((Throwable)new UnsuitableStorageException("TEST"));
        EasyMock.replay((Object[])new Object[]{listener});
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        this.exception.expect(Matchers.instanceOf(ConfigurationPersistenceException.class));
        this.exception.expectCause(Matchers.instanceOf(UnsuitableStorageException.class));
        try {
            ((BlobStoreConfiguration)this.config).addBlobStore(info);
        }
        catch (Throwable throwable) {
            EasyMock.verify((Object[])new Object[]{listener});
            Assert.assertThat((Object)((BlobStoreConfiguration)this.config).getBlobStore("test"), TestUtils.notPresent());
            throw throwable;
        }
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)((BlobStoreConfiguration)this.config).getBlobStore("test"), TestUtils.notPresent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollBackOnUnsuitableStorageExceptionInModifyHandler() throws Exception {
        BlobStoreInfo info1 = (BlobStoreInfo)this.getGoodInfo("test", 1);
        BlobStoreInfo info2 = (BlobStoreInfo)this.getGoodInfo("test", 2);
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock(BlobStoreConfigurationListener.class);
        listener.handleAddBlobStore(info1);
        EasyMock.expectLastCall();
        listener.handleModifyBlobStore(info2);
        EasyMock.expectLastCall().andThrow((Throwable)new UnsuitableStorageException("TEST"));
        EasyMock.replay((Object[])new Object[]{listener});
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        ((BlobStoreConfiguration)this.config).addBlobStore(info1);
        this.exception.expect(Matchers.instanceOf(ConfigurationPersistenceException.class));
        this.exception.expectCause(Matchers.instanceOf(UnsuitableStorageException.class));
        try {
            ((BlobStoreConfiguration)this.config).modifyBlobStore(info2);
        }
        catch (Throwable throwable) {
            EasyMock.verify((Object[])new Object[]{listener});
            Assert.assertThat((Object)((BlobStoreConfiguration)this.config).getBlobStore("test"), TestUtils.isPresent(this.infoEquals(info1)));
            throw throwable;
        }
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)((BlobStoreConfiguration)this.config).getBlobStore("test"), TestUtils.isPresent(this.infoEquals(info1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollBackOnSupressedUnsuitableStorageExceptionInModifyHandler() throws Exception {
        BlobStoreInfo info1 = (BlobStoreInfo)this.getGoodInfo("test", 1);
        BlobStoreInfo info2 = (BlobStoreInfo)this.getGoodInfo("test", 2);
        IMocksControl control = EasyMock.createControl();
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)control.createMock(BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)control.createMock(BlobStoreConfigurationListener.class);
        control.checkOrder(true);
        listener1.handleAddBlobStore(info1);
        EasyMock.expectLastCall();
        listener2.handleAddBlobStore(info1);
        EasyMock.expectLastCall();
        listener1.handleModifyBlobStore(info2);
        EasyMock.expectLastCall().andThrow((Throwable)new UnsuitableStorageException("TEST"));
        listener2.handleModifyBlobStore(info2);
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Supressing Exception"));
        control.replay();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        ((BlobStoreConfiguration)this.config).addBlobStore(info1);
        this.exception.expect(Matchers.instanceOf(ConfigurationPersistenceException.class));
        this.exception.expectCause(Matchers.instanceOf(IOException.class));
        try {
            ((BlobStoreConfiguration)this.config).modifyBlobStore(info2);
        }
        finally {
            control.verify();
            Assert.assertThat((Object)((BlobStoreConfiguration)this.config).getBlobStore("test"), TestUtils.isPresent(this.infoEquals(info1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollBackOnSupressedUnsuitableStorageExceptionInAddHandler() throws Exception {
        BlobStoreInfo info1 = (BlobStoreInfo)this.getGoodInfo("test", 1);
        IMocksControl control = EasyMock.createControl();
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)control.createMock(BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)control.createMock(BlobStoreConfigurationListener.class);
        control.checkOrder(true);
        listener1.handleAddBlobStore(info1);
        EasyMock.expectLastCall().andThrow((Throwable)new UnsuitableStorageException("TEST"));
        listener2.handleAddBlobStore(info1);
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Supressing Exception"));
        control.replay();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        this.exception.expect(Matchers.instanceOf(ConfigurationPersistenceException.class));
        this.exception.expectCause(Matchers.instanceOf(IOException.class));
        try {
            ((BlobStoreConfiguration)this.config).addBlobStore(info1);
        }
        finally {
            control.verify();
            Assert.assertThat((Object)((BlobStoreConfiguration)this.config).getBlobStore("test"), TestUtils.notPresent());
        }
    }

    @Test
    public void testListenerHearsAdd() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        listener.handleAddBlobStore((BlobStoreInfo)EasyMock.eq((Object)goodInfo));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener});
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerHearsRemove() throws Exception {
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        listener.handleRemoveBlobStore((BlobStoreInfo)EasyMock.eq((Object)goodInfo));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener});
        this.removeInfo((BlobStoreConfiguration)this.config, "test");
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerHearsModify() throws Exception {
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        listener.handleModifyBlobStore((BlobStoreInfo)EasyMock.eq((Object)goodInfo));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener});
        this.doModifyInfo(goodInfo, 2);
        ((BlobStoreConfiguration)this.config).modifyBlobStore(goodInfo);
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerHearsRename() throws Exception {
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        BlobStoreInfo expectedInfo = (BlobStoreInfo)this.getGoodInfo("newName", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        listener.handleRenameBlobStore((String)EasyMock.eq((Object)"test"), (BlobStoreInfo)EasyMock.eq((Object)expectedInfo));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener});
        ((BlobStoreConfiguration)this.config).renameBlobStore("test", "newName");
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testMultipleListenersHearAdd() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener1", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener2", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        listener1.handleAddBlobStore((BlobStoreInfo)EasyMock.eq((Object)goodInfo));
        EasyMock.expectLastCall().once();
        listener2.handleAddBlobStore((BlobStoreInfo)EasyMock.eq((Object)goodInfo));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        EasyMock.verify((Object[])new Object[]{listener1, listener2});
    }

    @Test
    public void testRemoveListener() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener1", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener2", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        ((BlobStoreConfiguration)this.config).removeBlobStoreListener(listener1);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        listener2.handleAddBlobStore((BlobStoreInfo)EasyMock.eq((Object)goodInfo));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        EasyMock.verify((Object[])new Object[]{listener1, listener2});
    }

    @Test
    public void testListenerDoesntHearFailureToAddBadInfo() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        BlobStoreInfo badInfo = (BlobStoreInfo)this.getBadInfo("test", 1);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.addInfo((BlobStoreConfiguration)this.config, badInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToAddDuplicate() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        BlobStoreInfo goodInfo2 = (BlobStoreInfo)this.getGoodInfo("test", 2);
        EasyMock.replay((Object[])new Object[]{listener});
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        try {
            this.addInfo((BlobStoreConfiguration)this.config, goodInfo2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToAddDueToBackend() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        EasyMock.replay((Object[])new Object[]{listener});
        this.failNextWrite();
        try {
            this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToModifyBadInfo() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        BlobStoreInfo badInfo = (BlobStoreInfo)this.getBadInfo("test", 1);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.modifyInfo((BlobStoreConfiguration)this.config, badInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToModifyDoesntExist() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.modifyInfo((BlobStoreConfiguration)this.config, goodInfo);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToModifyDueToBackend() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 2);
        EasyMock.replay((Object[])new Object[]{listener});
        this.failNextWrite();
        try {
            this.modifyInfo((BlobStoreConfiguration)this.config, goodInfo);
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToRemoveDoesntExist() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.removeInfo((BlobStoreConfiguration)this.config, "test");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToRemoveDueToBackend() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        EasyMock.replay((Object[])new Object[]{listener});
        this.failNextWrite();
        try {
            this.removeInfo((BlobStoreConfiguration)this.config, "test");
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToRenameDoesntExist() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.renameInfo((BlobStoreConfiguration)this.config, "test", "test2");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToRenameDuplicate() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        BlobStoreInfo goodInfo2 = (BlobStoreInfo)this.getGoodInfo("test2", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo2);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.renameInfo((BlobStoreConfiguration)this.config, "test", "test2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testListenerDoesntHearFailureToRenameDueToBackend() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        EasyMock.replay((Object[])new Object[]{listener});
        this.failNextWrite();
        try {
            this.removeInfo((BlobStoreConfiguration)this.config, "test");
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testExceptionInAddListenerIsWrapped() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        listener.handleAddBlobStore(goodInfo);
        GeoWebCacheException ex = new GeoWebCacheException("TEST");
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        EasyMock.replay((Object[])new Object[]{listener});
        this.exception.expect(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationPersistenceException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.sameInstance((Object)((Object)ex)))));
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
    }

    @Test
    public void testExceptionInAddListenerNotRolledBack() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        listener.handleAddBlobStore(goodInfo);
        GeoWebCacheException ex = new GeoWebCacheException("TEST");
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        Assert.assertThat(this.getInfo((BlobStoreConfiguration)this.config, "test"), TestUtils.isPresent(Matchers.equalTo((Object)goodInfo)));
    }

    @Test
    public void testExceptionInAddListenerDoesntBlockOtherListeners() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        GeoWebCacheException ex1 = new GeoWebCacheException("TEST1");
        listener1.handleAddBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex1);
        listener2.handleAddBlobStore(goodInfo);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        try {
            this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener2});
    }

    @Test
    public void testExceptionInAddListenerRecordsSuppressedExceptions() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        GeoWebCacheException ex1 = new GeoWebCacheException("TEST1");
        IOException ex2 = new IOException("TEST2");
        listener1.handleAddBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex1);
        listener2.handleAddBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex2);
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        this.exception.expect(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationPersistenceException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.allOf((Matcher)Matchers.sameInstance((Object)ex2), (Matcher)Matchers.hasProperty((String)"suppressed", (Matcher)Matchers.arrayContainingInAnyOrder((Matcher[])new Matcher[]{Matchers.sameInstance((Object)((Object)ex1))}))))));
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
    }

    @Test
    public void testExceptionInModifyListenerIsWrapped() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForModify();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        GeoWebCacheException ex = new GeoWebCacheException("TEST");
        listener.handleModifyBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        EasyMock.replay((Object[])new Object[]{listener});
        this.exception.expect(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationPersistenceException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.sameInstance((Object)((Object)ex)))));
        this.modifyInfo((BlobStoreConfiguration)this.config, goodInfo);
    }

    protected BlobStoreInfo prepForModify() throws Exception {
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 2);
        return goodInfo;
    }

    @Test
    public void testExceptionInModifyListenerNotRolledBack() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForModify();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        GeoWebCacheException ex = new GeoWebCacheException("TEST");
        listener.handleModifyBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.modifyInfo((BlobStoreConfiguration)this.config, goodInfo);
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        Assert.assertThat(this.getInfo((BlobStoreConfiguration)this.config, "test"), TestUtils.isPresent(this.infoEquals(2)));
    }

    @Test
    public void testExceptionInModifyListenerDoesntBlockOtherListeners() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForModify();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        GeoWebCacheException ex1 = new GeoWebCacheException("TEST1");
        listener1.handleModifyBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex1);
        listener2.handleModifyBlobStore(goodInfo);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        try {
            this.modifyInfo((BlobStoreConfiguration)this.config, goodInfo);
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener2});
    }

    @Test
    public void testExceptionInModifyListenerRecordsSuppressedExceptions() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForModify();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        GeoWebCacheException ex1 = new GeoWebCacheException("TEST1");
        IOException ex2 = new IOException("TEST2");
        listener1.handleModifyBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex1);
        listener2.handleModifyBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex2);
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        this.exception.expect(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationPersistenceException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.allOf((Matcher)Matchers.sameInstance((Object)ex2), (Matcher)Matchers.hasProperty((String)"suppressed", (Matcher)Matchers.arrayContainingInAnyOrder((Matcher[])new Matcher[]{Matchers.sameInstance((Object)((Object)ex1))}))))));
        this.modifyInfo((BlobStoreConfiguration)this.config, goodInfo);
    }

    protected BlobStoreInfo prepForRename() throws Exception {
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        goodInfo = (BlobStoreInfo)this.getGoodInfo("test2", 1);
        return goodInfo;
    }

    @Test
    public void testExceptionInRenameListenerIsWrapped() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForRename();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        GeoWebCacheException ex = new GeoWebCacheException("TEST");
        listener.handleRenameBlobStore("test", goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        EasyMock.replay((Object[])new Object[]{listener});
        this.exception.expect(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationPersistenceException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.sameInstance((Object)((Object)ex)))));
        this.renameInfo((BlobStoreConfiguration)this.config, "test", "test2");
    }

    @Test
    public void testExceptionInRenameListenerNotRolledBack() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForRename();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        GeoWebCacheException ex = new GeoWebCacheException("TEST");
        listener.handleRenameBlobStore("test", goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.renameInfo((BlobStoreConfiguration)this.config, "test", "test2");
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        Assert.assertThat(this.getInfo((BlobStoreConfiguration)this.config, "test2"), TestUtils.isPresent(this.infoEquals(goodInfo)));
    }

    @Test
    public void testExceptionInRenameListenerDoesntBlockOtherListeners() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForRename();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        GeoWebCacheException ex1 = new GeoWebCacheException("TEST1");
        listener1.handleRenameBlobStore("test", goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex1);
        listener2.handleRenameBlobStore("test", goodInfo);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        try {
            this.renameInfo((BlobStoreConfiguration)this.config, "test", "test2");
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener2});
    }

    @Test
    public void testExceptionInRenameListenerRecordsSuppressedExceptions() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForRename();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        GeoWebCacheException ex1 = new GeoWebCacheException("TEST1");
        IOException ex2 = new IOException("TEST2");
        listener1.handleRenameBlobStore("test", goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex1);
        listener2.handleRenameBlobStore("test", goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex2);
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        this.exception.expect(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationPersistenceException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.allOf((Matcher)Matchers.sameInstance((Object)ex2), (Matcher)Matchers.hasProperty((String)"suppressed", (Matcher)Matchers.arrayContainingInAnyOrder((Matcher[])new Matcher[]{Matchers.sameInstance((Object)((Object)ex1))}))))));
        this.renameInfo((BlobStoreConfiguration)this.config, "test", "test2");
    }

    protected BlobStoreInfo prepForRemove() throws Exception {
        BlobStoreInfo goodInfo = (BlobStoreInfo)this.getGoodInfo("test", 1);
        this.addInfo((BlobStoreConfiguration)this.config, goodInfo);
        return goodInfo;
    }

    @Test
    public void testExceptionInRemoveListenerIsWrapped() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForRemove();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        GeoWebCacheException ex = new GeoWebCacheException("TEST");
        listener.handleRemoveBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        EasyMock.replay((Object[])new Object[]{listener});
        this.exception.expect(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationPersistenceException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.sameInstance((Object)((Object)ex)))));
        this.removeInfo((BlobStoreConfiguration)this.config, "test");
    }

    @Test
    public void testExceptionInRemoveListenerNotRolledBack() throws Exception {
        BlobStoreConfigurationListener listener = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForRemove();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener);
        GeoWebCacheException ex = new GeoWebCacheException("TEST");
        listener.handleRemoveBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        EasyMock.replay((Object[])new Object[]{listener});
        try {
            this.removeInfo((BlobStoreConfiguration)this.config, "test");
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        Assert.assertThat(this.getInfo((BlobStoreConfiguration)this.config, "test"), TestUtils.notPresent());
    }

    @Test
    public void testExceptionInRemoveListenerDoesntBlockOtherListeners() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForRemove();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        GeoWebCacheException ex1 = new GeoWebCacheException("TEST1");
        listener1.handleRemoveBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex1);
        listener2.handleRemoveBlobStore(goodInfo);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        try {
            this.removeInfo((BlobStoreConfiguration)this.config, "test");
        }
        catch (ConfigurationPersistenceException configurationPersistenceException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{listener2});
    }

    @Test
    public void testExceptionInRemoveListenerRecordsSuppressedExceptions() throws Exception {
        BlobStoreConfigurationListener listener1 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreConfigurationListener listener2 = (BlobStoreConfigurationListener)EasyMock.createMock((String)"listener", BlobStoreConfigurationListener.class);
        BlobStoreInfo goodInfo = this.prepForRemove();
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener1);
        ((BlobStoreConfiguration)this.config).addBlobStoreListener(listener2);
        GeoWebCacheException ex1 = new GeoWebCacheException("TEST1");
        IOException ex2 = new IOException("TEST2");
        listener1.handleRemoveBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex1);
        listener2.handleRemoveBlobStore(goodInfo);
        EasyMock.expectLastCall().andThrow((Throwable)ex2);
        EasyMock.replay((Object[])new Object[]{listener1, listener2});
        this.exception.expect(Matchers.allOf((Matcher)Matchers.instanceOf(ConfigurationPersistenceException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.allOf((Matcher)Matchers.sameInstance((Object)ex2), (Matcher)Matchers.hasProperty((String)"suppressed", (Matcher)Matchers.arrayContainingInAnyOrder((Matcher[])new Matcher[]{Matchers.sameInstance((Object)((Object)ex1))}))))));
        this.removeInfo((BlobStoreConfiguration)this.config, "test");
    }
}

