/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.blobstore.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.geowebcache.storage.blobstore.file.XYZFilePathGenerator;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ZXYFilePathGeneratorTest {
    FilePathGenerator generator;
    File testRoot;
    @Parameterized.Parameter
    public XYZFilePathGenerator.Convention convention;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({XYZFilePathGenerator.Convention.TMS}, {XYZFilePathGenerator.Convention.XYZ});
    }

    @Before
    public void setUp() throws Exception {
        this.testRoot = new File("./target/pathGeneratorTests");
        if (this.testRoot.exists()) {
            this.testRoot.delete();
            FileUtils.deleteDirectory((File)this.testRoot);
        }
        this.testRoot.mkdir();
        TileLayerDispatcher layers = (TileLayerDispatcher)EasyMock.createMock(TileLayerDispatcher.class);
        String name = "states";
        TileLayer mock = (TileLayer)EasyMock.createMock((String)name, TileLayer.class);
        EasyMock.expect((Object)mock.getName()).andStubReturn((Object)name);
        EasyMock.expect((Object)mock.getId()).andStubReturn((Object)name);
        GridSet wgs84Grid = new DefaultGridsets(false, false).worldEpsg4326();
        EasyMock.expect((Object)mock.getGridSubset("EPSG:4326")).andStubReturn((Object)GridSubsetFactory.createGridSubSet((GridSet)wgs84Grid));
        EasyMock.expect((Object)mock.getMimeTypes()).andStubReturn(Arrays.asList(ImageMime.png));
        EasyMock.expect((Object)layers.getTileLayer((String)EasyMock.eq((Object)name))).andStubReturn((Object)mock);
        EasyMock.replay((Object[])new Object[]{layers, mock});
        this.generator = new XYZFilePathGenerator(this.testRoot.getPath(), layers, this.convention);
    }

    @Test
    public void testPathNoParams() throws Exception {
        TileObject tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:4326", (String)"png", null, null);
        File path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        File expected = new File(this.testRoot, "states/EPSG_4326/0/0/0.png");
        Assert.assertEquals((Object)expected, (Object)path);
    }

    @Test
    public void testPathWithParams() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", "population");
        TileObject tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:4326", (String)"png", params, null);
        String sha1 = DigestUtils.sha1Hex((String)"?style=population");
        File path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        this.testParameterId(path, sha1, "?style=population");
        path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        this.testParameterId(path, sha1, "?style=population");
        tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:4326", (String)"png", params, null);
        path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        this.testParameterId(path, sha1, "?style=population");
        params.put("style", "polygon");
        tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:4326", (String)"png", params, null);
        path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        sha1 = DigestUtils.sha1Hex((String)"?style=polygon");
        this.testParameterId(path, sha1, "?style=polygon");
    }

    @Test
    public void testPathTMS() throws Exception {
        Assume.assumeTrue((this.convention == XYZFilePathGenerator.Convention.TMS ? 1 : 0) != 0);
        TileObject tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 2L}, (String)"EPSG:4326", (String)"png", null, null);
        File path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        File expected = new File(this.testRoot, "states/EPSG_4326/2/0/0.png");
        Assert.assertEquals((Object)expected, (Object)path);
    }

    @Test
    public void testPathSlippy() throws Exception {
        Assume.assumeTrue((this.convention == XYZFilePathGenerator.Convention.XYZ ? 1 : 0) != 0);
        TileObject tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 2L}, (String)"EPSG:4326", (String)"png", null, null);
        File path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        File expected = new File(this.testRoot, "states/EPSG_4326/2/0/3.png");
        Assert.assertEquals((Object)expected, (Object)path);
    }

    private void testParameterId(File path, String parameterId, String parameterKvp) throws IOException {
        File expected = new File(this.testRoot, "states/EPSG_4326_" + parameterId + "/0/0/0.png");
        Assert.assertEquals((Object)expected.getPath(), (Object)path.getPath());
    }
}

