/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.blobstore.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.easymock.EasyMock;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.storage.AbstractBlobStoreTest;
import org.geowebcache.storage.blobstore.file.FileBlobStore;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.geowebcache.storage.blobstore.file.XYZFilePathGenerator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XYZFileBlobStoreComformanceTest
extends AbstractBlobStoreTest<FileBlobStore> {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Parameterized.Parameter
    public XYZFilePathGenerator.Convention convention;
    private TileLayerDispatcher layers;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({XYZFilePathGenerator.Convention.TMS}, {XYZFilePathGenerator.Convention.XYZ});
    }

    @Override
    public void createTestUnit() throws Exception {
        this.layers = (TileLayerDispatcher)EasyMock.createMock(TileLayerDispatcher.class);
        GridSet wgs84Grid = new DefaultGridsets(false, false).worldEpsg4326();
        GridSubset gridSubset = GridSubsetFactory.createGridSubSet((GridSet)wgs84Grid);
        Stream.of("testLayer", "testLayer1", "testLayer2").map(name -> {
            TileLayer layer = (TileLayer)EasyMock.createMock((String)name, TileLayer.class);
            EasyMock.expect((Object)layer.getName()).andStubReturn(name);
            EasyMock.expect((Object)layer.getId()).andStubReturn(name);
            EasyMock.expect((Object)layer.getGridSubsets()).andStubReturn(Collections.singleton("testGridSet1"));
            EasyMock.expect((Object)layer.getGridSubset(EasyMock.anyString())).andStubReturn((Object)gridSubset);
            EasyMock.expect((Object)layer.getMimeTypes()).andStubReturn(Arrays.asList(ImageMime.png));
            try {
                EasyMock.expect((Object)this.layers.getTileLayer((String)EasyMock.eq((Object)name))).andStubReturn((Object)layer);
            }
            catch (GeoWebCacheException e) {
                Assert.fail();
            }
            return layer;
        }).forEach(xva$0 -> EasyMock.replay((Object[])new Object[]{xva$0}));
        EasyMock.replay((Object[])new Object[]{this.layers});
        String root = this.temp.getRoot().getAbsolutePath();
        this.store = new FileBlobStore(root, (FilePathGenerator)new XYZFilePathGenerator(root, this.layers, this.convention));
    }
}

