/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.blobstore.file;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.geowebcache.storage.AbstractBlobStoreTest;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.blobstore.file.FileBlobStore;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileBlobStoreComformanceTest
extends AbstractBlobStoreTest<FileBlobStore> {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Override
    public void createTestUnit() throws Exception {
        System.setProperty("gwc.layermetadatastore.waitAfterRename", "75");
        System.setProperty("gwc.layermetadatastore.maxRWAttempts", "100");
        this.store = new FileBlobStore(this.temp.getRoot().getAbsolutePath());
    }

    private void putLayerMetadataConcurrently(int srcStoreKey, FileBlobStore srcStore, int numberOfThreads) throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(numberOfThreads);
        CountDownLatch latch = new CountDownLatch(numberOfThreads);
        int i = 0;
        while (i < numberOfThreads) {
            int key = i++;
            service.submit(() -> {
                try {
                    String threadStoreKey = "store." + srcStoreKey + ".testKey" + String.valueOf(key);
                    String value = "testValue" + String.valueOf(key);
                    srcStore.putLayerMetadata("testLayer", threadStoreKey, value);
                }
                catch (RuntimeException eh) {
                    eh.printStackTrace();
                    throw eh;
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    private void executeStoresConcurrently(int numberOfStores, int numberOfThreads) throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(numberOfStores);
        CountDownLatch latch = new CountDownLatch(numberOfStores);
        int i = 0;
        while (i < numberOfStores) {
            int key = i++;
            service.submit(() -> {
                try {
                    FileBlobStore nStore = new FileBlobStore(this.temp.getRoot().getAbsolutePath());
                    this.putLayerMetadataConcurrently(key, nStore, numberOfThreads);
                }
                catch (InterruptedException | StorageException eh) {
                    eh.printStackTrace();
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    @Test
    public void testMetadataWithPointInKey() throws Exception {
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "test.Key"), (Matcher)Matchers.nullValue());
        ((FileBlobStore)this.store).putLayerMetadata("testLayer", "test.Key", "testValue");
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "test.Key"), (Matcher)Matchers.equalTo((Object)"testValue"));
    }

    @Test
    public void testConcurrentMetadataWithPointInKey() throws InterruptedException {
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "test.Key"), (Matcher)Matchers.nullValue());
        int numberOfThreads = 2;
        ExecutorService service = Executors.newFixedThreadPool(numberOfThreads);
        CountDownLatch latch = new CountDownLatch(numberOfThreads);
        int i = 0;
        while (i < numberOfThreads) {
            int key = i++;
            service.submit(() -> {
                ((FileBlobStore)this.store).putLayerMetadata("testLayer", "test.Key." + String.valueOf(key), "testValue");
                latch.countDown();
            });
        }
        latch.await();
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "test.Key.1"), (Matcher)Matchers.equalTo((Object)"testValue"));
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "test.Key.0"), (Matcher)Matchers.equalTo((Object)"testValue"));
    }

    @Test
    public void testConcurrentMetadataBasedOnCores() throws InterruptedException {
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.nullValue());
        int numberOfStores = 1;
        int numberOfThreads = Runtime.getRuntime().availableProcessors() * 2;
        this.putLayerMetadataConcurrently(numberOfStores, (FileBlobStore)this.store, numberOfThreads);
        String storeKey = "store." + numberOfStores;
        for (int i = 0; i < numberOfThreads; ++i) {
            Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", storeKey + ".testKey" + String.valueOf(i)), (Matcher)Matchers.equalTo((Object)("testValue" + String.valueOf(i))));
        }
    }

    @Ignore
    @Test
    public void testConcurrentMetadataWithTwoStoresCPUThreads() throws InterruptedException, StorageException {
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.nullValue());
        int numberOfStores = 2;
        int numberOfThreads = Runtime.getRuntime().availableProcessors();
        this.executeStoresConcurrently(numberOfStores, numberOfThreads);
        for (int i = 0; i < numberOfStores; ++i) {
            for (int j = 0; j < numberOfThreads; ++j) {
                String storeKey = "store." + i;
                Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", storeKey + ".testKey" + String.valueOf(j)), (Matcher)Matchers.equalTo((Object)("testValue" + String.valueOf(j))));
            }
        }
    }

    @Ignore
    @Test
    public void testConcurrentMetadataWithTwoStoresOneThread() throws InterruptedException, StorageException {
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.nullValue());
        int numberOfStores = 2;
        int numberOfThreads = 1;
        this.executeStoresConcurrently(numberOfStores, numberOfThreads);
        for (int i = 0; i < numberOfStores; ++i) {
            for (int j = 0; j < numberOfThreads; ++j) {
                String storeKey = "store." + i;
                Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", storeKey + ".testKey" + String.valueOf(j)), (Matcher)Matchers.equalTo((Object)("testValue" + String.valueOf(j))));
            }
        }
    }

    @Test
    public void testConcurrentMassiveMetadataKeys() throws InterruptedException {
        Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.nullValue());
        int numberOfThreads = 100;
        int numberOfStores = 1;
        this.putLayerMetadataConcurrently(numberOfStores, (FileBlobStore)this.store, numberOfThreads);
        String storeKey = "store." + numberOfStores;
        for (int i = 0; i < numberOfThreads; ++i) {
            Assert.assertThat((Object)((FileBlobStore)this.store).getLayerMetadata("testLayer", storeKey + ".testKey" + String.valueOf(i)), (Matcher)Matchers.equalTo((Object)("testValue" + String.valueOf(i))));
        }
    }
}

