/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.geowebcache.MockExtensionRule;
import org.geowebcache.util.ApplicationContextProvider;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class MockWepAppContextRule
extends MockExtensionRule {
    ServletContext servletContext;
    Map<String, String> servletInitParameters;

    public MockWepAppContextRule() {
    }

    public MockWepAppContextRule(boolean staticContext) {
        super(staticContext);
    }

    public WebApplicationContext getMockContext() {
        return (WebApplicationContext)super.getMockContext();
    }

    public ApplicationContextProvider getContextProvider() {
        ApplicationContextProvider provider = new ApplicationContextProvider();
        provider.setApplicationContext((ApplicationContext)this.getMockContext());
        return provider;
    }

    @Override
    protected ApplicationContext makeContext() throws IllegalArgumentException {
        this.servletInitParameters = new HashMap<String, String>();
        this.servletContext = (ServletContext)Proxy.newProxyInstance(MockExtensionRule.class.getClassLoader(), new Class[]{ServletContext.class}, (InvocationHandler)new ServletContextInvocationHandler());
        return (ApplicationContext)Proxy.newProxyInstance(MockExtensionRule.class.getClassLoader(), new Class[]{ApplicationContext.class, WebApplicationContext.class}, (InvocationHandler)new WebContextInvocationHandler());
    }

    public static void subContext(Statement statement) throws Exception {
        MockWepAppContextRule subRule = new MockWepAppContextRule(false);
        subRule.apply(statement, Description.EMPTY);
    }

    class ServletContextInvocationHandler
    implements InvocationHandler {
        ServletContextInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getInitParameter")) {
                return MockWepAppContextRule.this.servletInitParameters.get(args[0]);
            }
            throw new UnsupportedOperationException();
        }
    }

    class WebContextInvocationHandler
    extends MockExtensionRule.ContextInvocationHandler {
        WebContextInvocationHandler() {
            super(MockWepAppContextRule.this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getServletContext")) {
                return MockWepAppContextRule.this.servletContext;
            }
            return super.invoke(proxy, method, args);
        }
    }
}

