/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.lang.annotation.Annotation;
import java.util.List;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.MockExtensionRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class MockExtensionRuleTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testRestoresPreviousState() throws Throwable {
        final MockExtensionRule rule = new MockExtensionRule();
        List old = GeoWebCacheExtensions.extensions(Object.class);
        rule.apply(new Statement(){

            public void evaluate() throws Throwable {
                String bean = "THISISTHEBEAN";
                rule.addBean("foo", bean, String.class);
            }
        }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0])).evaluate();
        Assert.assertThat((Object)GeoWebCacheExtensions.extensions(Object.class), (Matcher)Matchers.equalTo((Object)old));
    }

    @Test
    public void testRestoresPreviousStateOnException() throws Throwable {
        final MockExtensionRule rule = new MockExtensionRule();
        List old = GeoWebCacheExtensions.extensions(Object.class);
        try {
            rule.apply(new Statement(){

                public void evaluate() throws Throwable {
                    String bean = "THISISTHEBEAN";
                    rule.addBean("foo", bean, String.class);
                    throw new RuntimeException("TEST EXCEPTION");
                }
            }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0])).evaluate();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertThat((Object)GeoWebCacheExtensions.extensions(Object.class), (Matcher)Matchers.equalTo((Object)old));
    }

    @Test
    public void testPropagatesException() throws Throwable {
        final MockExtensionRule rule = new MockExtensionRule();
        this.exception.expectMessage("TEST EXCEPTION");
        rule.apply(new Statement(){

            public void evaluate() throws Throwable {
                String bean = "THISISTHEBEAN";
                rule.addBean("foo", bean, String.class);
                throw new RuntimeException("TEST EXCEPTION");
            }
        }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0])).evaluate();
    }

    @Test
    public void testAddsNamedBean() throws Throwable {
        final MockExtensionRule rule = new MockExtensionRule();
        List old = GeoWebCacheExtensions.extensions(Object.class);
        rule.apply(new Statement(){

            public void evaluate() throws Throwable {
                String bean = "THISISTHEBEAN";
                rule.addBean("foo", bean, String.class);
                Assert.assertThat((Object)GeoWebCacheExtensions.bean((String)"foo"), (Matcher)Matchers.sameInstance((Object)bean));
            }
        }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0])).evaluate();
        Assert.assertThat((Object)GeoWebCacheExtensions.extensions(Object.class), (Matcher)Matchers.equalTo((Object)old));
    }

    @Test
    public void testAddsTypedBean() throws Throwable {
        final MockExtensionRule rule = new MockExtensionRule();
        List old = GeoWebCacheExtensions.extensions(Object.class);
        rule.apply(new Statement(){

            public void evaluate() throws Throwable {
                String bean = "THISISTHEBEAN";
                rule.addBean("foo", bean, String.class);
                Assert.assertThat((Object)((String)GeoWebCacheExtensions.bean(String.class)), (Matcher)Matchers.sameInstance((Object)bean));
            }
        }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0])).evaluate();
        Assert.assertThat((Object)GeoWebCacheExtensions.extensions(Object.class), (Matcher)Matchers.equalTo((Object)old));
    }

    @Test
    public void testAddsTypedExtension() throws Throwable {
        final MockExtensionRule rule = new MockExtensionRule();
        List old = GeoWebCacheExtensions.extensions(Object.class);
        rule.apply(new Statement(){

            public void evaluate() throws Throwable {
                String bean = "THISISTHEBEAN";
                rule.addBean("foo", bean, String.class);
                Assert.assertThat((Object)GeoWebCacheExtensions.extensions(String.class), (Matcher)Matchers.contains((Matcher)Matchers.sameInstance((Object)bean)));
            }
        }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0])).evaluate();
        Assert.assertThat((Object)GeoWebCacheExtensions.extensions(Object.class), (Matcher)Matchers.equalTo((Object)old));
    }

    @Test
    public void testAddsTypedExtensions() throws Throwable {
        final MockExtensionRule rule = new MockExtensionRule();
        List old = GeoWebCacheExtensions.extensions(Object.class);
        rule.apply(new Statement(){

            public void evaluate() throws Throwable {
                String bean1 = "THISISTHEBEAN";
                String bean2 = "THISISTHEOTHERBEAN";
                String bean3 = "THISISNOTTHERBEAN";
                rule.addBean("foo", bean1, String.class);
                rule.addBean("bar", bean2, String.class);
                rule.addBean("baz", bean3, Double.class);
                Assert.assertThat((Object)GeoWebCacheExtensions.extensions(String.class), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.sameInstance((Object)bean1), Matchers.sameInstance((Object)bean2)}));
            }
        }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0])).evaluate();
        Assert.assertThat((Object)GeoWebCacheExtensions.extensions(Object.class), (Matcher)Matchers.equalTo((Object)old));
    }

    @Test
    public void testParallelRules() throws Throwable {
        final MockExtensionRule rule = new MockExtensionRule();
        final MockExtensionRule rule2 = new MockExtensionRule(false);
        List old = GeoWebCacheExtensions.extensions(Object.class);
        rule.apply(new Statement(){

            public void evaluate() throws Throwable {
                String bean1 = "THISISTHEBEAN";
                final String bean2 = "THISISTHEOTHERBEAN";
                rule.addBean("foo", bean1, String.class);
                rule2.apply(new Statement(){

                    public void evaluate() throws Throwable {
                        rule2.addBean("foo", bean2, String.class);
                        Assert.assertThat((Object)GeoWebCacheExtensions.extensions(String.class), (Matcher)Matchers.contains((Matcher)Matchers.sameInstance((Object)bean2)));
                    }
                }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0]));
                Assert.assertThat((Object)GeoWebCacheExtensions.extensions(String.class), (Matcher)Matchers.contains((Matcher)Matchers.sameInstance((Object)bean1)));
            }
        }, Description.createSuiteDescription((String)"MOCK", (Annotation[])new Annotation[0])).evaluate();
        Assert.assertThat((Object)GeoWebCacheExtensions.extensions(Object.class), (Matcher)Matchers.equalTo((Object)old));
    }
}

