/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.MetastoreRemover;
import org.geowebcache.util.ApplicationContextProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetastoreRemoverTest {
    static final long FIXED_DATE = 1348596000000L;
    File root;

    @Before
    public void setUp() throws Exception {
        this.root = new File("./target/migration");
        File origin = new File("./src/test/resources/org/geowebcache/ms_removal");
        FileUtils.deleteDirectory((File)this.root);
        FileUtils.copyDirectory((File)origin, (File)this.root);
        Iterator it = FileUtils.iterateFiles((File)this.root, (String[])new String[]{"png8", "png", "jpeg"}, (boolean)true);
        while (it.hasNext()) {
            File file = (File)it.next();
            file.setLastModified(1348596000000L);
        }
    }

    @Test
    public void testMigrationNoDates() throws Exception {
        this.testMigration(false);
    }

    @Test
    public void testMigrationWithDates() throws Exception {
        this.testMigration(true);
    }

    protected void testMigration(boolean migrateCreationDates) throws Exception {
        System.setProperty("MIGRATE_CREATION_DATES", String.valueOf(migrateCreationDates));
        new MetastoreRemover(new DefaultStorageFinder(new ApplicationContextProvider()){

            public synchronized String getDefaultPath() throws ConfigurationException {
                return MetastoreRemoverTest.this.root.toString();
            }
        });
        File original1 = new File(this.root, "topp_states/EPSG_4326_03_1/0_1/02_05.png8");
        File transformed1 = new File(this.root, "topp_states/EPSG_4326_03_7510004a12f49fdd49a2ba366e9c4594be7e4358/0_1/02_05.png8");
        Assert.assertFalse((boolean)original1.exists());
        Assert.assertTrue((boolean)transformed1.exists());
        if (migrateCreationDates) {
            Assert.assertTrue((Math.abs((double)transformed1.lastModified() - 1.348596068E12) < 1000.0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)1348596000000L, (long)transformed1.lastModified());
        }
        File original2 = new File(this.root, "topp_states/EPSG_4326_03_2/0_1/02_05.png8");
        File transformed2 = new File(this.root, "topp_states/EPSG_4326_03_f0023dc7bc347fee7a3a04dc797f2223f74e3448/0_1/02_05.png8");
        Assert.assertFalse((boolean)original2.exists());
        Assert.assertTrue((boolean)transformed2.exists());
        if (migrateCreationDates) {
            Assert.assertTrue((Math.abs(transformed2.lastModified() - 1348595993000L) < 1000L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)1348596000000L, (long)transformed1.lastModified());
        }
        File untransformed = new File(this.root, "raster_test_layer/EPSG_900913_01/0_0/00_01.jpeg");
        if (migrateCreationDates) {
            Assert.assertTrue((Math.abs(untransformed.lastModified() - 1348595928000L) < 1000L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)1348596000000L, (long)transformed1.lastModified());
        }
    }
}

