/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang3.SerializationUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.s3.Access;
import org.geowebcache.s3.S3BlobStore;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.StorageException;

public class S3BlobStoreInfo
extends BlobStoreInfo {
    static Logger log = Logging.getLogger((String)S3BlobStoreInfo.class.getName());
    private static final long serialVersionUID = 9072751143836460389L;
    private String bucket;
    private String prefix;
    private String awsAccessKey;
    private String awsSecretKey;
    private Access access = Access.PUBLIC;
    private String maxConnections;
    private String useHTTPS = "true";
    private String proxyDomain;
    private String proxyWorkstation;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String useGzip;
    private String endpoint;

    public S3BlobStoreInfo() {
    }

    public S3BlobStoreInfo(String id) {
        super(id);
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String host) {
        this.endpoint = host;
    }

    @Nullable
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public String getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(String maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getUseHTTPS() {
        return this.useHTTPS;
    }

    public void setUseHTTPS(String useHTTPS) {
        this.useHTTPS = useHTTPS;
    }

    @Nullable
    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    @Nullable
    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public CannedAccessControlList getAccessControlList() {
        CannedAccessControlList accessControlList = this.access == Access.PRIVATE ? CannedAccessControlList.BucketOwnerFullControl : CannedAccessControlList.PublicRead;
        return accessControlList;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public Access getAccess() {
        return this.access;
    }

    public String getUseGzip() {
        return this.useGzip;
    }

    public void setUseGzip(String use) {
        this.useGzip = use;
    }

    public BlobStore createInstance(TileLayerDispatcher layers, LockProvider lockProvider) throws StorageException {
        Preconditions.checkNotNull((Object)layers);
        Preconditions.checkState((this.getName() != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"Can't call S3BlobStoreConfig.createInstance() is blob store is not enabled");
        GeoWebCacheEnvironment gwcEnvironment = (GeoWebCacheEnvironment)GeoWebCacheExtensions.bean(GeoWebCacheEnvironment.class);
        return new S3BlobStore(this.clone(gwcEnvironment, true), layers, lockProvider);
    }

    public S3BlobStoreInfo clone(GeoWebCacheEnvironment gwcEnvironment, Boolean allowEnvParametrization) {
        S3BlobStoreInfo blobStore = (S3BlobStoreInfo)((Object)SerializationUtils.clone((Serializable)((Object)this)));
        if (allowEnvParametrization.booleanValue() && gwcEnvironment != null) {
            blobStore.setName(this.getName());
            blobStore.setEnabled(this.isEnabled());
            blobStore.setDefault(this.isDefault());
            blobStore.setAccess(this.getAccess());
            blobStore.setPrefix(this.nullSafeResolveString(this.getPrefix(), gwcEnvironment));
            blobStore.setUseHTTPS(this.nullSafeResolveString(this.getUseHTTPS(), gwcEnvironment));
            blobStore.setUseGzip(this.nullSafeResolveString(this.getUseGzip(), gwcEnvironment));
            blobStore.setMaxConnections(this.nullSafeResolveString(this.getMaxConnections(), gwcEnvironment));
            blobStore.setProxyPort(this.nullSafeResolveString(this.getProxyPort(), gwcEnvironment));
            blobStore.setBucket(this.nullSafeResolveString(this.getBucket(), gwcEnvironment));
            blobStore.setAwsAccessKey(this.nullSafeResolveString(this.getAwsAccessKey(), gwcEnvironment));
            blobStore.setAwsSecretKey(this.nullSafeResolveString(this.getAwsSecretKey(), gwcEnvironment));
            blobStore.setProxyDomain(this.nullSafeResolveString(this.getProxyDomain(), gwcEnvironment));
            blobStore.setProxyWorkstation(this.nullSafeResolveString(this.getProxyWorkstation(), gwcEnvironment));
            blobStore.setProxyHost(this.nullSafeResolveString(this.getProxyHost(), gwcEnvironment));
            blobStore.setProxyUsername(this.nullSafeResolveString(this.getProxyUsername(), gwcEnvironment));
            blobStore.setProxyPassword(this.nullSafeResolveString(this.getProxyPassword(), gwcEnvironment));
            blobStore.setEndpoint(this.nullSafeResolveString(this.getEndpoint(), gwcEnvironment));
        }
        return blobStore;
    }

    private String nullSafeResolveString(String value, GeoWebCacheEnvironment gwcEnvironment) {
        if (value == null) {
            return null;
        }
        return gwcEnvironment.resolveValue((Object)value).toString();
    }

    private Integer toInteger(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, "Unable to parse S3BlobStoreInfo value: " + value, e);
            return null;
        }
    }

    private Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public String getLocation() {
        String bucket = this.getBucket();
        String prefix = this.getPrefix();
        if (prefix == null) {
            return String.format("bucket: %s", bucket);
        }
        return String.format("bucket: %s prefix: %s", bucket, prefix);
    }

    public AmazonS3Client buildClient() {
        Integer maxConnections;
        ClientConfiguration clientConfig = new ClientConfiguration();
        Boolean useHTTPS = this.toBoolean(this.getUseHTTPS());
        if (null != useHTTPS) {
            clientConfig.setProtocol(useHTTPS != false ? Protocol.HTTPS : Protocol.HTTP);
        }
        if (null != (maxConnections = this.toInteger(this.getMaxConnections())) && maxConnections > 0) {
            clientConfig.setMaxConnections(maxConnections.intValue());
        }
        clientConfig.setProxyDomain(this.proxyDomain);
        clientConfig.setProxyWorkstation(this.proxyWorkstation);
        clientConfig.setProxyHost(this.proxyHost);
        Integer proxyPort = this.toInteger(this.getProxyPort());
        if (null != proxyPort) {
            clientConfig.setProxyPort(proxyPort.intValue());
        }
        clientConfig.setProxyUsername(this.proxyUsername);
        clientConfig.setProxyPassword(this.proxyPassword);
        Boolean useGzip = this.toBoolean(this.getUseGzip());
        if (null != useGzip) {
            clientConfig.setUseGzip(useGzip.booleanValue());
        }
        log.fine("Initializing AWS S3 connection");
        AmazonS3Client client = new AmazonS3Client(this.getCredentialsProvider(), clientConfig);
        if (this.endpoint != null && !"".equals(this.endpoint)) {
            S3ClientOptions s3ClientOptions = new S3ClientOptions();
            s3ClientOptions.setPathStyleAccess(true);
            client.setS3ClientOptions(s3ClientOptions);
            client.setEndpoint(this.endpoint);
        }
        if (!client.doesBucketExist(this.bucket)) {
            client.createBucket(this.bucket);
        }
        return client;
    }

    private AWSCredentialsProvider getCredentialsProvider() {
        if (null != this.awsSecretKey && null != this.awsAccessKey) {
            return new AWSCredentialsProvider(){

                public AWSCredentials getCredentials() {
                    if ("".equals(S3BlobStoreInfo.this.awsAccessKey) && "".equals(S3BlobStoreInfo.this.awsSecretKey)) {
                        return new AnonymousAWSCredentials();
                    }
                    return new BasicAWSCredentials(S3BlobStoreInfo.this.awsAccessKey, S3BlobStoreInfo.this.awsSecretKey);
                }

                public void refresh() {
                }
            };
        }
        return new DefaultAWSCredentialsProviderChain();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.access == null ? 0 : this.access.hashCode());
        result = 31 * result + (this.awsAccessKey == null ? 0 : this.awsAccessKey.hashCode());
        result = 31 * result + (this.awsSecretKey == null ? 0 : this.awsSecretKey.hashCode());
        result = 31 * result + (this.bucket == null ? 0 : this.bucket.hashCode());
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.maxConnections == null ? 0 : this.maxConnections.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.proxyDomain == null ? 0 : this.proxyDomain.hashCode());
        result = 31 * result + (this.proxyHost == null ? 0 : this.proxyHost.hashCode());
        result = 31 * result + (this.proxyPassword == null ? 0 : this.proxyPassword.hashCode());
        result = 31 * result + (this.proxyPort == null ? 0 : this.proxyPort.hashCode());
        result = 31 * result + (this.proxyUsername == null ? 0 : this.proxyUsername.hashCode());
        result = 31 * result + (this.proxyWorkstation == null ? 0 : this.proxyWorkstation.hashCode());
        result = 31 * result + (this.useGzip == null ? 0 : this.useGzip.hashCode());
        result = 31 * result + (this.useHTTPS == null ? 0 : this.useHTTPS.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        S3BlobStoreInfo other = (S3BlobStoreInfo)((Object)obj);
        if (this.access != other.access) {
            return false;
        }
        if (this.awsAccessKey == null ? other.awsAccessKey != null : !this.awsAccessKey.equals(other.awsAccessKey)) {
            return false;
        }
        if (this.awsSecretKey == null ? other.awsSecretKey != null : !this.awsSecretKey.equals(other.awsSecretKey)) {
            return false;
        }
        if (this.bucket == null ? other.bucket != null : !this.bucket.equals(other.bucket)) {
            return false;
        }
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.maxConnections == null ? other.maxConnections != null : !this.maxConnections.equals(other.maxConnections)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.proxyDomain == null ? other.proxyDomain != null : !this.proxyDomain.equals(other.proxyDomain)) {
            return false;
        }
        if (this.proxyHost == null ? other.proxyHost != null : !this.proxyHost.equals(other.proxyHost)) {
            return false;
        }
        if (this.proxyPassword == null ? other.proxyPassword != null : !this.proxyPassword.equals(other.proxyPassword)) {
            return false;
        }
        if (this.proxyPort == null ? other.proxyPort != null : !this.proxyPort.equals(other.proxyPort)) {
            return false;
        }
        if (this.proxyUsername == null ? other.proxyUsername != null : !this.proxyUsername.equals(other.proxyUsername)) {
            return false;
        }
        if (this.proxyWorkstation == null ? other.proxyWorkstation != null : !this.proxyWorkstation.equals(other.proxyWorkstation)) {
            return false;
        }
        if (this.useGzip == null ? other.useGzip != null : !this.useGzip.equals(other.useGzip)) {
            return false;
        }
        return !(this.useHTTPS == null ? other.useHTTPS != null : !this.useHTTPS.equals(other.useHTTPS));
    }

    public String toString() {
        return "S3BlobStoreInfo [bucket=" + this.bucket + ", prefix=" + this.prefix + ", awsAccessKey=" + this.awsAccessKey + ", awsSecretKey=" + this.awsSecretKey + ", access=" + String.valueOf((Object)this.access) + ", maxConnections=" + this.maxConnections + ", useHTTPS=" + this.useHTTPS + ", proxyDomain=" + this.proxyDomain + ", proxyWorkstation=" + this.proxyWorkstation + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", useGzip=" + this.useGzip + ", endpoint=" + this.endpoint + ", getName()=" + this.getName() + ", getId()=" + this.getId() + ", isEnabled()=" + this.isEnabled() + ", isDefault()=" + this.isDefault() + "]";
    }
}

