/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.geowebcache.s3.S3BlobStoreInfo;
import org.junit.rules.ExternalResource;

public class TemporaryS3Folder
extends ExternalResource {
    private Properties properties;
    private String bucket;
    private String accessKey;
    private String secretKey;
    private String temporaryPrefix;
    private AmazonS3Client s3;

    public TemporaryS3Folder(Properties properties) {
        this.properties = properties;
        this.bucket = properties.getProperty("bucket");
        this.accessKey = properties.getProperty("accessKey");
        this.secretKey = properties.getProperty("secretKey");
    }

    protected void before() throws Throwable {
        if (!this.isConfigured()) {
            return;
        }
        this.temporaryPrefix = "tmp_" + UUID.randomUUID().toString().replace("-", "");
        this.s3 = this.getConfig().buildClient();
    }

    protected void after() {
        if (!this.isConfigured()) {
            return;
        }
        try {
            this.delete();
        }
        finally {
            this.temporaryPrefix = null;
            this.s3.shutdown();
        }
    }

    public AmazonS3 getClient() {
        Preconditions.checkState((boolean)this.isConfigured(), (Object)"client not configured.");
        return this.s3;
    }

    public S3BlobStoreInfo getConfig() {
        Preconditions.checkState((boolean)this.isConfigured(), (Object)"client not configured.");
        S3BlobStoreInfo config = new S3BlobStoreInfo();
        config.setBucket(this.bucket);
        config.setAwsAccessKey(this.accessKey);
        config.setAwsSecretKey(this.secretKey);
        config.setPrefix(this.temporaryPrefix);
        if (this.properties.getProperty("endpoint") != null) {
            config.setEndpoint(this.properties.getProperty("endpoint"));
        }
        if (this.properties.getProperty("maxConnections") != null) {
            config.setMaxConnections(this.properties.getProperty("maxConnections"));
        }
        if (this.properties.getProperty("useHTTPS") != null) {
            config.setUseHTTPS(this.properties.getProperty("useHTTPS"));
        }
        if (this.properties.getProperty("proxyDomain") != null) {
            config.setProxyDomain(this.properties.getProperty("proxyDomain"));
        }
        if (this.properties.getProperty("proxyWorkstation") != null) {
            config.setProxyWorkstation(this.properties.getProperty("proxyWorkstation"));
        }
        if (this.properties.getProperty("proxyHost") != null) {
            config.setProxyHost(this.properties.getProperty("proxyHost"));
        }
        if (this.properties.getProperty("proxyPort") != null) {
            config.setProxyPort(this.properties.getProperty("proxyPort"));
        }
        if (this.properties.getProperty("proxyUsername") != null) {
            config.setProxyUsername(this.properties.getProperty("proxyUsername"));
        }
        if (this.properties.getProperty("proxyPassword") != null) {
            config.setProxyPassword(this.properties.getProperty("proxyPassword"));
        }
        if (this.properties.getProperty("useGzip") == null) {
            config.setUseGzip("true");
        } else {
            config.setUseGzip(this.properties.getProperty("useGzip"));
        }
        return config;
    }

    public void delete() {
        Preconditions.checkState((boolean)this.isConfigured(), (Object)"client not configured.");
        if (this.temporaryPrefix == null) {
            return;
        }
        S3Objects objects = S3Objects.withPrefix((AmazonS3)this.s3, (String)this.bucket, (String)this.temporaryPrefix);
        Iterable partition = Iterables.partition((Iterable)objects, (int)1000);
        for (List os : partition) {
            List keys = Lists.transform((List)os, input -> {
                DeleteObjectsRequest.KeyVersion k = new DeleteObjectsRequest.KeyVersion(input.getKey());
                return k;
            });
            DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucket);
            deleteRequest.setKeys(keys);
            this.s3.deleteObjects(deleteRequest);
        }
    }

    public boolean isConfigured() {
        return this.bucket != null && this.accessKey != null && this.secretKey != null;
    }
}

