/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.easymock.EasyMock;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.NoOpLockProvider;
import org.geowebcache.s3.PropertiesLoader;
import org.geowebcache.s3.S3BlobStore;
import org.geowebcache.s3.S3BlobStoreInfo;
import org.geowebcache.s3.TemporaryS3Folder;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreSuitabilityTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.runner.RunWith;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

@RunWith(value=MyTheories.class)
public class S3BlobStoreSuitabilityTest
extends BlobStoreSuitabilityTest {
    public PropertiesLoader testConfigLoader = new PropertiesLoader();
    @Rule
    public TemporaryS3Folder tempFolder = new TemporaryS3Folder(this.testConfigLoader.getProperties());
    @DataPoints
    public static String[][] persistenceLocations = new String[][]{new String[0], {"metadata.properties"}, {"something"}, {"something", "metadata.properties"}, {"something/metadata.properties"}};
    TileLayerDispatcher tld;
    LockProvider locks;

    @Before
    public void setup() throws Exception {
        this.tld = (TileLayerDispatcher)EasyMock.createMock((String)"tld", TileLayerDispatcher.class);
        this.locks = new NoOpLockProvider();
        EasyMock.replay((Object[])new Object[]{this.tld});
    }

    protected Matcher<Object> existing() {
        return Matchers.hasItemInArray((Matcher)Matchers.equalTo((Object)"metadata.properties"));
    }

    protected Matcher<Object> empty() {
        return Matchers.emptyArray();
    }

    public BlobStore create(Object dir) throws Exception {
        S3BlobStoreInfo info = this.tempFolder.getConfig();
        for (String path : (String[])dir) {
            String fullPath = info.getPrefix() + "/" + path;
            try (NullInputStream is = new NullInputStream(0L);){
                this.tempFolder.getClient().putObject(info.getBucket(), fullPath, (InputStream)is, new ObjectMetadata());
            }
        }
        return new S3BlobStore(info, this.tld, this.locks);
    }

    public static class MyTheories
    extends Theories {
        public MyTheories(Class<?> klass) throws InitializationError {
            super(klass);
        }

        public Statement methodBlock(FrameworkMethod method) {
            if (new PropertiesLoader().getProperties().containsKey("bucket")) {
                return super.methodBlock(method);
            }
            return new Statement(){

                public void evaluate() {
                    Assume.assumeFalse((String)"S3 unavailable", (boolean)true);
                }
            };
        }
    }
}

