/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.s3;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.easymock.EasyMock;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.NoOpLockProvider;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.s3.PropertiesLoader;
import org.geowebcache.s3.S3BlobStore;
import org.geowebcache.s3.S3BlobStoreInfo;
import org.geowebcache.s3.TemporaryS3Folder;
import org.geowebcache.storage.AbstractBlobStoreTest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;

public class S3BlobStoreConformanceTest
extends AbstractBlobStoreTest<S3BlobStore> {
    public PropertiesLoader testConfigLoader = new PropertiesLoader();
    @Rule
    public TemporaryS3Folder tempFolder = new TemporaryS3Folder(this.testConfigLoader.getProperties());

    public void createTestUnit() throws Exception {
        Assume.assumeTrue((boolean)this.tempFolder.isConfigured());
        S3BlobStoreInfo config = this.tempFolder.getConfig();
        TileLayerDispatcher layers = (TileLayerDispatcher)EasyMock.createMock(TileLayerDispatcher.class);
        NoOpLockProvider lockProvider = new NoOpLockProvider();
        Stream.of("testLayer", "testLayer1", "testLayer2").map(name -> {
            TileLayer mock = (TileLayer)EasyMock.createMock((String)name, TileLayer.class);
            EasyMock.expect((Object)mock.getName()).andStubReturn(name);
            EasyMock.expect((Object)mock.getId()).andStubReturn(name);
            EasyMock.expect((Object)mock.getGridSubsets()).andStubReturn(Collections.singleton("testGridSet"));
            EasyMock.expect((Object)mock.getMimeTypes()).andStubReturn(Arrays.asList(ImageMime.png));
            try {
                EasyMock.expect((Object)layers.getTileLayer((String)EasyMock.eq((Object)name))).andStubReturn((Object)mock);
            }
            catch (GeoWebCacheException e) {
                Assert.fail();
            }
            return mock;
        }).forEach(xva$0 -> EasyMock.replay((Object[])new Object[]{xva$0}));
        EasyMock.replay((Object[])new Object[]{layers});
        this.store = new S3BlobStore(config, layers, (LockProvider)lockProvider);
    }
}

