/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.s3;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import org.geowebcache.s3.S3BlobStoreConfigProvider;
import org.geowebcache.s3.S3BlobStoreInfo;
import org.geowebcache.util.PropertyRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class S3BlobStoreConfigSerializeTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public PropertyRule envParametrization = PropertyRule.system((String)"ALLOW_ENV_PARAMETRIZATION");
    @Rule
    public PropertyRule awsSecretKey = PropertyRule.system((String)"AWS_SECRET_KEY");
    @Rule
    public PropertyRule awsAccessKey = PropertyRule.system((String)"AWS_ACCESS_KEY");
    @Rule
    public PropertyRule bucket = PropertyRule.system((String)"BUCKET");

    @Test
    public void testNoAccess() throws Exception {
        S3BlobStoreConfigProvider provider = new S3BlobStoreConfigProvider();
        XStream xs = provider.getConfiguredXStream(new XStream());
        S3BlobStoreInfo config = (S3BlobStoreInfo)xs.fromXML("<S3BlobStore><id>test</id><enabled>false</enabled><useHTTPS>true</useHTTPS></S3BlobStore>");
        Assert.assertThat((Object)config, (Matcher)Matchers.hasProperty((String)"accessControlList", (Matcher)Matchers.is((Object)CannedAccessControlList.PublicRead)));
    }

    @Test
    public void testPublicAccess() throws Exception {
        S3BlobStoreConfigProvider provider = new S3BlobStoreConfigProvider();
        XStream xs = provider.getConfiguredXStream(new XStream());
        S3BlobStoreInfo config = (S3BlobStoreInfo)xs.fromXML("<S3BlobStore><id>test</id><enabled>false</enabled><access>PUBLIC</access><useHTTPS>true</useHTTPS></S3BlobStore>");
        Assert.assertThat((Object)config, (Matcher)Matchers.hasProperty((String)"accessControlList", (Matcher)Matchers.is((Object)CannedAccessControlList.PublicRead)));
    }

    @Test
    public void testPrivateAccess() throws Exception {
        S3BlobStoreConfigProvider provider = new S3BlobStoreConfigProvider();
        XStream xs = provider.getConfiguredXStream(new XStream());
        S3BlobStoreInfo config = (S3BlobStoreInfo)xs.fromXML("<S3BlobStore><id>test</id><enabled>false</enabled><access>PRIVATE</access><useHTTPS>true</useHTTPS></S3BlobStore>");
        Assert.assertThat((Object)config, (Matcher)Matchers.hasProperty((String)"accessControlList", (Matcher)Matchers.is((Object)CannedAccessControlList.BucketOwnerFullControl)));
    }

    @Test
    public void testPrivateAccessLowerCase() throws Exception {
        S3BlobStoreConfigProvider provider = new S3BlobStoreConfigProvider();
        XStream xs = provider.getConfiguredXStream(new XStream());
        S3BlobStoreInfo config = (S3BlobStoreInfo)xs.fromXML("<S3BlobStore><id>test</id><enabled>false</enabled><access>private</access><useHTTPS>true</useHTTPS></S3BlobStore>");
        Assert.assertThat((Object)config, (Matcher)Matchers.hasProperty((String)"accessControlList", (Matcher)Matchers.is((Object)CannedAccessControlList.BucketOwnerFullControl)));
    }

    @Test
    public void testPublicAccessLowerCase() throws Exception {
        S3BlobStoreConfigProvider provider = new S3BlobStoreConfigProvider();
        XStream xs = provider.getConfiguredXStream(new XStream());
        S3BlobStoreInfo config = (S3BlobStoreInfo)xs.fromXML("<S3BlobStore><id>test</id><enabled>false</enabled><access>public</access><useHTTPS>true</useHTTPS></S3BlobStore>");
        Assert.assertThat((Object)config, (Matcher)Matchers.hasProperty((String)"accessControlList", (Matcher)Matchers.is((Object)CannedAccessControlList.PublicRead)));
    }

    @Test
    public void testInvalidAccess() throws Exception {
        S3BlobStoreConfigProvider provider = new S3BlobStoreConfigProvider();
        XStream xs = provider.getConfiguredXStream(new XStream());
        this.exception.expect(XStreamException.class);
        xs.fromXML("<S3BlobStore><id>test</id><enabled>false</enabled><access>NOT_A_REAL_ACCESS_TYPE</access><useHTTPS>true</useHTTPS></S3BlobStore>");
    }

    @Test
    public void testAWSKeysNotConverted() throws Exception {
        this.envParametrization.setValue("true");
        this.awsSecretKey.setValue("secret");
        this.awsAccessKey.setValue("access");
        this.bucket.setValue("myBucket");
        S3BlobStoreConfigProvider provider = new S3BlobStoreConfigProvider();
        XStream xs = provider.getConfiguredXStream(new XStream());
        S3BlobStoreInfo config = (S3BlobStoreInfo)xs.fromXML("<S3BlobStore default=\"false\"><id>coviddatavizblob</id><enabled>true</enabled><bucket>${BUCKET}</bucket><prefix>blobpre99</prefix><awsAccessKey>${AWS_ACCESS_KEY}</awsAccessKey><awsSecretKey>${AWS_SECRET_KEY}</awsSecretKey><access>PUBLIC</access><maxConnections>50</maxConnections><useHTTPS>true</useHTTPS><useGzip>false</useGzip></S3BlobStore>");
        Assert.assertThat((Object)config, (Matcher)Matchers.hasProperty((String)"awsSecretKey", (Matcher)Matchers.equalTo((Object)"${AWS_SECRET_KEY}")));
        Assert.assertThat((Object)config, (Matcher)Matchers.hasProperty((String)"awsAccessKey", (Matcher)Matchers.equalTo((Object)"${AWS_ACCESS_KEY}")));
        Assert.assertThat((Object)config, (Matcher)Matchers.hasProperty((String)"bucket", (Matcher)Matchers.equalTo((Object)"${BUCKET}")));
    }
}

