/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.s3;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class PropertiesLoader {
    private static Logger log = Logging.getLogger((String)PropertiesLoader.class.getName());
    private Properties properties = new Properties();

    public PropertiesLoader() {
        String home = System.getProperty("user.home");
        File configFile = new File(home, ".gwc_s3_tests.properties");
        log.info("Loading S3 tests config. File must have keys 'bucket', 'accessKey', and 'secretKey'");
        if (configFile.exists()) {
            try (FileInputStream in = new FileInputStream(configFile);){
                this.properties.load(in);
                Preconditions.checkArgument((null != this.properties.getProperty("bucket") ? 1 : 0) != 0, (Object)("bucket not provided in config file " + configFile.getAbsolutePath()));
                Preconditions.checkArgument((null != this.properties.getProperty("accessKey") ? 1 : 0) != 0, (Object)("accessKey not provided in config file " + configFile.getAbsolutePath()));
                Preconditions.checkArgument((null != this.properties.getProperty("secretKey") ? 1 : 0) != 0, (Object)("secretKey not provided in config file " + configFile.getAbsolutePath()));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error loading S3 tests config: " + configFile.getAbsolutePath(), e);
            }
        } else {
            log.warning("S3 storage config file not found. GWC S3 tests will be ignored. " + configFile.getAbsolutePath());
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

