/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.NoOpLockProvider;
import org.geowebcache.s3.Access;
import org.geowebcache.s3.PropertiesLoader;
import org.geowebcache.s3.S3BlobStoreConfigProvider;
import org.geowebcache.s3.S3BlobStoreInfo;
import org.geowebcache.s3.TemporaryS3Folder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.util.ApplicationContextProvider;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class S3BlobStoreConfigStoreLoadTest {
    private XMLConfiguration config;
    private static final Logger log = Logging.getLogger((String)S3BlobStoreConfigStoreLoadTest.class.getName());
    public PropertiesLoader testConfigLoader = new PropertiesLoader();
    @Rule
    public TemporaryS3Folder tempFolder = new TemporaryS3Folder(this.testConfigLoader.getProperties());
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Mock
    ApplicationContextProvider context;
    @Mock
    TileLayerDispatcher dispatch;
    private File configDir;
    private File configFile;
    @Mock
    private WebApplicationContext webCtx;
    private Map<String, XMLConfigurationProvider> providers;

    @Before
    public void init() {
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public void testSaveLoadS3BlobStoresAccess() throws Exception {
        Assume.assumeTrue((boolean)this.tempFolder.isConfigured());
        this.setupXMLConfig();
        S3BlobStoreInfo store1 = this.createConfig("1");
        S3BlobStoreInfo store2 = this.createConfig("2");
        store2.setAccess(Access.PRIVATE);
        this.saveConfig(store1, store2);
        this.validateAndLoadSavedConfig();
    }

    @Test
    public void testParameterizedS3BlobStore() {
        Assume.assumeTrue((boolean)this.tempFolder.isConfigured());
        GeoWebCacheEnvironment genv = new GeoWebCacheEnvironment();
        genv.setProps(this.testConfigLoader.getProperties());
        S3BlobStoreInfo store = new S3BlobStoreInfo("999");
        store.setDefault(true);
        store.setEnabled(true);
        store.setBucket("${bucket}");
        store.setAwsAccessKey("${accessKey}");
        store.setAwsSecretKey("${secretKey}");
        S3BlobStoreInfo storedData = store.clone(genv, Boolean.valueOf(true));
        Assert.assertEquals((Object)this.testConfigLoader.getProperties().getProperty("bucket"), (Object)storedData.getBucket());
        Assert.assertEquals((Object)this.testConfigLoader.getProperties().getProperty("accessKey"), (Object)storedData.getAwsAccessKey());
        Assert.assertEquals((Object)this.testConfigLoader.getProperties().getProperty("secretKey"), (Object)storedData.getAwsSecretKey());
    }

    private void saveConfig(S3BlobStoreInfo store1, S3BlobStoreInfo store2) throws IOException {
        this.config.addBlobStore((BlobStoreInfo)store1);
        this.config.addBlobStore((BlobStoreInfo)store2);
    }

    private void validateAndLoadSavedConfig() throws SAXException, IOException, ConfigurationException, FileNotFoundException {
        this.validateSavedConfig();
        this.loadSavedConfig();
    }

    private void loadSavedConfig() {
        try {
            XMLConfiguration configLoad = new XMLConfiguration(this.context, this.configDir.getAbsolutePath(), null);
            GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
            configLoad.setGridSetBroker(gridSetBroker);
            configLoad.afterPropertiesSet();
            this.createFromSavedConfig((BlobStoreConfiguration)configLoad);
        }
        catch (GeoWebCacheException | StorageException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            Assert.fail((String)("Error loading from " + String.valueOf(this.configFile) + " " + e.getMessage()));
        }
    }

    private void createFromSavedConfig(BlobStoreConfiguration configLoad) throws StorageException {
        List blobStores2 = configLoad.getBlobStores();
        for (BlobStoreInfo blobStoreConfig : blobStores2) {
            NoOpLockProvider lockProvider = new NoOpLockProvider();
            blobStoreConfig.createInstance(this.dispatch, (LockProvider)lockProvider);
        }
    }

    private void validateSavedConfig() throws SAXException, IOException, ConfigurationException, FileNotFoundException {
        try {
            XMLConfiguration.validate((Node)XMLConfiguration.loadDocument((InputStream)new FileInputStream(this.configFile)));
        }
        catch (SAXParseException e) {
            log.log(Level.SEVERE, e.getMessage());
            Assert.fail((String)("Error validating from " + String.valueOf(this.configFile) + " " + e.getMessage()));
        }
    }

    private S3BlobStoreInfo createConfig(String id) {
        S3BlobStoreInfo store = new S3BlobStoreInfo(id);
        store.setDefault(true);
        store.setEnabled(true);
        Properties properties = this.testConfigLoader.getProperties();
        store.setBucket(properties.getProperty("bucket"));
        store.setAwsAccessKey(properties.getProperty("accessKey"));
        store.setAwsSecretKey(properties.getProperty("secretKey"));
        store.setEndpoint(properties.getProperty("endpoint"));
        return store;
    }

    private void setupXMLConfig() throws IOException, GeoWebCacheException {
        this.configDir = this.temp.getRoot();
        this.configFile = this.temp.newFile("geowebcache.xml");
        URL source = XMLConfiguration.class.getResource("geowebcache_130.xml");
        FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        this.providers = new HashMap<String, XMLConfigurationProvider>();
        Mockito.when((Object)this.context.getApplicationContext()).thenReturn((Object)this.webCtx, (Object[])new WebApplicationContext[]{this.webCtx, this.webCtx, this.webCtx});
        Mockito.when((Object)this.webCtx.getBeansOfType(XMLConfigurationProvider.class)).thenReturn(this.providers, (Object[])new Map[]{this.providers});
        S3BlobStoreConfigProvider provider = new S3BlobStoreConfigProvider();
        Mockito.when((Object)this.webCtx.getBean("S3BlobStore")).thenReturn((Object)provider, new Object[]{provider});
        this.providers.put("S3BlobStore", (XMLConfigurationProvider)provider);
        GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        this.config = new XMLConfiguration(this.context, this.configDir.getAbsolutePath());
        this.config.setGridSetBroker(gridSetBroker);
        this.config.afterPropertiesSet();
    }
}

