/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wps.bindings;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wps10.ComplexDataType;
import net.opengis.wps10.Wps10Factory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.wps.WPS;
import org.geotools.xs.XS;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.EncoderDelegate;
import org.geotools.xsd.Node;

public class ComplexDataTypeBinding
extends AbstractComplexBinding {
    private Wps10Factory factory;

    public ComplexDataTypeBinding(Wps10Factory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return WPS.ComplexDataType;
    }

    public Class<?> getType() {
        return ComplexDataType.class;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        ComplexDataType data = (ComplexDataType)object;
        if ("schema".equals(name.getLocalPart())) {
            return data.getSchema();
        }
        if ("mimeType".equals(name.getLocalPart())) {
            return data.getMimeType();
        }
        if ("encoding".equals(name.getLocalPart())) {
            return data.getEncoding();
        }
        return super.getProperty(object, name);
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ComplexDataType data = this.factory.createComplexDataType();
        if (node.hasAttribute("schema")) {
            data.setSchema(node.getAttributeValue("schema").toString());
        }
        if (node.hasAttribute("mimeType")) {
            data.setMimeType(node.getAttributeValue("mimeType").toString());
        }
        if (node.hasAttribute("encoding")) {
            data.setEncoding(node.getAttributeValue("encoding").toString());
        }
        for (Node c : node.getChildren()) {
            data.getData().add(c.getValue());
        }
        return data;
    }

    public List getProperties(Object object, XSDElementDeclaration element) throws Exception {
        ComplexDataType complex = (ComplexDataType)object;
        if (!complex.getData().isEmpty() && complex.getData().get(0) instanceof EncoderDelegate) {
            EncoderDelegate delegate = (EncoderDelegate)complex.getData().get(0);
            ArrayList<Object[]> properties = new ArrayList<Object[]>();
            properties.add(new Object[]{XS.ANYTYPE, delegate});
            return properties;
        }
        return null;
    }
}

