/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wmts.bindings;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.opengis.ows11.OnlineResourceType;
import net.opengis.ows11.OperationsMetadataType;
import net.opengis.ows11.ServiceIdentificationType;
import net.opengis.ows11.ServiceProviderType;
import net.opengis.wmts.v_1.CapabilitiesType;
import net.opengis.wmts.v_1.ContentsType;
import net.opengis.wmts.v_1.ThemesType;
import net.opengis.wmts.v_1.wmtsv_1Factory;
import org.geotools.wmts.WMTS;
import org.geotools.xsd.AbstractComplexEMFBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;

public class CapabilitiesBinding
extends AbstractComplexEMFBinding {
    wmtsv_1Factory factory;

    public CapabilitiesBinding(wmtsv_1Factory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return WMTS.Capabilities;
    }

    public Class getType() {
        return CapabilitiesType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CapabilitiesType capabilities = this.factory.createCapabilitiesType();
        capabilities.setContents((ContentsType)node.getChildValue(ContentsType.class));
        capabilities.setOperationsMetadata((OperationsMetadataType)node.getChildValue(OperationsMetadataType.class));
        capabilities.setServiceIdentification((ServiceIdentificationType)node.getChildValue(ServiceIdentificationType.class));
        capabilities.setServiceProvider((ServiceProviderType)node.getChildValue(ServiceProviderType.class));
        capabilities.setUpdateSequence((String)node.getChildValue("UpdateSequence"));
        List themesChildren = node.getChildren(ThemesType.class);
        for (Node c : themesChildren) {
            capabilities.getThemes().add((Object)((ThemesType)c.getValue()));
        }
        List children = node.getChildren("ServiceMetadataURL");
        for (Node c : children) {
            capabilities.getServiceMetadataURL().add((Object)((OnlineResourceType)c.getValue()));
        }
        capabilities.getWSDL().addAll((Collection)node.getChildren("WSDL").stream().map(n -> (OnlineResourceType)n.getValue()).collect(Collectors.toList()));
        return capabilities;
    }
}

