/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.gtxml;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.data.DataSourceException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xsd.BindingWalkerFactory;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.BindingFactoryImpl;
import org.geotools.xsd.impl.BindingLoader;
import org.geotools.xsd.impl.BindingWalkerFactoryImpl;
import org.geotools.xsd.impl.NamespaceSupportWrapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.helpers.NamespaceSupport;

class EmfAppSchemaParser {
    EmfAppSchemaParser() {
    }

    public static SimpleFeatureType parse(Configuration configuration, QName featureName, CoordinateReferenceSystem crs) throws IOException {
        XSDElementDeclaration elementDecl = EmfAppSchemaParser.parseFeatureType(featureName, configuration);
        return EmfAppSchemaParser.parse(configuration, elementDecl, crs);
    }

    public static SimpleFeatureType parse(URL schemaLocation, QName featureName, CoordinateReferenceSystem crs) throws IOException {
        String namespaceURI = featureName.getNamespaceURI();
        String uri = schemaLocation.toExternalForm();
        ApplicationSchemaConfiguration configuration = new ApplicationSchemaConfiguration(namespaceURI, uri);
        XSDElementDeclaration elementDecl = EmfAppSchemaParser.parseFeatureType(featureName, (Configuration)configuration);
        return EmfAppSchemaParser.parse((Configuration)configuration, elementDecl, crs);
    }

    public static SimpleFeatureType parse(Configuration configuration, XSDElementDeclaration elementDecl, CoordinateReferenceSystem crs) throws IOException {
        Map bindings = configuration.setupBindings();
        BindingLoader bindingLoader = new BindingLoader(bindings);
        MutablePicoContainer context = configuration.setupContext((MutablePicoContainer)new DefaultPicoContainer());
        NamespaceSupport namespaces = new NamespaceSupport();
        context.registerComponentInstance((Object)namespaces);
        context.registerComponentInstance((Object)new NamespaceSupportWrapper(namespaces));
        BindingFactoryImpl bindingFactory = new BindingFactoryImpl(bindingLoader);
        context.registerComponentInstance((Object)bindingFactory);
        BindingWalkerFactoryImpl bwFactory = new BindingWalkerFactoryImpl(bindingLoader, context);
        context.registerComponentInstance((Object)bwFactory);
        try {
            SimpleFeatureType featureType = GML3ParsingUtils.featureType((XSDElementDeclaration)elementDecl, (BindingWalkerFactory)bwFactory);
            if (crs != null) {
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName(featureType.getName());
                builder.setAbstract(featureType.isAbstract());
                builder.setDescription(featureType.getDescription());
                if (featureType.getSuper() instanceof SimpleFeatureType) {
                    builder.setSuperType((SimpleFeatureType)featureType.getSuper());
                }
                List attributes = featureType.getAttributeDescriptors();
                GeometryDescriptor defaultGeometry = featureType.getGeometryDescriptor();
                for (AttributeDescriptor descriptor : attributes) {
                    if (descriptor instanceof GeometryDescriptor) {
                        String name = descriptor.getLocalName();
                        Class binding = descriptor.getType().getBinding();
                        builder.add(name, binding, crs);
                        continue;
                    }
                    builder.add(descriptor);
                }
                if (defaultGeometry != null) {
                    builder.setDefaultGeometry(defaultGeometry.getLocalName());
                }
                featureType = builder.buildFeatureType();
            }
            return featureType;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            String msg = "Error parsing feature type for " + elementDecl.getName();
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    private static XSDElementDeclaration parseFeatureType(QName featureTypeName, Configuration configuration) throws DataSourceException {
        SchemaIndex schemaIndex;
        try {
            schemaIndex = Schemas.findSchemas((Configuration)configuration);
        }
        catch (RuntimeException e) {
            throw new DataSourceException("Error parsing feature type for " + String.valueOf(featureTypeName), (Throwable)e);
        }
        XSDElementDeclaration elementDeclaration = schemaIndex.getElementDeclaration(featureTypeName);
        schemaIndex.destroy();
        return elementDeclaration;
    }
}

