/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wcs.bindings;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.gml.Gml4wcsFactory;
import net.opengis.gml.TimePositionType;
import net.opengis.wcs10.TimePeriodType;
import net.opengis.wcs10.TimeSequenceType;
import net.opengis.wcs10.Wcs10Factory;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.Position;
import org.geotools.gml3.GML;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.wcs.WCS;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimeSequenceTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return WCS.TimeSequenceType;
    }

    public Class getType() {
        return TimeSequenceType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List timePositions = node.getChildren("timePosition");
        TimeSequenceType results = Wcs10Factory.eINSTANCE.createTimeSequenceType();
        if (timePositions != null && !timePositions.isEmpty()) {
            for (Node timePositionNode : timePositions) {
                TimePositionType timePosition = Gml4wcsFactory.eINSTANCE.createTimePositionType();
                Date positionDate = ((Position)timePositionNode.getValue()).getDate();
                timePosition.setValue((Object)positionDate);
                results.getTimePosition().add((Object)timePosition);
            }
            return results;
        }
        List timePeriods = node.getChildren("timePeriod");
        if (timePeriods != null && !timePeriods.isEmpty()) {
            for (Node timePeriodNode : timePeriods) {
                DefaultInstant begining = new DefaultInstant((Position)timePeriodNode.getChild("beginPosition").getValue());
                DefaultInstant ending = new DefaultInstant((Position)timePeriodNode.getChild("endPosition").getValue());
                TimePeriodType timePeriod = Wcs10Factory.eINSTANCE.createTimePeriodType();
                TimePositionType beginPosition = Gml4wcsFactory.eINSTANCE.createTimePositionType();
                TimePositionType endPosition = Gml4wcsFactory.eINSTANCE.createTimePositionType();
                beginPosition.setValue((Object)begining.getPosition().getDate());
                endPosition.setValue((Object)ending.getPosition().getDate());
                timePeriod.setBeginPosition(beginPosition);
                timePeriod.setEndPosition(endPosition);
                results.getTimePeriod().add((Object)timePeriod);
            }
            return results;
        }
        return null;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        List timeSequence = (List)object;
        if (timeSequence == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", GML.Null.getLocalPart()));
        }
        return null;
    }

    public Object getProperty(Object object, QName name) {
        List timeSequence = (List)object;
        if (timeSequence == null || timeSequence.isEmpty()) {
            return null;
        }
        if (name.getLocalPart().equals("timePeriod") && timeSequence.get(0) instanceof Period) {
            return timeSequence;
        }
        if (name.getLocalPart().equals("timePosition") && timeSequence.get(0) instanceof Position) {
            LinkedList<Position> result = new LinkedList<Position>();
            List cast = timeSequence;
            for (Position position : cast) {
                result.add(position);
            }
            return result;
        }
        return null;
    }
}

