/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml4wcs.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml4wcs.GML;
import org.geotools.gml4wcs.bindings.GML3EncodingUtils;
import org.geotools.gml4wcs.bindings.GML3ParsingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;

public class AbstractGeometryTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.AbstractGeometryType;
    }

    public Class getType() {
        return Geometry.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs;
        if (value instanceof Geometry && (crs = GML3ParsingUtils.crs(node)) != null) {
            Geometry geometry = (Geometry)value;
            geometry.setUserData((Object)crs);
        }
        return value;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        CoordinateReferenceSystem crs;
        Geometry geometry = (Geometry)object;
        if ("srsName".equals(name.getLocalPart()) && (crs = JTS.getCRS((Geometry)geometry)) != null) {
            return GML3EncodingUtils.toURI(crs);
        }
        if (GML.id.equals(name)) {
            return GML3EncodingUtils.getID(geometry);
        }
        if (GML.name.equals(name)) {
            return GML3EncodingUtils.getName(geometry);
        }
        if (GML.description.equals(name)) {
            return GML3EncodingUtils.getDescription(geometry);
        }
        return null;
    }
}

