/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Font;
import org.geotools.api.style.StyleFactory;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

public class SLDFontBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;
    FilterFactory filterFactory;

    public SLDFontBinding(StyleFactory styleFactory, FilterFactory filterFactory) {
        this.styleFactory = styleFactory;
        this.filterFactory = filterFactory;
    }

    public QName getTarget() {
        return SLD.FONT;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Font.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Font font = this.styleFactory.getDefaultFont();
        boolean familyFound = false;
        for (CssParameter css : node.getChildValues(CssParameter.class)) {
            Expression exp = css.getExpression();
            if (exp == null) continue;
            if ("font-family".equals(css.getName())) {
                if (!familyFound) {
                    font.getFamily().set(0, exp);
                    familyFound = true;
                } else {
                    font.getFamily().add(exp);
                }
            }
            if ("font-style".equals(css.getName())) {
                font.setStyle(exp);
            }
            if ("font-weight".equals(css.getName())) {
                font.setWeight(exp);
            }
            if (!"font-size".equals(css.getName())) continue;
            font.setSize(exp);
        }
        return font;
    }
}

