/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Graphic;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.opengis.filter.Filter;
import org.opengis.style.GraphicLegend;
import org.opengis.util.InternationalString;
import org.picocontainer.MutablePicoContainer;

public class SLDRuleBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDRuleBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.RULE;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Rule.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Rule rule = this.styleFactory.createRule();
        if (node.hasChild("Name")) {
            rule.setName((String)node.getChildValue("Name"));
        }
        if (node.hasChild("Title")) {
            rule.getDescription().setTitle((InternationalString)node.getChildValue("Title"));
        }
        if (node.hasChild("Abstract")) {
            rule.getDescription().setAbstract((InternationalString)node.getChildValue("Abstract"));
        }
        if (node.hasChild("LegendGraphic")) {
            rule.setLegend((GraphicLegend)((Graphic)node.getChildValue("LegendGraphic")));
        }
        if (node.hasChild(Filter.class)) {
            rule.setFilter((Filter)node.getChildValue(Filter.class));
        } else if (node.hasChild("ElseFilter")) {
            rule.setElseFilter(true);
        }
        if (node.hasChild("MinScaleDenominator")) {
            rule.setMinScaleDenominator(((Double)node.getChildValue("MinScaleDenominator")).doubleValue());
        }
        if (node.hasChild("MaxScaleDenominator")) {
            rule.setMaxScaleDenominator(((Double)node.getChildValue("MaxScaleDenominator")).doubleValue());
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            rule.getOptions().put(param.getName(), (String)param.getExpression().evaluate(null, String.class));
        }
        List syms = node.getChildValues(Symbolizer.class);
        rule.symbolizers().addAll(syms);
        return rule;
    }
}

