/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.feature.NameImpl;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.StyleFactory;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.opengis.style.SemanticType;
import org.opengis.util.InternationalString;
import org.picocontainer.MutablePicoContainer;

public class SLDFeatureTypeStyleBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDFeatureTypeStyleBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.FEATURETYPESTYLE;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return FeatureTypeStyle.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        FeatureTypeStyle featureTypeStyle = this.styleFactory.createFeatureTypeStyle();
        if (node.hasChild("Name")) {
            featureTypeStyle.setName((String)node.getChildValue("Name"));
        }
        if (node.hasChild("Title")) {
            featureTypeStyle.getDescription().setTitle((InternationalString)node.getChildValue("Title"));
        }
        if (node.hasChild("Abstract")) {
            featureTypeStyle.getDescription().setAbstract((InternationalString)node.getChildValue("Abstract"));
        }
        if (node.hasChild("FeatureTypeName")) {
            Object ftn = node.getChildValue("FeatureTypeName");
            if (ftn instanceof QName) {
                QName qn = (QName)ftn;
                ftn = qn.getPrefix() != null && !"".equals(qn.getPrefix().trim()) ? qn.getPrefix() + ":" + qn.getLocalPart() : qn.getLocalPart();
            }
            featureTypeStyle.featureTypeNames().add(new NameImpl(ftn.toString()));
        }
        if (node.hasChild("SemanticTypeIdentifier")) {
            List ids = node.getChildValues("SemanticTypeIdentifier");
            ids.forEach(id -> featureTypeStyle.semanticTypeIdentifiers().add(SemanticType.valueOf((String)id)));
        }
        if (node.hasChild("Rule")) {
            List rules = node.getChildValues("Rule");
            featureTypeStyle.rules().clear();
            featureTypeStyle.rules().addAll(rules);
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            featureTypeStyle.getOptions().put(param.getName(), (String)param.getExpression().evaluate(null, String.class));
        }
        return featureTypeStyle;
    }
}

